/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.MRAppBenchmark;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Test;

public class MRAppBenchmark {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public void run(MRApp app) throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.WARN);
        long startTime = System.currentTimeMillis();
        Job job = app.submit(new Configuration());
        while (!job.getReport().getJobState().equals((Object)JobState.SUCCEEDED)) {
            this.printStat(job, startTime);
            Thread.sleep(2000L);
        }
        this.printStat(job, startTime);
    }

    private void printStat(Job job, long startTime) throws Exception {
        long currentTime = System.currentTimeMillis();
        Runtime.getRuntime().gc();
        long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.out.println("JobState:" + job.getState() + " CompletedMaps:" + job.getCompletedMaps() + " CompletedReduces:" + job.getCompletedReduces() + " Memory(total-free)(KB):" + mem / 1024L + " ElapsedTime(ms):" + (currentTime - startTime));
    }

    @Test
    public void benchmark1() throws Exception {
        int maps = 100;
        int reduces = 0;
        System.out.println("Running benchmark with maps:" + maps + " reduces:" + reduces);
        this.run((MRApp)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    public void benchmark2() throws Exception {
        int maps = 100;
        int reduces = 50;
        int maxConcurrentRunningTasks = 500;
        System.out.println("Running benchmark with throttled running tasks with maxConcurrentRunningTasks:" + maxConcurrentRunningTasks + " maps:" + maps + " reduces:" + reduces);
        this.run((MRApp)new ThrottledMRApp(maps, reduces, maxConcurrentRunningTasks));
    }

    public static void main(String[] args) throws Exception {
        MRAppBenchmark benchmark = new MRAppBenchmark();
        benchmark.benchmark1();
        benchmark.benchmark2();
    }

    static /* synthetic */ RecordFactory access$100() {
        return recordFactory;
    }
}

