/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.AclEntryStatusFormat;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestINodeAttributeProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestINodeAttributeProvider.class);
    private MiniDFSCluster miniDFS;
    private static final Set<String> CALLED = new HashSet<String>();
    private static final short HDFS_PERMISSION = 511;
    private static final short PROVIDER_PERMISSION = 504;
    private static boolean runPermissionCheck = false;

    @Before
    public void setUp() throws IOException {
        CALLED.clear();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.inode.attributes.provider.class", MyAuthorizationProvider.class.getName());
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.set("dfs.namenode.inode.attributes.provider.bypass.users", " u2,, ,u3, ");
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
        this.miniDFS = new MiniDFSCluster.Builder((Configuration)conf).build();
    }

    @After
    public void cleanUp() throws IOException {
        CALLED.clear();
        if (this.miniDFS != null) {
            this.miniDFS.shutdown();
            this.miniDFS = null;
        }
        runPermissionCheck = false;
        Assert.assertTrue((boolean)CALLED.contains("stop"));
    }

    @Test
    public void testDelegationToProvider() throws Exception {
        Assert.assertTrue((boolean)CALLED.contains("start"));
        FileSystem fs = FileSystem.get((Configuration)this.miniDFS.getConfiguration(0));
        Path tmpPath = new Path("/tmp");
        final Path fooPath = new Path("/tmp/foo");
        fs.mkdirs(tmpPath);
        fs.setPermission(tmpPath, new FsPermission(511));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"u1", (String[])new String[]{"g1"});
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)TestINodeAttributeProvider.this.miniDFS.getConfiguration(0));
                CALLED.clear();
                fs.mkdirs(fooPath);
                Assert.assertTrue((boolean)CALLED.contains("getAttributes"));
                Assert.assertTrue((boolean)CALLED.contains("checkPermission|null|null|null"));
                Assert.assertTrue((boolean)CALLED.contains("checkPermission|WRITE|null|null"));
                CALLED.clear();
                fs.listStatus(fooPath);
                Assert.assertTrue((boolean)CALLED.contains("getAttributes"));
                Assert.assertTrue((boolean)CALLED.contains("checkPermission|null|null|READ_EXECUTE"));
                CALLED.clear();
                fs.getAclStatus(fooPath);
                Assert.assertTrue((boolean)CALLED.contains("getAttributes"));
                Assert.assertTrue((boolean)CALLED.contains("checkPermission|null|null|null"));
                return null;
            }
        });
    }

    private void testBypassProviderHelper(String[] users, final short expectedPermission, boolean bypass) throws Exception {
        final AssertHelper asserter = new AssertHelper(bypass);
        Assert.assertTrue((boolean)CALLED.contains("start"));
        FileSystem fs = FileSystem.get((Configuration)this.miniDFS.getConfiguration(0));
        final Path userPath = new Path("/user");
        Path authz = new Path("/user/authz");
        final Path authzChild = new Path("/user/authz/child2");
        fs.mkdirs(userPath);
        fs.setPermission(userPath, new FsPermission(511));
        fs.mkdirs(authz);
        fs.setPermission(authz, new FsPermission(511));
        fs.mkdirs(authzChild);
        fs.setPermission(authzChild, new FsPermission(511));
        for (String user : users) {
            UserGroupInformation ugiBypass = UserGroupInformation.createUserForTesting((String)user, (String[])new String[]{"g1"});
            ugiBypass.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    FileSystem fs = FileSystem.get((Configuration)TestINodeAttributeProvider.this.miniDFS.getConfiguration(0));
                    Assert.assertEquals((long)expectedPermission, (long)fs.getFileStatus(authzChild).getPermission().toShort());
                    asserter.doAssert(CALLED.contains("getAttributes"));
                    asserter.doAssert(CALLED.contains("checkPermission|null|null|null"));
                    CALLED.clear();
                    Assert.assertEquals((long)expectedPermission, (long)fs.listStatus(userPath)[0].getPermission().toShort());
                    asserter.doAssert(CALLED.contains("getAttributes"));
                    asserter.doAssert(CALLED.contains("checkPermission|null|null|READ_EXECUTE"));
                    CALLED.clear();
                    fs.getAclStatus(authzChild);
                    asserter.doAssert(CALLED.contains("getAttributes"));
                    asserter.doAssert(CALLED.contains("checkPermission|null|null|null"));
                    return null;
                }
            });
        }
    }

    @Test
    public void testAuthzDelegationToProvider() throws Exception {
        LOG.info("Test not bypassing provider");
        String[] users = new String[]{"u1"};
        this.testBypassProviderHelper(users, (short)504, false);
    }

    @Test
    public void testAuthzBypassingProvider() throws Exception {
        LOG.info("Test bypassing provider");
        String[] users = new String[]{"u2", "u3"};
        this.testBypassProviderHelper(users, (short)511, true);
    }

    private void verifyFileStatus(UserGroupInformation ugi) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.miniDFS.getConfiguration(0));
        FileStatus status = fs.getFileStatus(new Path("/"));
        LOG.info("Path '/' is owned by: " + status.getOwner() + ":" + status.getGroup());
        Path userDir = new Path("/user/" + ugi.getShortUserName());
        fs.mkdirs(userDir);
        status = fs.getFileStatus(userDir);
        Assert.assertEquals((Object)ugi.getShortUserName(), (Object)status.getOwner());
        Assert.assertEquals((Object)"supergroup", (Object)status.getGroup());
        Assert.assertEquals((Object)new FsPermission(493), (Object)status.getPermission());
        Path authzDir = new Path("/user/authz");
        fs.mkdirs(authzDir);
        status = fs.getFileStatus(authzDir);
        Assert.assertEquals((Object)"foo", (Object)status.getOwner());
        Assert.assertEquals((Object)"bar", (Object)status.getGroup());
        Assert.assertEquals((Object)new FsPermission(504), (Object)status.getPermission());
        AclStatus aclStatus = fs.getAclStatus(authzDir);
        Assert.assertEquals((long)1L, (long)aclStatus.getEntries().size());
        Assert.assertEquals((Object)AclEntryType.GROUP, (Object)((AclEntry)aclStatus.getEntries().get(0)).getType());
        Assert.assertEquals((Object)"xxx", (Object)((AclEntry)aclStatus.getEntries().get(0)).getName());
        Assert.assertEquals((Object)FsAction.ALL, (Object)((AclEntry)aclStatus.getEntries().get(0)).getPermission());
        Map xAttrs = fs.getXAttrs(authzDir);
        Assert.assertTrue((boolean)xAttrs.containsKey("user.test"));
        Assert.assertEquals((long)2L, (long)((byte[])xAttrs.get("user.test")).length);
    }

    @Test
    public void testCustomProvider() throws Exception {
        UserGroupInformation[] users;
        for (UserGroupInformation user : users = new UserGroupInformation[]{UserGroupInformation.createUserForTesting((String)System.getProperty("user.name"), (String[])new String[]{"supergroup"}), UserGroupInformation.createUserForTesting((String)"normaluser", (String[])new String[]{"normalusergroup"})}) {
            user.doAs(() -> {
                this.verifyFileStatus(user);
                return null;
            });
        }
    }

    @Test
    public void testAclFeature() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"testuser", (String[])new String[]{"testgroup"});
        ugi.doAs(() -> {
            DistributedFileSystem fs = this.miniDFS.getFileSystem();
            Path aclDir = new Path("/user/acl");
            fs.mkdirs(aclDir);
            Path aclChildDir = new Path(aclDir, "subdir");
            fs.mkdirs(aclChildDir);
            AclStatus aclStatus = fs.getAclStatus(aclDir);
            Assert.assertEquals((long)0L, (long)aclStatus.getEntries().size());
            return null;
        });
    }

    @Test
    public void testGetAclStatusReturnsProviderOwnerPerms() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.miniDFS.getConfiguration(0));
        Path userPath = new Path("/user");
        Path authz = new Path("/user/authz");
        final Path authzChild = new Path("/user/authz/child2");
        fs.mkdirs(userPath);
        fs.setPermission(userPath, new FsPermission(511));
        fs.mkdirs(authz);
        fs.setPermission(authz, new FsPermission(511));
        fs.mkdirs(authzChild);
        fs.setPermission(authzChild, new FsPermission(511));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"u1", (String[])new String[]{"g1"});
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)TestINodeAttributeProvider.this.miniDFS.getConfiguration(0));
                Assert.assertEquals((long)504L, (long)fs.getFileStatus(authzChild).getPermission().toShort());
                Assert.assertEquals((Object)"foo", (Object)fs.getAclStatus(authzChild).getOwner());
                Assert.assertEquals((Object)"bar", (Object)fs.getAclStatus(authzChild).getGroup());
                Assert.assertEquals((long)504L, (long)fs.getAclStatus(authzChild).getPermission().toShort());
                return null;
            }
        });
    }

    @Test
    public void testContentSummary() throws Exception {
        runPermissionCheck = true;
        FileSystem fs = FileSystem.get((Configuration)this.miniDFS.getConfiguration(0));
        Path userPath = new Path("/user");
        final Path authz = new Path("/user/authz");
        Path authzChild = new Path("/user/authz/child2");
        fs.mkdirs(userPath);
        fs.setPermission(userPath, new FsPermission(511));
        fs.mkdirs(authz);
        fs.setPermission(authz, new FsPermission(448));
        fs.mkdirs(authzChild);
        fs.setPermission(authzChild, new FsPermission(448));
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[]{"g1"});
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                FileSystem fs = FileSystem.get((Configuration)TestINodeAttributeProvider.this.miniDFS.getConfiguration(0));
                fs.getContentSummary(authz);
                return null;
            }
        });
    }

    private class AssertHelper {
        private boolean bypass = true;

        AssertHelper(boolean bp) {
            this.bypass = bp;
        }

        public void doAssert(boolean x) {
            if (this.bypass) {
                Assert.assertFalse((boolean)x);
            } else {
                Assert.assertTrue((boolean)x);
            }
        }
    }

    public static class MyAuthorizationProvider
    extends INodeAttributeProvider {
        public void start() {
            CALLED.add("start");
        }

        public void stop() {
            CALLED.add("stop");
        }

        public INodeAttributes getAttributes(String[] pathElements, final INodeAttributes inode) {
            CALLED.add("getAttributes");
            final boolean useDefault = this.useDefault(pathElements);
            final boolean useNullAcl = this.useNullAclFeature(pathElements);
            return new INodeAttributes(){

                public boolean isDirectory() {
                    return inode.isDirectory();
                }

                public byte[] getLocalNameBytes() {
                    return inode.getLocalNameBytes();
                }

                public String getUserName() {
                    return useDefault ? inode.getUserName() : "foo";
                }

                public String getGroupName() {
                    return useDefault ? inode.getGroupName() : "bar";
                }

                public FsPermission getFsPermission() {
                    return useDefault ? inode.getFsPermission() : new FsPermission(this.getFsPermissionShort());
                }

                public short getFsPermissionShort() {
                    return useDefault ? inode.getFsPermissionShort() : (short)this.getPermissionLong();
                }

                public long getPermissionLong() {
                    return useDefault ? inode.getPermissionLong() : 504L;
                }

                public AclFeature getAclFeature() {
                    AclFeature f;
                    if (useNullAcl) {
                        int[] entries = new int[]{};
                        f = new AclFeature(entries);
                    } else if (useDefault) {
                        f = inode.getAclFeature();
                    } else {
                        AclEntry acl = new AclEntry.Builder().setType(AclEntryType.GROUP).setPermission(FsAction.ALL).setName("xxx").build();
                        f = new AclFeature(AclEntryStatusFormat.toInt((List)Lists.newArrayList((Object[])new AclEntry[]{acl})));
                    }
                    return f;
                }

                public XAttrFeature getXAttrFeature() {
                    XAttrFeature x = useDefault ? inode.getXAttrFeature() : new XAttrFeature((List)ImmutableList.copyOf((Collection)Lists.newArrayList((Object[])new XAttr[]{new XAttr.Builder().setName("test").setValue(new byte[]{1, 2}).build()})));
                    return x;
                }

                public long getModificationTime() {
                    return useDefault ? inode.getModificationTime() : 0L;
                }

                public long getAccessTime() {
                    return useDefault ? inode.getAccessTime() : 0L;
                }
            };
        }

        public INodeAttributeProvider.AccessControlEnforcer getExternalAccessControlEnforcer(INodeAttributeProvider.AccessControlEnforcer defaultEnforcer) {
            return new MyAccessControlEnforcer(defaultEnforcer);
        }

        private boolean useDefault(String[] pathElements) {
            return !Arrays.stream(pathElements).anyMatch("authz"::equals);
        }

        private boolean useNullAclFeature(String[] pathElements) {
            return pathElements.length > 2 && pathElements[1].equals("user") && pathElements[2].equals("acl");
        }

        public static class MyAccessControlEnforcer
        implements INodeAttributeProvider.AccessControlEnforcer {
            INodeAttributeProvider.AccessControlEnforcer ace;

            public MyAccessControlEnforcer(INodeAttributeProvider.AccessControlEnforcer defaultEnforcer) {
                this.ace = defaultEnforcer;
            }

            public void checkPermission(String fsOwner, String supergroup, UserGroupInformation ugi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
                if (ancestorIndex > 1 && inodes[1].getLocalName().equals("user") && inodes[2].getLocalName().equals("acl") || runPermissionCheck) {
                    this.ace.checkPermission(fsOwner, supergroup, ugi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir);
                }
                CALLED.add("checkPermission|" + ancestorAccess + "|" + parentAccess + "|" + access);
            }

            public void checkPermissionWithContext(INodeAttributeProvider.AuthorizationContext authzContext) throws AccessControlException {
                if (authzContext.getAncestorIndex() > 1 && authzContext.getInodes()[1].getLocalName().equals("user") && authzContext.getInodes()[2].getLocalName().equals("acl")) {
                    this.ace.checkPermissionWithContext(authzContext);
                }
                CALLED.add("checkPermission|" + authzContext.getAncestorAccess() + "|" + authzContext.getParentAccess() + "|" + authzContext.getAccess());
            }
        }
    }
}

