/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.base.Supplier;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HdfsBlockLocation;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.impl.BlockReaderTestUtil;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetCache;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.PmemVolumeManager;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestCacheByPmemMappableBlockLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(TestCacheByPmemMappableBlockLoader.class);
    protected static final long CACHE_CAPACITY = 65536L;
    protected static final long BLOCK_SIZE = 4096L;
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem fs;
    private static DataNode dn;
    private static FsDatasetCache cacheManager;
    private static ReadWriteLock lock;
    private static NativeIO.POSIX.CacheManipulator prevCacheManipulator;
    private static DataNodeFaultInjector oldInjector;
    private static final String PMEM_DIR_0;
    private static final String PMEM_DIR_1;

    @BeforeClass
    public static void setUpClass() throws Exception {
        oldInjector = DataNodeFaultInjector.get();
        DataNodeFaultInjector.set((DataNodeFaultInjector)new DataNodeFaultInjector(){

            public void startOfferService() throws Exception {
                lock.readLock().lock();
            }

            public void endOfferService() throws Exception {
                lock.readLock().unlock();
            }
        });
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        DataNodeFaultInjector.set((DataNodeFaultInjector)oldInjector);
    }

    @Before
    public void setUp() throws Exception {
        conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.path.based.cache.refresh.interval.ms", 100L);
        conf.setLong("dfs.cachereport.intervalMsec", 500L);
        conf.setLong("dfs.blocksize", 4096L);
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setInt("dfs.datanode.fsdatasetcache.max.threads.per.volume", 10);
        new File(PMEM_DIR_0).getAbsoluteFile().mkdir();
        new File(PMEM_DIR_1).getAbsoluteFile().mkdir();
        conf.set("dfs.datanode.pmem.cache.dirs", PMEM_DIR_0 + "," + PMEM_DIR_1);
        PmemVolumeManager.setMaxBytes((long)32768L);
        prevCacheManipulator = NativeIO.POSIX.getCacheManipulator();
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)new NativeIO.POSIX.NoMlockCacheManipulator());
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
        dn = cluster.getDataNodes().get(0);
        cacheManager = ((FsDatasetImpl)TestCacheByPmemMappableBlockLoader.dn.getFSDataset()).cacheManager;
    }

    @After
    public void tearDown() throws Exception {
        if (fs != null) {
            fs.close();
            fs = null;
        }
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
        NativeIO.POSIX.setCacheManipulator((NativeIO.POSIX.CacheManipulator)prevCacheManipulator);
    }

    protected static void shutdownCluster() {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testPmemVolumeManager() throws IOException {
        PmemVolumeManager pmemVolumeManager = PmemVolumeManager.getInstance();
        Assert.assertNotNull((Object)pmemVolumeManager);
        Assert.assertEquals((long)65536L, (long)pmemVolumeManager.getCacheCapacity());
        long count1 = 0L;
        long count2 = 0L;
        for (int i = 0; i < 10; ++i) {
            Byte index = pmemVolumeManager.chooseVolume(4096L);
            String volume = pmemVolumeManager.getVolumeByIndex(index);
            if (volume.equals(PmemVolumeManager.getRealPmemDir((String)PMEM_DIR_0))) {
                ++count1;
                continue;
            }
            if (volume.equals(PmemVolumeManager.getRealPmemDir((String)PMEM_DIR_1))) {
                ++count2;
                continue;
            }
            Assert.fail((String)("Unexpected persistent storage location:" + volume));
        }
        Assert.assertEquals((long)count1, (long)count2);
    }

    public List<ExtendedBlockId> getExtendedBlockId(Path filePath, long fileLen) throws IOException {
        HdfsBlockLocation[] locs;
        ArrayList<ExtendedBlockId> keys = new ArrayList<ExtendedBlockId>();
        for (HdfsBlockLocation loc : locs = (HdfsBlockLocation[])fs.getFileBlockLocations(filePath, 0L, fileLen)) {
            long bkid = loc.getLocatedBlock().getBlock().getBlockId();
            String bpid = loc.getLocatedBlock().getBlock().getBlockPoolId();
            keys.add(new ExtendedBlockId(bkid, bpid));
        }
        return keys;
    }

    @Test(timeout=60000L)
    public void testCacheAndUncache() throws Exception {
        final int maxCacheBlocksNum = Ints.checkedCast((long)16L);
        BlockReaderTestUtil.enableHdfsCachingTracing();
        Assert.assertEquals((long)0L, (long)0L);
        Assert.assertEquals((long)65536L, (long)cacheManager.getCacheCapacity());
        Assert.assertEquals((long)0L, (long)cacheManager.getMemCacheCapacity());
        Path testFile = new Path("/testFile");
        long testFileLen = (long)maxCacheBlocksNum * 4096L;
        DFSTestUtil.createFile((FileSystem)fs, testFile, testFileLen, (short)1, 48879L);
        List<ExtendedBlockId> blockKeys = this.getExtendedBlockId(testFile, testFileLen);
        fs.addCachePool(new CachePoolInfo("testPool"));
        long cacheDirectiveId = fs.addCacheDirective(new CacheDirectiveInfo.Builder().setPool("testPool").setPath(testFile).setReplication(Short.valueOf((short)1)).build());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                MetricsRecordBuilder dnMetrics = MetricsAsserts.getMetrics((String)dn.getMetrics().name());
                long blocksCached = MetricsAsserts.getLongCounter((String)"BlocksCached", (MetricsRecordBuilder)dnMetrics);
                if (blocksCached != (long)maxCacheBlocksNum) {
                    LOG.info("waiting for " + maxCacheBlocksNum + " blocks to be cached. Right now " + blocksCached + " blocks are cached.");
                    return false;
                }
                LOG.info(maxCacheBlocksNum + " blocks are now cached.");
                return true;
            }
        }, (long)1000L, (long)30000L);
        Assert.assertEquals((long)65536L, (long)cacheManager.getCacheUsed());
        Assert.assertEquals((long)0L, (long)cacheManager.getMemCacheUsed());
        Map blockKeyToVolume = PmemVolumeManager.getInstance().getBlockKeyToVolume();
        Assert.assertEquals((long)blockKeyToVolume.size(), (long)maxCacheBlocksNum);
        Assert.assertTrue((boolean)blockKeyToVolume.keySet().containsAll(blockKeys));
        for (ExtendedBlockId key : blockKeys) {
            String expectPath;
            String cachePath = cacheManager.getReplicaCachePath(key.getBlockPoolId(), key.getBlockId());
            Assert.assertNotNull((Object)cachePath);
            Path path = new Path(cachePath);
            String fileName = path.getName();
            if (cachePath.startsWith(PMEM_DIR_0)) {
                expectPath = PmemVolumeManager.getRealPmemDir((String)PMEM_DIR_0) + "/" + key.getBlockPoolId();
                Assert.assertTrue((boolean)path.toString().startsWith(expectPath));
                Assert.assertTrue((key.getBlockId() == Long.parseLong(fileName) ? 1 : 0) != 0);
                continue;
            }
            if (cachePath.startsWith(PMEM_DIR_1)) {
                expectPath = PmemVolumeManager.getRealPmemDir((String)PMEM_DIR_1) + "/" + key.getBlockPoolId();
                Assert.assertTrue((boolean)path.toString().startsWith(expectPath));
                Assert.assertTrue((key.getBlockId() == Long.parseLong(fileName) ? 1 : 0) != 0);
                continue;
            }
            Assert.fail((String)("The cache path is not the expected one: " + cachePath));
        }
        Path smallTestFile = new Path("/smallTestFile");
        long smallTestFileLen = 4096L;
        DFSTestUtil.createFile((FileSystem)fs, smallTestFile, 4096L, (short)1, 48879L);
        long smallFileCacheDirectiveId = fs.addCacheDirective(new CacheDirectiveInfo.Builder().setPool("testPool").setPath(smallTestFile).setReplication(Short.valueOf((short)1)).build());
        Thread.sleep(10000L);
        MetricsRecordBuilder dnMetrics = MetricsAsserts.getMetrics((String)dn.getMetrics().name());
        long blocksCached = MetricsAsserts.getLongCounter((String)"BlocksCached", (MetricsRecordBuilder)dnMetrics);
        Assert.assertTrue((blocksCached == (long)maxCacheBlocksNum ? 1 : 0) != 0);
        Assert.assertEquals((long)blockKeyToVolume.size(), (long)maxCacheBlocksNum);
        Assert.assertTrue((boolean)blockKeyToVolume.keySet().containsAll(blockKeys));
        fs.removeCacheDirective(smallFileCacheDirectiveId);
        fs.removeCacheDirective(cacheDirectiveId);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                MetricsRecordBuilder dnMetrics = MetricsAsserts.getMetrics((String)dn.getMetrics().name());
                long blocksUncached = MetricsAsserts.getLongCounter((String)"BlocksUncached", (MetricsRecordBuilder)dnMetrics);
                if (blocksUncached != (long)maxCacheBlocksNum) {
                    LOG.info("waiting for " + maxCacheBlocksNum + " blocks to be uncached. Right now " + blocksUncached + " blocks are uncached.");
                    return false;
                }
                LOG.info(maxCacheBlocksNum + " blocks have been uncached.");
                return true;
            }
        }, (long)1000L, (long)30000L);
        Assert.assertEquals((long)0L, (long)cacheManager.getCacheUsed());
        Assert.assertEquals((long)blockKeyToVolume.size(), (long)0L);
    }

    static {
        cluster = null;
        lock = new ReentrantReadWriteLock(true);
        PMEM_DIR_0 = MiniDFSCluster.getBaseDirectory() + "pmem0";
        PMEM_DIR_1 = MiniDFSCluster.getBaseDirectory() + "pmem1";
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(FsDatasetCache.class), (Level)Level.DEBUG);
    }
}

