/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlockInfo {
    private static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hdfs.TestBlockInfo");

    @Test
    public void testIsDeleted() {
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(3);
        BlockCollection bc = (BlockCollection)Mockito.mock(BlockCollection.class);
        blockInfo.setBlockCollectionId(1000L);
        Assert.assertFalse((boolean)blockInfo.isDeleted());
        blockInfo.setBlockCollectionId(-1L);
        Assert.assertTrue((boolean)blockInfo.isDeleted());
    }

    @Test
    public void testAddStorage() throws Exception {
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(3);
        DatanodeStorageInfo storage = DFSTestUtil.createDatanodeStorageInfo("storageID", "127.0.0.1");
        boolean added = blockInfo.addStorage(storage, (Block)blockInfo);
        Assert.assertTrue((boolean)added);
        Assert.assertEquals((Object)storage, (Object)blockInfo.getStorageInfo(0));
    }

    @Test
    public void testAddProvidedStorage() throws Exception {
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(3);
        DatanodeStorageInfo providedStorage = (DatanodeStorageInfo)Mockito.mock(DatanodeStorageInfo.class);
        Mockito.when((Object)providedStorage.getStorageType()).thenReturn((Object)StorageType.PROVIDED);
        boolean added = blockInfo.addStorage(providedStorage, (Block)blockInfo);
        Assert.assertTrue((boolean)added);
        Assert.assertEquals((Object)providedStorage, (Object)blockInfo.getStorageInfo(0));
        Assert.assertTrue((boolean)blockInfo.isProvided());
    }

    @Test
    public void testAddTwoStorageTypes() throws Exception {
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(3);
        DatanodeStorageInfo diskStorage = (DatanodeStorageInfo)Mockito.mock(DatanodeStorageInfo.class);
        DatanodeDescriptor mockDN = (DatanodeDescriptor)Mockito.mock(DatanodeDescriptor.class);
        Mockito.when((Object)diskStorage.getDatanodeDescriptor()).thenReturn((Object)mockDN);
        Mockito.when((Object)diskStorage.getStorageType()).thenReturn((Object)StorageType.DISK);
        boolean added = blockInfo.addStorage(diskStorage, (Block)blockInfo);
        Assert.assertTrue((boolean)added);
        Assert.assertEquals((Object)diskStorage, (Object)blockInfo.getStorageInfo(0));
        Assert.assertFalse((boolean)blockInfo.isProvided());
        DatanodeStorageInfo providedStorage = (DatanodeStorageInfo)Mockito.mock(DatanodeStorageInfo.class);
        Mockito.when((Object)providedStorage.getStorageType()).thenReturn((Object)StorageType.PROVIDED);
        added = blockInfo.addStorage(providedStorage, (Block)blockInfo);
        Assert.assertTrue((boolean)added);
        Assert.assertTrue((boolean)blockInfo.isProvided());
    }

    @Test
    public void testReplaceStorage() throws Exception {
        DatanodeStorageInfo storage1 = DFSTestUtil.createDatanodeStorageInfo("storageID1", "127.0.0.1");
        DatanodeStorageInfo storage2 = new DatanodeStorageInfo(storage1.getDatanodeDescriptor(), new DatanodeStorage("storageID2"));
        int NUM_BLOCKS = 10;
        BlockInfo[] blockInfos = new BlockInfo[10];
        for (int i = 0; i < 10; ++i) {
            blockInfos[i] = new BlockInfoContiguous(3);
            storage1.addBlock(blockInfos[i]);
        }
        boolean added = storage2.addBlock(blockInfos[5]) == DatanodeStorageInfo.AddBlockResult.ADDED;
        Assert.assertThat((Object)added, (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)blockInfos[5].getStorageInfo(0), (Matcher)Is.is((Object)storage2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddStorageWithDifferentBlock() throws Exception {
        BlockInfoContiguous blockInfo1 = new BlockInfoContiguous(new Block(1000L), 3);
        BlockInfoContiguous blockInfo2 = new BlockInfoContiguous(new Block(1001L), 3);
        DatanodeStorageInfo storage = DFSTestUtil.createDatanodeStorageInfo("storageID", "127.0.0.1");
        blockInfo1.addStorage(storage, (Block)blockInfo2);
    }
}

