/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.BackupImage;
import org.apache.hadoop.hdfs.server.namenode.BackupNode;
import org.apache.hadoop.hdfs.server.namenode.Checkpointer;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TestCheckpoint;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.ServerSocketUtil;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestBackupNode {
    public static final Logger LOG = LoggerFactory.getLogger(TestBackupNode.class);
    static final String BASE_DIR;
    static final long seed = 3735928559L;
    static final int blockSize = 4096;
    static final int fileSize = 8192;

    @Before
    public void setUp() throws Exception {
        File baseDir = new File(BASE_DIR);
        if (baseDir.exists() && !FileUtil.fullyDelete((File)baseDir)) {
            throw new IOException("Cannot remove directory: " + baseDir);
        }
        File dirC = new File(TestBackupNode.getBackupNodeDir(HdfsServerConstants.StartupOption.CHECKPOINT, 1));
        dirC.mkdirs();
        File dirB = new File(TestBackupNode.getBackupNodeDir(HdfsServerConstants.StartupOption.BACKUP, 1));
        dirB.mkdirs();
        dirB = new File(TestBackupNode.getBackupNodeDir(HdfsServerConstants.StartupOption.BACKUP, 2));
        dirB.mkdirs();
    }

    static String getBackupNodeDir(HdfsServerConstants.StartupOption t, int idx) {
        return BASE_DIR + "name" + t.getName() + idx + "/";
    }

    BackupNode startBackupNode(Configuration conf, HdfsServerConstants.StartupOption startupOpt, int idx) throws IOException {
        HdfsConfiguration c = new HdfsConfiguration(conf);
        String dirs = TestBackupNode.getBackupNodeDir(startupOpt, idx);
        c.set("dfs.namenode.name.dir", dirs);
        c.set("dfs.namenode.edits.dir", "${dfs.namenode.name.dir}");
        c.set("dfs.namenode.backup.address", "127.0.0.1:0");
        c.set("dfs.namenode.backup.http-address", "127.0.0.1:0");
        BackupNode bn = (BackupNode)NameNode.createNameNode((String[])new String[]{startupOpt.getName()}, (Configuration)c);
        Assert.assertTrue((String)(bn.getRole() + " must be in SafeMode."), (boolean)bn.isInSafeMode());
        Assert.assertTrue((String)(bn.getRole() + " must be in StandbyState"), (boolean)bn.getNamesystem().getHAState().equalsIgnoreCase(HAServiceProtocol.HAServiceState.STANDBY.name()));
        return bn;
    }

    void waitCheckpointDone(MiniDFSCluster cluster, long txid) {
        long thisCheckpointTxId;
        do {
            try {
                LOG.info("Waiting checkpoint to complete... checkpoint txid should increase above " + txid);
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while ((thisCheckpointTxId = cluster.getNameNode().getFSImage().getStorage().getMostRecentCheckpointTxId()) < txid);
        FSImageTestUtil.assertNNHasCheckpoints(cluster, Collections.singletonList((int)thisCheckpointTxId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void startBackupNodeWithIncorrectAuthentication() throws IOException {
        NameNode nn;
        HdfsConfiguration c = new HdfsConfiguration();
        HdfsServerConstants.StartupOption startupOpt = HdfsServerConstants.StartupOption.CHECKPOINT;
        String dirs = TestBackupNode.getBackupNodeDir(startupOpt, 1);
        c.set("fs.defaultFS", "hdfs://127.0.0.1:" + ServerSocketUtil.getPort((int)0, (int)100));
        c.set("dfs.namenode.http-address", "127.0.0.1:0");
        c.set("dfs.blockreport.initialDelay", "0");
        c.setInt("dfs.datanode.scan.period.hours", -1);
        c.setInt("dfs.namenode.checkpoint.txns", 1);
        c.set("dfs.namenode.name.dir", dirs);
        c.set("dfs.namenode.edits.dir", "${dfs.namenode.name.dir}");
        c.set("dfs.namenode.backup.address", "127.0.0.1:0");
        c.set("dfs.namenode.backup.http-address", "127.0.0.1:0");
        try {
            HdfsConfiguration nnconf = new HdfsConfiguration((Configuration)c);
            DFSTestUtil.formatNameNode((Configuration)nnconf);
            nn = NameNode.createNameNode((String[])new String[0], (Configuration)nnconf);
        }
        catch (IOException e) {
            LOG.info("IOException is thrown creating name node");
            throw e;
        }
        c.set("hadoop.security.authentication", "kerberos");
        c.set("dfs.namenode.keytab.file", "");
        BackupNode bn = null;
        try {
            bn = (BackupNode)NameNode.createNameNode((String[])new String[]{startupOpt.getName()}, (Configuration)c);
            Assert.assertTrue((String)"Namesystem in BackupNode should be null", (bn.getNamesystem() == null ? 1 : 0) != 0);
            Assert.fail((String)"Incorrect authentication setting should throw IOException");
        }
        catch (IOException e) {
            LOG.info("IOException thrown.", (Throwable)e);
            Assert.assertTrue((boolean)e.getMessage().contains("Running in secure mode"));
        }
        finally {
            if (nn != null) {
                nn.stop();
            }
            if (bn != null) {
                bn.stop();
            }
            SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.SIMPLE, (Configuration)c);
            UserGroupInformation.setConfiguration((Configuration)c);
        }
    }

    @Test
    public void testCheckpointNode() throws Exception {
        this.testCheckpoint(HdfsServerConstants.StartupOption.CHECKPOINT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackupNodeTailsEdits() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        BackupNode backup = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            fileSys = cluster.getFileSystem();
            backup = this.startBackupNode((Configuration)conf, HdfsServerConstants.StartupOption.BACKUP, 1);
            BackupImage bnImage = (BackupImage)backup.getFSImage();
            this.testBNInSync(cluster, backup, 1);
            NameNode nn = cluster.getNameNode();
            NamenodeProtocols nnRpc = nn.getRpcServer();
            nnRpc.rollEditLog();
            Assert.assertEquals((long)bnImage.getEditLog().getCurSegmentTxId(), (long)nn.getFSImage().getEditLog().getCurSegmentTxId());
            this.testBNInSync(cluster, backup, 2);
            long nnImageBefore = nn.getFSImage().getStorage().getMostRecentCheckpointTxId();
            backup.doCheckpoint();
            long nnImageAfter = nn.getFSImage().getStorage().getMostRecentCheckpointTxId();
            Assert.assertTrue((String)("nn should have received new checkpoint. before: " + nnImageBefore + " after: " + nnImageAfter), (nnImageAfter > nnImageBefore ? 1 : 0) != 0);
            this.testBNInSync(cluster, backup, 3);
            Storage.StorageDirectory sd = bnImage.getStorage().getStorageDir(0);
            backup.stop();
            backup = null;
            FileJournalManager.EditLogFile editsLog = FSImageTestUtil.findLatestEditsLog(sd);
            Assert.assertEquals((long)editsLog.getFirstTxId(), (long)nn.getFSImage().getEditLog().getCurSegmentTxId());
            Assert.assertTrue((String)("Should not have finalized " + editsLog), (boolean)editsLog.isInProgress());
            Assert.assertTrue((boolean)fileSys.mkdirs(new Path("/edit-while-bn-down")));
            backup = this.startBackupNode((Configuration)conf, HdfsServerConstants.StartupOption.BACKUP, 1);
            this.testBNInSync(cluster, backup, 4);
            Assert.assertNotNull((Object)backup.getNamesystem().getFileInfo("/edit-while-bn-down", false, false, false));
            backup.stop(false);
            Assert.assertTrue((boolean)fileSys.mkdirs(new Path("/edit-while-bn-down-2")));
        }
        finally {
            LOG.info("Shutting down...");
            if (backup != null) {
                backup.stop();
            }
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        this.assertStorageDirsMatch(cluster.getNameNode(), backup);
    }

    private void testBNInSync(MiniDFSCluster cluster, final BackupNode backup, int testIdx) throws Exception {
        final NameNode nn = cluster.getNameNode();
        DistributedFileSystem fs = cluster.getFileSystem();
        for (int i = 0; i < 10; ++i) {
            final String src = "/test_" + testIdx + "_" + i;
            LOG.info("Creating " + src + " on NN");
            Path p = new Path(src);
            Assert.assertTrue((boolean)fs.mkdirs(p));
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    LOG.info("Checking for " + src + " on BN");
                    try {
                        boolean hasFile = backup.getNamesystem().getFileInfo(src, false, false, false) != null;
                        boolean txnIdMatch = backup.getRpcServer().getTransactionID() == nn.getRpcServer().getTransactionID();
                        return hasFile && txnIdMatch;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, (long)30L, (long)10000L);
        }
        this.assertStorageDirsMatch(nn, backup);
    }

    private void assertStorageDirsMatch(NameNode nn, BackupNode backup) throws Exception {
        ArrayList dirs = Lists.newArrayList(FSImageTestUtil.getCurrentDirs(nn.getFSImage().getStorage(), null));
        dirs.addAll(FSImageTestUtil.getCurrentDirs(backup.getFSImage().getStorage(), null));
        FSImageTestUtil.assertParallelFilesAreIdentical(dirs, (Set<String>)ImmutableSet.of((Object)"VERSION"));
    }

    @Test
    public void testBackupNode() throws Exception {
        this.testCheckpoint(HdfsServerConstants.StartupOption.BACKUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testCheckpoint(HdfsServerConstants.StartupOption op) throws Exception {
        Path file1 = new Path("/checkpoint.dat");
        Path file2 = new Path("/checkpoint2.dat");
        Path file3 = new Path("/backup.dat");
        HdfsConfiguration conf = new HdfsConfiguration();
        HAUtil.setAllowStandbyReads((Configuration)conf, (boolean)true);
        short replication = (short)conf.getInt("dfs.replication", 3);
        int numDatanodes = Math.max(3, replication);
        conf.set("dfs.namenode.backup.http-address", "localhost:0");
        conf.set("dfs.blockreport.initialDelay", "0");
        conf.setInt("dfs.datanode.scan.period.hours", -1);
        conf.setInt("dfs.namenode.checkpoint.txns", 1);
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        BackupNode backup = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            fileSys = cluster.getFileSystem();
            Assert.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            Assert.assertTrue((!fileSys.exists(file2) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)fileSys.mkdirs(file1));
            long txid = cluster.getNameNodeRpc().getTransactionID();
            backup = this.startBackupNode((Configuration)conf, op, 1);
            this.waitCheckpointDone(cluster, txid);
        }
        catch (IOException e) {
            LOG.error("Error in TestBackupNode:", (Throwable)e);
            Assert.assertTrue((String)e.getLocalizedMessage(), (boolean)false);
        }
        finally {
            if (backup != null) {
                backup.stop();
            }
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        File nnCurDir = new File(MiniDFSCluster.getNameNodeDirectory(BASE_DIR, 0, 0)[0], "current/");
        File bnCurDir = new File(TestBackupNode.getBackupNodeDir(op, 1), "/current/");
        FSImageTestUtil.assertParallelFilesAreIdentical((List<File>)ImmutableList.of((Object)bnCurDir, (Object)nnCurDir), (Set<String>)ImmutableSet.of((Object)"VERSION"));
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDatanodes).format(false).build();
            fileSys = cluster.getFileSystem();
            Assert.assertTrue((boolean)fileSys.exists(file1));
            fileSys.delete(file1, true);
            fileSys.mkdirs(file2);
            long txid = cluster.getNameNodeRpc().getTransactionID();
            backup = this.startBackupNode((Configuration)conf, op, 1);
            this.waitCheckpointDone(cluster, txid);
            for (int i = 0; i < 10; ++i) {
                fileSys.mkdirs(new Path("file_" + i));
            }
            txid = cluster.getNameNodeRpc().getTransactionID();
            backup.doCheckpoint();
            this.waitCheckpointDone(cluster, txid);
            txid = cluster.getNameNodeRpc().getTransactionID();
            backup.doCheckpoint();
            this.waitCheckpointDone(cluster, txid);
            InetSocketAddress add = backup.getNameNodeAddress();
            FileSystem bnFS = FileSystem.get((URI)new Path("hdfs://" + NetUtils.getHostPortString((InetSocketAddress)add)).toUri(), (Configuration)conf);
            boolean canWrite = true;
            try {
                DFSTestUtil.createFile(bnFS, file3, 8192, 8192L, 4096L, replication, 3735928559L);
            }
            catch (IOException eio) {
                LOG.info("Write to " + backup.getRole() + " failed as expected: ", (Throwable)eio);
                canWrite = false;
            }
            Assert.assertFalse((String)"Write to BackupNode must be prohibited.", (boolean)canWrite);
            boolean canRead = true;
            try {
                bnFS.exists(file2);
            }
            catch (IOException eio) {
                LOG.info("Read from " + backup.getRole() + " failed: ", (Throwable)eio);
                canRead = false;
            }
            Assert.assertEquals((String)"Reads to BackupNode are allowed, but not CheckpointNode.", (Object)canRead, (Object)backup.isRole(HdfsServerConstants.NamenodeRole.BACKUP));
            DFSTestUtil.createFile((FileSystem)fileSys, file3, 8192, 8192L, 4096L, replication, 3735928559L);
            TestCheckpoint.checkFile((FileSystem)fileSys, file3, replication);
            Assert.assertTrue((String)"file3 does not exist on BackupNode", (op != HdfsServerConstants.StartupOption.BACKUP || backup.getNamesystem().getFileInfo(file3.toUri().getPath(), false, false, false) != null ? 1 : 0) != 0);
        }
        catch (IOException e) {
            LOG.error("Error in TestBackupNode:", (Throwable)e);
            throw new AssertionError((Object)e);
        }
        finally {
            if (backup != null) {
                backup.stop();
            }
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        FSImageTestUtil.assertParallelFilesAreIdentical((List<File>)ImmutableList.of((Object)bnCurDir, (Object)nnCurDir), (Set<String>)ImmutableSet.of((Object)"VERSION"));
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(false).build();
            fileSys = cluster.getFileSystem();
            Assert.assertTrue((!fileSys.exists(file1) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)fileSys.exists(file2));
        }
        catch (IOException e) {
            LOG.error("Error in TestBackupNode: ", (Throwable)e);
            Assert.assertTrue((String)e.getLocalizedMessage(), (boolean)false);
        }
        finally {
            fileSys.close();
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCanReadData() throws IOException {
        Path file1 = new Path("/fileToRead.dat");
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        BackupNode backup = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).format(true).build();
            fileSys = cluster.getFileSystem();
            long txid = cluster.getNameNodeRpc().getTransactionID();
            backup = this.startBackupNode((Configuration)conf, HdfsServerConstants.StartupOption.BACKUP, 1);
            this.waitCheckpointDone(cluster, txid);
            String rpcAddrKeyPreffix = "dfs.namenode.rpc-address.bnCluster";
            String nnAddr = cluster.getNameNode().getNameNodeAddressHostPortString();
            conf.get("dfs.namenode.rpc-address");
            String bnAddr = backup.getNameNodeAddressHostPortString();
            conf.set("dfs.nameservices", "bnCluster");
            conf.set("dfs.nameservice.id", "bnCluster");
            conf.set("dfs.ha.namenodes.bnCluster", "nnActive, nnBackup");
            conf.set(rpcAddrKeyPreffix + ".nnActive", nnAddr);
            conf.set(rpcAddrKeyPreffix + ".nnBackup", bnAddr);
            cluster.startDataNodes((Configuration)conf, 3, true, HdfsServerConstants.StartupOption.REGULAR, null);
            DFSTestUtil.createFile((FileSystem)fileSys, file1, 8192, 8192L, 4096L, (short)3, 3735928559L);
            FileSystem bnFS = FileSystem.get((URI)new Path("hdfs://" + bnAddr).toUri(), (Configuration)conf);
            String nnData = DFSTestUtil.readFile((FileSystem)fileSys, file1);
            String bnData = DFSTestUtil.readFile(bnFS, file1);
            Assert.assertEquals((String)"Data read from BackupNode and NameNode is not the same.", (Object)nnData, (Object)bnData);
        }
        catch (IOException e) {
            LOG.error("Error in TestBackupNode: ", (Throwable)e);
            Assert.assertTrue((String)e.getLocalizedMessage(), (boolean)false);
        }
        finally {
            if (fileSys != null) {
                fileSys.close();
            }
            if (backup != null) {
                backup.stop();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)Checkpointer.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)BackupImage.LOG, (Level)Level.TRACE);
        BASE_DIR = MiniDFSCluster.getBaseDirectory();
    }
}

