/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.ha.BootstrapStandby;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.test.Whitebox;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBootstrapStandbyWithQJM {
    private MiniDFSCluster cluster;
    private MiniJournalCluster jCluster;
    private int nnCount = 3;

    protected Configuration createConfig() {
        Configuration conf = new Configuration();
        conf.setInt("ipc.client.connection.maxidletime", 0);
        return conf;
    }

    @Before
    public void setup() throws Exception {
        Configuration conf = this.createConfig();
        MiniQJMHACluster miniQjmHaCluster = new MiniQJMHACluster.Builder(conf).setNumNameNodes(this.nnCount).build();
        this.cluster = miniQjmHaCluster.getDfsCluster();
        this.jCluster = miniQjmHaCluster.getJournalCluster();
        this.cluster.transitionToActive(0);
        DistributedFileSystem dfs = HATestUtil.configureFailoverFs(this.cluster, conf);
        dfs.mkdirs(new Path("/test2"));
        dfs.close();
    }

    @After
    public void cleanup() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        if (this.jCluster != null) {
            this.jCluster.shutdown();
            this.jCluster = null;
        }
    }

    @Test
    public void testBootstrapStandbyWithStandbyNN() throws Exception {
        this.cluster.transitionToStandby(0);
        this.bootstrapStandbys();
    }

    @Test
    public void testBootstrapStandbyWithActiveNN() throws Exception {
        this.cluster.transitionToActive(0);
        this.bootstrapStandbys();
    }

    private void bootstrapStandbys() throws Exception {
        for (int i = 1; i < this.nnCount; ++i) {
            Configuration otherNNConf = this.cluster.getConfiguration(i);
            this.cluster.shutdownNameNode(i);
            int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)otherNNConf);
            Assert.assertEquals((long)0L, (long)rc);
            FSImageTestUtil.assertNNHasCheckpoints(this.cluster, i, (List<Integer>)ImmutableList.of((Object)0));
        }
        FSImageTestUtil.assertNNFilesMatch(this.cluster);
    }

    @Test
    public void testUpgrade() throws Exception {
        this.testUpgrade(UpgradeState.NORMAL);
    }

    @Test
    public void testUpgradeWithRecover() throws Exception {
        this.testUpgrade(UpgradeState.RECOVER);
    }

    @Test
    public void testUpgradeWithFormat() throws Exception {
        this.testUpgrade(UpgradeState.FORMAT);
    }

    private void testUpgrade(UpgradeState state) throws Exception {
        this.cluster.transitionToActive(0);
        Configuration confNN1 = this.cluster.getConfiguration(1);
        File current = this.cluster.getNameNode(1).getFSImage().getStorage().getStorageDir(0).getCurrentDir();
        File tmp = this.cluster.getNameNode(1).getFSImage().getStorage().getStorageDir(0).getPreviousTmp();
        this.cluster.shutdownNameNode(1);
        FSImage fsImage0 = this.cluster.getNameNode(0).getNamesystem().getFSImage();
        Whitebox.setInternalState((Object)fsImage0, (String)"isUpgradeFinalized", (Object)false);
        switch (state) {
            case RECOVER: {
                NNStorage.rename((File)current, (File)tmp);
                break;
            }
            case FORMAT: {
                File wrongPath = new File(current.getParentFile(), "wrong");
                NNStorage.rename((File)current, (File)wrongPath);
                break;
            }
        }
        int rc = BootstrapStandby.run((String[])new String[]{"-force"}, (Configuration)confNN1);
        Assert.assertEquals((long)0L, (long)rc);
        FSImageTestUtil.assertNNHasCheckpoints(this.cluster, 1, (List<Integer>)ImmutableList.of((Object)0));
        FSImageTestUtil.assertNNFilesMatch(this.cluster);
        this.cluster.restartNameNode(1);
        Assert.assertFalse((boolean)this.cluster.getNameNode(1).getNamesystem().isUpgradeFinalized());
    }

    static enum UpgradeState {
        NORMAL,
        RECOVER,
        FORMAT;

    }
}

