/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import com.google.common.base.Preconditions;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkStatus;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerException;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;
import org.apache.hadoop.hdfs.tools.DiskBalancerCLI;
import org.apache.hadoop.net.NetUtils;

public class QueryCommand
extends Command {
    public QueryCommand(Configuration conf) {
        super(conf);
        this.addValidCommandParameters("query", "Queries the status of disk plan running on a given datanode.");
        this.addValidCommandParameters("v", "Prints verbose results.");
    }

    @Override
    public void execute(CommandLine cmd) throws Exception {
        LOG.info("Executing \"query plan\" command.");
        Preconditions.checkState((boolean)cmd.hasOption("query"));
        this.verifyCommandOptions("query", cmd);
        String nodeName = cmd.getOptionValue("query");
        Preconditions.checkNotNull((Object)nodeName);
        String nodeAddress = nodeName = nodeName.trim();
        if (!nodeName.matches("[^\\:]+:[0-9]{2,5}")) {
            int defaultIPC = NetUtils.createSocketAddr((String)this.getConf().getTrimmed("dfs.datanode.ipc.address", "0.0.0.0:9867")).getPort();
            nodeAddress = nodeName + ":" + defaultIPC;
            LOG.debug("Using default data node port :  {}", (Object)nodeAddress);
        }
        ClientDatanodeProtocol dataNode = this.getDataNodeProxy(nodeAddress);
        try {
            DiskBalancerWorkStatus workStatus = dataNode.queryDiskBalancerPlan();
            System.out.printf("Plan File: %s%nPlan ID: %s%nResult: %s%n", workStatus.getPlanFile(), workStatus.getPlanID(), workStatus.getResult().toString());
            if (cmd.hasOption("v")) {
                System.out.printf("%s", workStatus.currentStateString());
            }
        }
        catch (DiskBalancerException ex) {
            LOG.error("Query plan failed. ex: {}", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void printHelp() {
        String header = "Query Plan queries a given data node about the current state of disk balancer execution.\n\n";
        String footer = "\nQuery command retrievs the plan ID and the current running state. ";
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("hdfs diskbalancer -query <hostname>  [options]", header, DiskBalancerCLI.getQueryOptions(), footer);
    }
}

