/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostSet;
import org.apache.hadoop.util.HostsFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostFileManager
extends HostConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(HostFileManager.class);
    private Configuration conf;
    private HostSet includes = new HostSet();
    private HostSet excludes = new HostSet();

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void refresh() throws IOException {
        this.refresh(this.conf.get("dfs.hosts", ""), this.conf.get("dfs.hosts.exclude", ""));
    }

    private static HostSet readFile(String type, String filename) throws IOException {
        HostSet res = new HostSet();
        if (!filename.isEmpty()) {
            HashSet entrySet = new HashSet();
            HostsFileReader.readFileToSet((String)type, (String)filename, entrySet);
            for (String str : entrySet) {
                InetSocketAddress addr = HostFileManager.parseEntry(type, filename, str);
                if (addr == null) continue;
                res.add(addr);
            }
        }
        return res;
    }

    @VisibleForTesting
    static InetSocketAddress parseEntry(String type, String fn, String line) {
        try {
            URI uri = new URI("dummy", line, null, null, null);
            int port = uri.getPort() == -1 ? 0 : uri.getPort();
            InetSocketAddress addr = new InetSocketAddress(uri.getHost(), port);
            if (addr.isUnresolved()) {
                LOG.warn(String.format("Failed to resolve address `%s` in `%s`. Ignoring in the %s list.", line, fn, type));
                return null;
            }
            return addr;
        }
        catch (URISyntaxException e) {
            LOG.warn(String.format("Failed to parse `%s` in `%s`. Ignoring in the %s list.", line, fn, type));
            return null;
        }
    }

    public synchronized HostSet getIncludes() {
        return this.includes;
    }

    public synchronized HostSet getExcludes() {
        return this.excludes;
    }

    @Override
    public synchronized boolean isIncluded(DatanodeID dn) {
        return this.includes.isEmpty() || this.includes.match(dn.getResolvedAddress());
    }

    @Override
    public synchronized boolean isExcluded(DatanodeID dn) {
        return this.isExcluded(dn.getResolvedAddress());
    }

    private boolean isExcluded(InetSocketAddress address) {
        return this.excludes.match(address);
    }

    @Override
    public synchronized String getUpgradeDomain(DatanodeID dn) {
        return null;
    }

    @Override
    public long getMaintenanceExpirationTimeInMS(DatanodeID dn) {
        return 0L;
    }

    private void refresh(String includeFile, String excludeFile) throws IOException {
        HostSet newIncludes = HostFileManager.readFile("included", includeFile);
        HostSet newExcludes = HostFileManager.readFile("excluded", excludeFile);
        this.refresh(newIncludes, newExcludes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void refresh(HostSet newIncludes, HostSet newExcludes) {
        HostFileManager hostFileManager = this;
        synchronized (hostFileManager) {
            this.includes = newIncludes;
            this.excludes = newExcludes;
        }
    }
}

