/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.web.SWebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHttpFSPorts {
    private static final Configuration conf = new Configuration();

    @Before
    public void setupConfig() {
        conf.setInt("dfs.http.port", 123);
        conf.setInt("dfs.https.port", 456);
    }

    @Test
    public void testWebHdfsCustomDefaultPorts() throws IOException {
        URI uri = URI.create("webhdfs://localhost");
        WebHdfsFileSystem fs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)123L, (long)fs.getDefaultPort());
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Assert.assertEquals((Object)"127.0.0.1:123", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testWebHdfsCustomUriPortWithCustomDefaultPorts() throws IOException {
        URI uri = URI.create("webhdfs://localhost:789");
        WebHdfsFileSystem fs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)123L, (long)fs.getDefaultPort());
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Assert.assertEquals((Object)"127.0.0.1:789", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testSWebHdfsCustomDefaultPorts() throws IOException {
        URI uri = URI.create("swebhdfs://localhost");
        SWebHdfsFileSystem fs = (SWebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)456L, (long)fs.getDefaultPort());
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Assert.assertEquals((Object)"127.0.0.1:456", (Object)fs.getCanonicalServiceName());
    }

    @Test
    public void testSwebHdfsCustomUriPortWithCustomDefaultPorts() throws IOException {
        URI uri = URI.create("swebhdfs://localhost:789");
        SWebHdfsFileSystem fs = (SWebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        Assert.assertEquals((long)456L, (long)fs.getDefaultPort());
        Assert.assertEquals((Object)uri, (Object)fs.getUri());
        Assert.assertEquals((Object)"127.0.0.1:789", (Object)fs.getCanonicalServiceName());
    }
}

