/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.File;
import java.io.FileWriter;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.apache.hadoop.hdfs.util.CombinedHostsFileReader;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCombinedHostsFileReader {
    static final String HOSTSTESTDIR = GenericTestUtils.getTestDir().getAbsolutePath();
    private final File newFile = new File(HOSTSTESTDIR, "dfs.hosts.new.json");
    static final String TESTCACHEDATADIR = System.getProperty("test.cache.data", "build/test/cache");
    private final File jsonFile = new File(TESTCACHEDATADIR, "dfs.hosts.json");
    private final File legacyFile = new File(TESTCACHEDATADIR, "legacy.dfs.hosts.json");

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        this.newFile.delete();
    }

    @Test
    public void testLoadLegacyJsonFile() throws Exception {
        DatanodeAdminProperties[] all = CombinedHostsFileReader.readFile((String)this.legacyFile.getAbsolutePath());
        Assert.assertEquals((long)5L, (long)all.length);
    }

    @Test
    public void testLoadExistingJsonFile() throws Exception {
        DatanodeAdminProperties[] all = CombinedHostsFileReader.readFile((String)this.jsonFile.getAbsolutePath());
        Assert.assertEquals((long)5L, (long)all.length);
    }

    @Test
    public void testEmptyCombinedHostsFileReader() throws Exception {
        FileWriter hosts = new FileWriter(this.newFile);
        hosts.write("");
        hosts.close();
        DatanodeAdminProperties[] all = CombinedHostsFileReader.readFile((String)this.newFile.getAbsolutePath());
        Assert.assertEquals((long)0L, (long)all.length);
    }
}

