/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NNThroughputBenchmark;
import org.apache.hadoop.util.ExitUtil;
import org.junit.After;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNNThroughputBenchmark {
    @BeforeClass
    public static void setUp() {
        ExitUtil.disableSystemExit();
    }

    @After
    public void cleanUp() {
        FileUtil.fullyDeleteContents((File)new File(MiniDFSCluster.getBaseDirectory()));
    }

    @Test
    public void testNNThroughput() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        DFSTestUtil.formatNameNode((Configuration)conf);
        NNThroughputBenchmark.runBenchmark((Configuration)conf, new String[]{"-op", "all"});
    }

    @Test(timeout=120000L)
    public void testNNThroughputWithFsOption() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        DFSTestUtil.formatNameNode((Configuration)conf);
        NNThroughputBenchmark.runBenchmark((Configuration)conf, new String[]{"-fs", "file:///", "-op", "all"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testNNThroughputAgainstRemoteNN() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            HdfsConfiguration benchConf = new HdfsConfiguration();
            FileSystem.setDefaultUri((Configuration)benchConf, (URI)cluster.getURI());
            NNThroughputBenchmark.runBenchmark((Configuration)benchConf, new String[]{"-op", "all"});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testNNThroughputRemoteAgainstNNWithFsOption() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.fs-limits.min-block-size", 16);
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
            cluster.waitActive();
            NNThroughputBenchmark.runBenchmark((Configuration)new HdfsConfiguration(), new String[]{"-fs", cluster.getURI().toString(), "-op", "all"});
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

