/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.datatransfer.ReplaceDatanodeOnFailure;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestReplaceDatanodeFailureReplication {
    static final Log LOG = LogFactory.getLog(TestReplaceDatanodeFailureReplication.class);
    static final String DIR = "/" + TestReplaceDatanodeFailureReplication.class.getSimpleName() + "/";
    static final short REPLICATION = 3;
    private static final String RACK0 = "/rack0";

    @Test
    public void testLastDatanodeFailureInPipeline() throws Exception {
        this.testWriteFileAndVerifyAfterDNStop(2, 1, 10, false);
    }

    @Test
    public void testFirstDatanodeFailureInPipeline() throws Exception {
        this.testWriteFileAndVerifyAfterDNStop(2, 0, 10, false);
    }

    @Test
    public void testWithOnlyFirstDatanodeIsAlive() throws Exception {
        this.testWriteFileAndVerifyAfterDNStop(1, 1, 1, true);
    }

    @Test
    public void testWithOnlyLastDatanodeIsAlive() throws Exception {
        this.testWriteFileAndVerifyAfterDNStop(1, 0, 1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLessNumberOfLiveDatanodesThanWriteReplaceDatanodeOnFailureRF() throws Exception {
        MiniDFSCluster cluster = this.setupCluster(2);
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path(DIR);
            SlowWriter[] slowwriters = new SlowWriter[1];
            for (int i = 1; i <= slowwriters.length; ++i) {
                slowwriters[i - 1] = new SlowWriter(fs, new Path(dir, "file" + i), (long)i * 200L);
            }
            for (SlowWriter s : slowwriters) {
                s.start();
            }
            TestReplaceDatanodeFailureReplication.sleepSeconds(1);
            cluster.stopDataNode(0);
            cluster.stopDataNode(0);
            TestReplaceDatanodeFailureReplication.sleepSeconds(20);
            for (SlowWriter s : slowwriters) {
                try {
                    s.out.getCurrentBlockReplication();
                    Assert.fail((String)"Must throw exception as failed to add a new datanode for write pipeline, minimum failure replication");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                s.interruptRunning();
            }
            for (SlowWriter s : slowwriters) {
                s.joinAndClose();
            }
            this.verifyFileContent(fs, slowwriters);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private MiniDFSCluster setupCluster(int failRF) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.client.block.write.replace-datanode-on-failure.min-replication", failRF);
        ReplaceDatanodeOnFailure.write((ReplaceDatanodeOnFailure.Policy)ReplaceDatanodeOnFailure.Policy.ALWAYS, (boolean)false, (Configuration)conf);
        Object[] racks = new String[3];
        Arrays.fill(racks, RACK0);
        return new MiniDFSCluster.Builder((Configuration)conf).racks((String[])racks).numDataNodes(3).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWriteFileAndVerifyAfterDNStop(int failRF, int dnindex, int slowWrites, boolean failPipeLine) throws IOException, InterruptedException, TimeoutException {
        MiniDFSCluster cluster = this.setupCluster(failRF);
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path(DIR);
            SlowWriter[] slowwriters = new SlowWriter[slowWrites];
            for (int i = 1; i <= slowwriters.length; ++i) {
                slowwriters[i - 1] = new SlowWriter(fs, new Path(dir, "file" + i), (long)i * 200L);
            }
            for (SlowWriter s : slowwriters) {
                s.start();
            }
            TestReplaceDatanodeFailureReplication.sleepSeconds(3);
            cluster.stopDataNode(dnindex);
            if (failPipeLine) {
                cluster.stopDataNode(dnindex);
            }
            TestReplaceDatanodeFailureReplication.sleepSeconds(5);
            cluster.waitFirstBRCompleted(0, 10000);
            for (SlowWriter s : slowwriters) {
                Assert.assertEquals((long)failRF, (long)s.out.getCurrentBlockReplication());
                s.interruptRunning();
            }
            for (SlowWriter s : slowwriters) {
                s.joinAndClose();
            }
            this.verifyFileContent(fs, slowwriters);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifyFileContent(DistributedFileSystem fs, SlowWriter[] slowwriters) throws IOException {
        LOG.info((Object)"Verify the file");
        int i = 0;
        if (i >= slowwriters.length) return;
        LOG.info((Object)(slowwriters[i].filepath + ": length=" + fs.getFileStatus(slowwriters[i].filepath).getLen()));
        FSDataInputStream in = null;
        try {
            int x;
            in = fs.open(slowwriters[i].filepath);
            int j = 0;
            while ((x = in.read()) != -1) {
                Assert.assertEquals((long)j, (long)x);
                ++j;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(in);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)in);
    }

    static void sleepSeconds(int waittime) throws InterruptedException {
        LOG.info((Object)("Wait " + waittime + " seconds"));
        Thread.sleep((long)waittime * 1000L);
    }

    static class SlowWriter
    extends Thread {
        private final Path filepath;
        private final HdfsDataOutputStream out;
        private final long sleepms;
        private volatile boolean running = true;

        SlowWriter(DistributedFileSystem fs, Path filepath, long sleepms) throws IOException {
            super(SlowWriter.class.getSimpleName() + ":" + filepath);
            this.filepath = filepath;
            this.out = (HdfsDataOutputStream)fs.create(filepath, (short)3);
            this.sleepms = sleepms;
        }

        @Override
        public void run() {
            int i = 0;
            try {
                SlowWriter.sleep(this.sleepms);
                while (this.running) {
                    LOG.info((Object)(this.getName() + " writes " + i));
                    this.out.write(i);
                    this.out.hflush();
                    SlowWriter.sleep(this.sleepms);
                    ++i;
                }
            }
            catch (InterruptedException e) {
                LOG.info((Object)(this.getName() + " interrupted:" + e));
            }
            catch (IOException e) {
                throw new RuntimeException(this.getName(), e);
            }
            finally {
                LOG.info((Object)(this.getName() + " terminated: i=" + i));
            }
        }

        void interruptRunning() {
            this.running = false;
            this.interrupt();
        }

        void joinAndClose() throws InterruptedException {
            LOG.info((Object)(this.getName() + " join and close"));
            this.join();
            IOUtils.closeStream((Closeable)this.out);
        }
    }
}

