/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import com.google.common.base.Preconditions;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.DataNodeUGIProvider;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.ExceptionHandler;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.HdfsWriter;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.ParameterParser;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.LimitInputStream;

public class WebHdfsHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    static final Log LOG = LogFactory.getLog(WebHdfsHandler.class);
    static final Log REQLOG = LogFactory.getLog((String)"datanode.webhdfs");
    public static final String WEBHDFS_PREFIX = "/webhdfs/v1";
    public static final int WEBHDFS_PREFIX_LENGTH = "/webhdfs/v1".length();
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String APPLICATION_JSON_UTF8 = "application/json; charset=utf-8";
    public static final EnumSet<CreateFlag> EMPTY_CREATE_FLAG = EnumSet.noneOf(CreateFlag.class);
    private final Configuration conf;
    private final Configuration confForCreate;
    private String path;
    private ParameterParser params;
    private UserGroupInformation ugi;
    private DefaultHttpResponse resp = null;

    public WebHdfsHandler(Configuration conf, Configuration confForCreate) throws IOException {
        this.conf = conf;
        this.confForCreate = confForCreate;
        UserParam.setUserPattern((String)conf.get("dfs.webhdfs.user.provider.user.pattern", "^[A-Za-z_][A-Za-z0-9._-]*[$]?$"));
    }

    public void channelRead0(final ChannelHandlerContext ctx, final HttpRequest req) throws Exception {
        Preconditions.checkArgument((boolean)req.getUri().startsWith(WEBHDFS_PREFIX));
        QueryStringDecoder queryString = new QueryStringDecoder(req.getUri());
        this.params = new ParameterParser(queryString, this.conf);
        DataNodeUGIProvider ugiProvider = new DataNodeUGIProvider(this.params);
        this.ugi = ugiProvider.ugi();
        this.path = this.params.path();
        this.injectToken();
        this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    WebHdfsHandler.this.handle(ctx, req);
                }
                finally {
                    String host = null;
                    try {
                        host = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error retrieving hostname: ", (Throwable)e);
                        host = "unknown";
                    }
                    REQLOG.info((Object)(host + " " + req.getMethod() + " " + req.getUri() + " " + WebHdfsHandler.this.getResponseCode()));
                }
                return null;
            }
        });
    }

    int getResponseCode() {
        return this.resp == null ? HttpResponseStatus.INTERNAL_SERVER_ERROR.code() : this.resp.getStatus().code();
    }

    public void handle(ChannelHandlerContext ctx, HttpRequest req) throws IOException, URISyntaxException {
        String op = this.params.op();
        HttpMethod method = req.getMethod();
        if (PutOpParam.Op.CREATE.name().equalsIgnoreCase(op) && method == HttpMethod.PUT) {
            this.onCreate(ctx);
        } else if (PostOpParam.Op.APPEND.name().equalsIgnoreCase(op) && method == HttpMethod.POST) {
            this.onAppend(ctx);
        } else if (GetOpParam.Op.OPEN.name().equalsIgnoreCase(op) && method == HttpMethod.GET) {
            this.onOpen(ctx);
        } else if (GetOpParam.Op.GETFILECHECKSUM.name().equalsIgnoreCase(op) && method == HttpMethod.GET) {
            this.onGetFileChecksum(ctx);
        } else {
            throw new IllegalArgumentException("Invalid operation " + op);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.debug((Object)"Error ", cause);
        this.resp = ExceptionHandler.exceptionCaught(cause);
        this.resp.headers().set("Connection", (Object)"close");
        ctx.writeAndFlush((Object)this.resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void onCreate(ChannelHandlerContext ctx) throws IOException, URISyntaxException {
        WebHdfsHandler.writeContinueHeader(ctx);
        String nnId = this.params.namenodeId();
        int bufferSize = this.params.bufferSize();
        short replication = this.params.replication();
        long blockSize = this.params.blockSize();
        FsPermission permission = this.params.permission();
        boolean createParent = this.params.createParent();
        EnumSet<CreateFlag> flags = this.params.createFlag();
        if (flags.equals(EMPTY_CREATE_FLAG)) {
            flags = this.params.overwrite() ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE);
        } else if (this.params.overwrite()) {
            flags.add(CreateFlag.OVERWRITE);
        }
        DFSClient dfsClient = WebHdfsHandler.newDfsClient(nnId, this.confForCreate);
        HdfsDataOutputStream out = dfsClient.createWrappedOutputStream(dfsClient.create(this.path, permission, flags, createParent, replication, blockSize, null, bufferSize, null), null);
        this.resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CREATED);
        URI uri = new URI("hdfs", nnId, this.path, null, null);
        this.resp.headers().set("Location", (Object)uri.toString());
        this.resp.headers().set("Content-Length", (Object)0);
        ctx.pipeline().replace((ChannelHandler)this, HdfsWriter.class.getSimpleName(), (ChannelHandler)new HdfsWriter(dfsClient, (OutputStream)out, this.resp));
    }

    private void onAppend(ChannelHandlerContext ctx) throws IOException {
        WebHdfsHandler.writeContinueHeader(ctx);
        String nnId = this.params.namenodeId();
        int bufferSize = this.params.bufferSize();
        DFSClient dfsClient = WebHdfsHandler.newDfsClient(nnId, this.conf);
        HdfsDataOutputStream out = dfsClient.append(this.path, bufferSize, EnumSet.of(CreateFlag.APPEND), null, null);
        this.resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.resp.headers().set("Content-Length", (Object)0);
        ctx.pipeline().replace((ChannelHandler)this, HdfsWriter.class.getSimpleName(), (ChannelHandler)new HdfsWriter(dfsClient, (OutputStream)out, this.resp));
    }

    private void onOpen(ChannelHandlerContext ctx) throws IOException {
        HdfsDataInputStream data;
        String nnId = this.params.namenodeId();
        int bufferSize = this.params.bufferSize();
        long offset = this.params.offset();
        long length = this.params.length();
        this.resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpHeaders headers = this.resp.headers();
        headers.set("Access-Control-Allow-Methods", (Object)HttpMethod.GET);
        headers.set("Access-Control-Allow-Origin", (Object)"*");
        headers.set("Content-Type", (Object)APPLICATION_OCTET_STREAM);
        headers.set("Connection", (Object)"close");
        final DFSClient dfsclient = WebHdfsHandler.newDfsClient(nnId, this.conf);
        HdfsDataInputStream in = dfsclient.createWrappedInputStream(dfsclient.open(this.path, bufferSize, true));
        in.seek(offset);
        long contentLength = in.getVisibleLength() - offset;
        if (length >= 0L) {
            contentLength = Math.min(contentLength, length);
        }
        if (contentLength >= 0L) {
            headers.set("Content-Length", (Object)contentLength);
            data = new LimitInputStream((InputStream)in, contentLength);
        } else {
            data = in;
        }
        ctx.write((Object)this.resp);
        ctx.writeAndFlush((Object)new ChunkedStream((InputStream)data){

            public void close() throws Exception {
                super.close();
                dfsclient.close();
            }
        }).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onGetFileChecksum(ChannelHandlerContext ctx) throws IOException {
        MD5MD5CRC32FileChecksum checksum = null;
        String nnId = this.params.namenodeId();
        DFSClient dfsclient = WebHdfsHandler.newDfsClient(nnId, this.conf);
        try {
            checksum = dfsclient.getFileChecksum(this.path, Long.MAX_VALUE);
            dfsclient.close();
            dfsclient = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dfsclient});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{dfsclient});
        byte[] js = JsonUtil.toJsonString(checksum).getBytes(StandardCharsets.UTF_8);
        this.resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])js));
        this.resp.headers().set("Content-Type", (Object)APPLICATION_JSON_UTF8);
        this.resp.headers().set("Content-Length", (Object)js.length);
        this.resp.headers().set("Connection", (Object)"close");
        ctx.writeAndFlush((Object)this.resp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void writeContinueHeader(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse r = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
        ctx.writeAndFlush((Object)r);
    }

    private static DFSClient newDfsClient(String nnId, Configuration conf) throws IOException {
        URI uri = URI.create("hdfs://" + nnId);
        return new DFSClient(uri, conf);
    }

    private void injectToken() throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            Token<DelegationTokenIdentifier> token = this.params.delegationToken();
            token.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
            this.ugi.addToken(token);
        }
    }
}

