/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCheckpointsWithSnapshots {
    private static final Path TEST_PATH = new Path("/foo");
    private static final Configuration conf = new HdfsConfiguration();

    @Before
    public void setUp() {
        FileUtil.fullyDeleteContents((File)new File(MiniDFSCluster.getBaseDirectory()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpoint() throws IOException {
        MiniDFSCluster cluster = null;
        SecondaryNameNode secondary = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            secondary = new SecondaryNameNode(conf);
            SnapshotManager nnSnapshotManager = cluster.getNamesystem().getSnapshotManager();
            SnapshotManager secondarySnapshotManager = secondary.getFSNamesystem().getSnapshotManager();
            DistributedFileSystem fs = cluster.getFileSystem();
            HdfsAdmin admin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)conf), conf);
            Assert.assertEquals((long)0L, (long)nnSnapshotManager.getNumSnapshots());
            Assert.assertEquals((long)0L, (long)nnSnapshotManager.getNumSnapshottableDirs());
            Assert.assertEquals((long)0L, (long)secondarySnapshotManager.getNumSnapshots());
            Assert.assertEquals((long)0L, (long)secondarySnapshotManager.getNumSnapshottableDirs());
            fs.mkdirs(TEST_PATH);
            admin.allowSnapshot(TEST_PATH);
            Assert.assertEquals((long)0L, (long)nnSnapshotManager.getNumSnapshots());
            Assert.assertEquals((long)1L, (long)nnSnapshotManager.getNumSnapshottableDirs());
            Path snapshotPath = fs.createSnapshot(TEST_PATH);
            Assert.assertEquals((long)1L, (long)nnSnapshotManager.getNumSnapshots());
            Assert.assertEquals((long)1L, (long)nnSnapshotManager.getNumSnapshottableDirs());
            secondary.doCheckpoint();
            Assert.assertEquals((long)1L, (long)secondarySnapshotManager.getNumSnapshots());
            Assert.assertEquals((long)1L, (long)secondarySnapshotManager.getNumSnapshottableDirs());
            fs.deleteSnapshot(TEST_PATH, snapshotPath.getName());
            admin.disallowSnapshot(TEST_PATH);
            Assert.assertEquals((long)0L, (long)nnSnapshotManager.getNumSnapshots());
            Assert.assertEquals((long)0L, (long)nnSnapshotManager.getNumSnapshottableDirs());
            NameNodeAdapter.enterSafeMode(cluster.getNameNode(), false);
            NameNodeAdapter.saveNamespace(cluster.getNameNode());
            NameNodeAdapter.leaveSafeMode(cluster.getNameNode());
            secondary.doCheckpoint();
            Assert.assertEquals((long)0L, (long)secondarySnapshotManager.getNumSnapshots());
            Assert.assertEquals((long)0L, (long)secondarySnapshotManager.getNumSnapshottableDirs());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            if (secondary != null) {
                secondary.shutdown();
            }
        }
    }

    static {
        conf.set("dfs.namenode.secondary.http-address", "0.0.0.0:0");
    }
}

