/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.TestReplicationPolicy;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.VersionInfo;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestReplicationPolicyConsiderLoad {
    private static NameNode namenode;
    private static DatanodeManager dnManager;
    private static List<DatanodeRegistration> dnrList;
    private static DatanodeDescriptor[] dataNodes;
    private static DatanodeStorageInfo[] storages;
    private final double EPSILON = 1.0E-4;

    @BeforeClass
    public static void setupCluster() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        String[] racks = new String[]{"/rack1", "/rack1", "/rack1", "/rack2", "/rack2", "/rack2"};
        storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        dataNodes = DFSTestUtil.toDatanodeDescriptor(storages);
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        File baseDir = PathUtils.getTestDir(TestReplicationPolicy.class);
        conf.set("dfs.namenode.name.dir", new File(baseDir, "name").getPath());
        conf.setBoolean("dfs.namenode.avoid.read.stale.datanode", true);
        conf.setBoolean("dfs.namenode.avoid.write.stale.datanode", true);
        conf.setBoolean("dfs.namenode.replication.considerLoad", true);
        DFSTestUtil.formatNameNode((Configuration)conf);
        namenode = new NameNode((Configuration)conf);
        int blockSize = 1024;
        dnrList = new ArrayList<DatanodeRegistration>();
        dnManager = namenode.getNamesystem().getBlockManager().getDatanodeManager();
        for (int i = 0; i < 6; ++i) {
            DatanodeRegistration dnr = new DatanodeRegistration((DatanodeID)dataNodes[i], new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE), new ExportedBlockKeys(), VersionInfo.getVersion());
            dnrList.add(dnr);
            dnManager.registerDatanode(dnr);
            dataNodes[i].getStorageInfos()[0].setUtilizationForTesting((long)(2 * blockSize), 0L, (long)(2 * blockSize), 0L);
            dataNodes[i].updateHeartbeat(BlockManagerTestUtil.getStorageReportsForDatanode(dataNodes[i]), 0L, 0L, 0, 0, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseTargetWithDecomNodes() throws IOException {
        namenode.getNamesystem().writeLock();
        try {
            String blockPoolId = namenode.getNamesystem().getBlockPoolId();
            dnManager.handleHeartbeat(dnrList.get(3), BlockManagerTestUtil.getStorageReportsForDatanode(dataNodes[3]), blockPoolId, dataNodes[3].getCacheCapacity(), dataNodes[3].getCacheRemaining(), 2, 0, 0, null);
            dnManager.handleHeartbeat(dnrList.get(4), BlockManagerTestUtil.getStorageReportsForDatanode(dataNodes[4]), blockPoolId, dataNodes[4].getCacheCapacity(), dataNodes[4].getCacheRemaining(), 4, 0, 0, null);
            dnManager.handleHeartbeat(dnrList.get(5), BlockManagerTestUtil.getStorageReportsForDatanode(dataNodes[5]), blockPoolId, dataNodes[5].getCacheCapacity(), dataNodes[5].getCacheRemaining(), 4, 0, 0, null);
            int load = 10;
            FSNamesystem fsn = namenode.getNamesystem();
            Assert.assertEquals((double)1.6666666666666667, (double)dnManager.getFSClusterStats().getInServiceXceiverAverage(), (double)1.0E-4);
            for (int i = 0; i < 3; ++i) {
                DatanodeDescriptor d = dnManager.getDatanode((DatanodeID)dnrList.get(i));
                dnManager.getDecomManager().startDecommission(d);
                d.setDecommissioned();
            }
            Assert.assertEquals((double)3.3333333333333335, (double)dnManager.getFSClusterStats().getInServiceXceiverAverage(), (double)1.0E-4);
            ArrayList liveNodes = new ArrayList();
            dnManager.fetchDatanodes(liveNodes, null, false);
            DatanodeDescriptor writerDn = null;
            if (liveNodes.contains(dataNodes[0])) {
                writerDn = (DatanodeDescriptor)liveNodes.get(liveNodes.indexOf(dataNodes[0]));
            }
            DatanodeStorageInfo[] targets = namenode.getNamesystem().getBlockManager().getBlockPlacementPolicy().chooseTarget("testFile.txt", 3, (Node)writerDn, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY);
            Assert.assertEquals((long)3L, (long)targets.length);
            HashSet<DatanodeStorageInfo> targetSet = new HashSet<DatanodeStorageInfo>(Arrays.asList(targets));
            for (int i = 3; i < storages.length; ++i) {
                Assert.assertTrue((boolean)targetSet.contains(storages[i]));
            }
        }
        finally {
            dataNodes[0].stopDecommission();
            dataNodes[1].stopDecommission();
            dataNodes[2].stopDecommission();
            namenode.getNamesystem().writeUnlock();
        }
    }

    @AfterClass
    public static void teardownCluster() {
        if (namenode != null) {
            namenode.stop();
        }
    }
}

