/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.contract.AbstractContractAppendTest;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.contract.hdfs.HDFSContract;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class TestHDFSContractAppend
extends AbstractContractAppendTest {
    @BeforeClass
    public static void createCluster() throws IOException {
        HDFSContract.createCluster();
    }

    @AfterClass
    public static void teardownCluster() throws IOException {
        HDFSContract.destroyCluster();
    }

    protected AbstractFSContract createContract(Configuration conf) {
        return new HDFSContract(conf);
    }

    public void testRenameFileBeingAppended() throws Throwable {
        try {
            super.testRenameFileBeingAppended();
            TestHDFSContractAppend.fail((String)"Expected a FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            ContractTestUtils.downgrade((String)"Renaming an open filestill creates the old path", (Throwable)e);
        }
    }
}

