/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.proto.AclProtos;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestPBHelper {
    private static final double DELTA = 1.0E-6;

    @Test
    public void testConvertNamenodeRole() {
        Assert.assertEquals((Object)HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.BACKUP, (Object)PBHelper.convert((HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.BACKUP));
        Assert.assertEquals((Object)HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.CHECKPOINT, (Object)PBHelper.convert((HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.CHECKPOINT));
        Assert.assertEquals((Object)HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.NAMENODE, (Object)PBHelper.convert((HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE));
        Assert.assertEquals((Object)HdfsServerConstants.NamenodeRole.BACKUP, (Object)PBHelper.convert((HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto)HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.BACKUP));
        Assert.assertEquals((Object)HdfsServerConstants.NamenodeRole.CHECKPOINT, (Object)PBHelper.convert((HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto)HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.CHECKPOINT));
        Assert.assertEquals((Object)HdfsServerConstants.NamenodeRole.NAMENODE, (Object)PBHelper.convert((HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto)HdfsProtos.NamenodeRegistrationProto.NamenodeRoleProto.NAMENODE));
    }

    private static StorageInfo getStorageInfo(HdfsServerConstants.NodeType type) {
        return new StorageInfo(1, 2, "cid", 3L, type);
    }

    @Test
    public void testConvertStoragInfo() {
        StorageInfo info = TestPBHelper.getStorageInfo(HdfsServerConstants.NodeType.NAME_NODE);
        HdfsProtos.StorageInfoProto infoProto = PBHelper.convert((StorageInfo)info);
        StorageInfo info2 = PBHelper.convert((HdfsProtos.StorageInfoProto)infoProto, (HdfsServerConstants.NodeType)HdfsServerConstants.NodeType.NAME_NODE);
        Assert.assertEquals((Object)info.getClusterID(), (Object)info2.getClusterID());
        Assert.assertEquals((long)info.getCTime(), (long)info2.getCTime());
        Assert.assertEquals((long)info.getLayoutVersion(), (long)info2.getLayoutVersion());
        Assert.assertEquals((long)info.getNamespaceID(), (long)info2.getNamespaceID());
    }

    @Test
    public void testConvertNamenodeRegistration() {
        StorageInfo info = TestPBHelper.getStorageInfo(HdfsServerConstants.NodeType.NAME_NODE);
        NamenodeRegistration reg = new NamenodeRegistration("address:999", "http:1000", info, HdfsServerConstants.NamenodeRole.NAMENODE);
        HdfsProtos.NamenodeRegistrationProto regProto = PBHelper.convert((NamenodeRegistration)reg);
        NamenodeRegistration reg2 = PBHelper.convert((HdfsProtos.NamenodeRegistrationProto)regProto);
        Assert.assertEquals((Object)reg.getAddress(), (Object)reg2.getAddress());
        Assert.assertEquals((Object)reg.getClusterID(), (Object)reg2.getClusterID());
        Assert.assertEquals((long)reg.getCTime(), (long)reg2.getCTime());
        Assert.assertEquals((Object)reg.getHttpAddress(), (Object)reg2.getHttpAddress());
        Assert.assertEquals((long)reg.getLayoutVersion(), (long)reg2.getLayoutVersion());
        Assert.assertEquals((long)reg.getNamespaceID(), (long)reg2.getNamespaceID());
        Assert.assertEquals((Object)reg.getRegistrationID(), (Object)reg2.getRegistrationID());
        Assert.assertEquals((Object)reg.getRole(), (Object)reg2.getRole());
        Assert.assertEquals((long)reg.getVersion(), (long)reg2.getVersion());
    }

    @Test
    public void testConvertDatanodeID() {
        DatanodeID dn = DFSTestUtil.getLocalDatanodeID();
        HdfsProtos.DatanodeIDProto dnProto = PBHelper.convert((DatanodeID)dn);
        DatanodeID dn2 = PBHelper.convert((HdfsProtos.DatanodeIDProto)dnProto);
        this.compare(dn, dn2);
    }

    void compare(DatanodeID dn, DatanodeID dn2) {
        Assert.assertEquals((Object)dn.getIpAddr(), (Object)dn2.getIpAddr());
        Assert.assertEquals((Object)dn.getHostName(), (Object)dn2.getHostName());
        Assert.assertEquals((Object)dn.getDatanodeUuid(), (Object)dn2.getDatanodeUuid());
        Assert.assertEquals((long)dn.getXferPort(), (long)dn2.getXferPort());
        Assert.assertEquals((long)dn.getInfoPort(), (long)dn2.getInfoPort());
        Assert.assertEquals((long)dn.getIpcPort(), (long)dn2.getIpcPort());
    }

    void compare(DatanodeStorage dns1, DatanodeStorage dns2) {
        Assert.assertThat((Object)dns2.getStorageID(), (Matcher)CoreMatchers.is((Object)dns1.getStorageID()));
        Assert.assertThat((Object)dns2.getState(), (Matcher)CoreMatchers.is((Object)dns1.getState()));
        Assert.assertThat((Object)dns2.getStorageType(), (Matcher)CoreMatchers.is((Object)dns1.getStorageType()));
    }

    @Test
    public void testConvertBlock() {
        Block b = new Block(1L, 100L, 3L);
        HdfsProtos.BlockProto bProto = PBHelper.convert((Block)b);
        Block b2 = PBHelper.convert((HdfsProtos.BlockProto)bProto);
        Assert.assertEquals((Object)b, (Object)b2);
    }

    private static BlocksWithLocations.BlockWithLocations getBlockWithLocations(int bid) {
        String[] datanodeUuids = new String[]{"dn1", "dn2", "dn3"};
        String[] storageIDs = new String[]{"s1", "s2", "s3"};
        StorageType[] storageTypes = new StorageType[]{StorageType.DISK, StorageType.DISK, StorageType.DISK};
        return new BlocksWithLocations.BlockWithLocations(new Block((long)bid, 0L, 1L), datanodeUuids, storageIDs, storageTypes);
    }

    private void compare(BlocksWithLocations.BlockWithLocations locs1, BlocksWithLocations.BlockWithLocations locs2) {
        Assert.assertEquals((Object)locs1.getBlock(), (Object)locs2.getBlock());
        Assert.assertTrue((boolean)Arrays.equals(locs1.getStorageIDs(), locs2.getStorageIDs()));
    }

    @Test
    public void testConvertBlockWithLocations() {
        BlocksWithLocations.BlockWithLocations locs = TestPBHelper.getBlockWithLocations(1);
        HdfsProtos.BlockWithLocationsProto locsProto = PBHelper.convert((BlocksWithLocations.BlockWithLocations)locs);
        BlocksWithLocations.BlockWithLocations locs2 = PBHelper.convert((HdfsProtos.BlockWithLocationsProto)locsProto);
        this.compare(locs, locs2);
    }

    @Test
    public void testConvertBlocksWithLocations() {
        BlocksWithLocations.BlockWithLocations[] list = new BlocksWithLocations.BlockWithLocations[]{TestPBHelper.getBlockWithLocations(1), TestPBHelper.getBlockWithLocations(2)};
        BlocksWithLocations locs = new BlocksWithLocations(list);
        HdfsProtos.BlocksWithLocationsProto locsProto = PBHelper.convert((BlocksWithLocations)locs);
        BlocksWithLocations locs2 = PBHelper.convert((HdfsProtos.BlocksWithLocationsProto)locsProto);
        BlocksWithLocations.BlockWithLocations[] blocks = locs.getBlocks();
        BlocksWithLocations.BlockWithLocations[] blocks2 = locs2.getBlocks();
        Assert.assertEquals((long)blocks.length, (long)blocks2.length);
        for (int i = 0; i < blocks.length; ++i) {
            this.compare(blocks[i], blocks2[i]);
        }
    }

    private static BlockKey getBlockKey(int keyId) {
        return new BlockKey(keyId, 10L, "encodedKey".getBytes());
    }

    private void compare(BlockKey k1, BlockKey k2) {
        Assert.assertEquals((long)k1.getExpiryDate(), (long)k2.getExpiryDate());
        Assert.assertEquals((long)k1.getKeyId(), (long)k2.getKeyId());
        Assert.assertTrue((boolean)Arrays.equals(k1.getEncodedKey(), k2.getEncodedKey()));
    }

    @Test
    public void testConvertBlockKey() {
        BlockKey key = TestPBHelper.getBlockKey(1);
        HdfsProtos.BlockKeyProto keyProto = PBHelper.convert((BlockKey)key);
        BlockKey key1 = PBHelper.convert((HdfsProtos.BlockKeyProto)keyProto);
        this.compare(key, key1);
    }

    @Test
    public void testConvertExportedBlockKeys() {
        BlockKey[] keys = new BlockKey[]{TestPBHelper.getBlockKey(2), TestPBHelper.getBlockKey(3)};
        ExportedBlockKeys expKeys = new ExportedBlockKeys(true, 9L, 10L, TestPBHelper.getBlockKey(1), keys);
        HdfsProtos.ExportedBlockKeysProto expKeysProto = PBHelper.convert((ExportedBlockKeys)expKeys);
        ExportedBlockKeys expKeys1 = PBHelper.convert((HdfsProtos.ExportedBlockKeysProto)expKeysProto);
        this.compare(expKeys, expKeys1);
    }

    void compare(ExportedBlockKeys expKeys, ExportedBlockKeys expKeys1) {
        BlockKey[] allKeys = expKeys.getAllKeys();
        BlockKey[] allKeys1 = expKeys1.getAllKeys();
        Assert.assertEquals((long)allKeys.length, (long)allKeys1.length);
        for (int i = 0; i < allKeys.length; ++i) {
            this.compare(allKeys[i], allKeys1[i]);
        }
        this.compare(expKeys.getCurrentKey(), expKeys1.getCurrentKey());
        Assert.assertEquals((long)expKeys.getKeyUpdateInterval(), (long)expKeys1.getKeyUpdateInterval());
        Assert.assertEquals((long)expKeys.getTokenLifetime(), (long)expKeys1.getTokenLifetime());
    }

    @Test
    public void testConvertCheckpointSignature() {
        CheckpointSignature s = new CheckpointSignature(TestPBHelper.getStorageInfo(HdfsServerConstants.NodeType.NAME_NODE), "bpid", 100L, 1L);
        HdfsProtos.CheckpointSignatureProto sProto = PBHelper.convert((CheckpointSignature)s);
        CheckpointSignature s1 = PBHelper.convert((HdfsProtos.CheckpointSignatureProto)sProto);
        Assert.assertEquals((Object)s.getBlockpoolID(), (Object)s1.getBlockpoolID());
        Assert.assertEquals((Object)s.getClusterID(), (Object)s1.getClusterID());
        Assert.assertEquals((long)s.getCTime(), (long)s1.getCTime());
        Assert.assertEquals((long)s.getCurSegmentTxId(), (long)s1.getCurSegmentTxId());
        Assert.assertEquals((long)s.getLayoutVersion(), (long)s1.getLayoutVersion());
        Assert.assertEquals((long)s.getMostRecentCheckpointTxId(), (long)s1.getMostRecentCheckpointTxId());
        Assert.assertEquals((long)s.getNamespaceID(), (long)s1.getNamespaceID());
    }

    private static void compare(RemoteEditLog l1, RemoteEditLog l2) {
        Assert.assertEquals((long)l1.getEndTxId(), (long)l2.getEndTxId());
        Assert.assertEquals((long)l1.getStartTxId(), (long)l2.getStartTxId());
    }

    @Test
    public void testConvertRemoteEditLog() {
        RemoteEditLog l = new RemoteEditLog(1L, 100L);
        HdfsProtos.RemoteEditLogProto lProto = PBHelper.convert((RemoteEditLog)l);
        RemoteEditLog l1 = PBHelper.convert((HdfsProtos.RemoteEditLogProto)lProto);
        TestPBHelper.compare(l, l1);
    }

    @Test
    public void testConvertRemoteEditLogManifest() {
        ArrayList<RemoteEditLog> logs = new ArrayList<RemoteEditLog>();
        logs.add(new RemoteEditLog(1L, 10L));
        logs.add(new RemoteEditLog(11L, 20L));
        RemoteEditLogManifest m = new RemoteEditLogManifest(logs);
        HdfsProtos.RemoteEditLogManifestProto mProto = PBHelper.convert((RemoteEditLogManifest)m);
        RemoteEditLogManifest m1 = PBHelper.convert((HdfsProtos.RemoteEditLogManifestProto)mProto);
        List logs1 = m1.getLogs();
        Assert.assertEquals((long)logs.size(), (long)logs1.size());
        for (int i = 0; i < logs.size(); ++i) {
            TestPBHelper.compare((RemoteEditLog)logs.get(i), (RemoteEditLog)logs1.get(i));
        }
    }

    public ExtendedBlock getExtendedBlock() {
        return this.getExtendedBlock(1L);
    }

    public ExtendedBlock getExtendedBlock(long blkid) {
        return new ExtendedBlock("bpid", blkid, 100L, 2L);
    }

    private void compare(DatanodeInfo dn1, DatanodeInfo dn2) {
        Assert.assertEquals((Object)dn1.getAdminState(), (Object)dn2.getAdminState());
        Assert.assertEquals((long)dn1.getBlockPoolUsed(), (long)dn2.getBlockPoolUsed());
        Assert.assertEquals((double)dn1.getBlockPoolUsedPercent(), (double)dn2.getBlockPoolUsedPercent(), (double)1.0E-6);
        Assert.assertEquals((long)dn1.getCapacity(), (long)dn2.getCapacity());
        Assert.assertEquals((Object)dn1.getDatanodeReport(), (Object)dn2.getDatanodeReport());
        Assert.assertEquals((long)dn1.getDfsUsed(), (long)dn1.getDfsUsed());
        Assert.assertEquals((double)dn1.getDfsUsedPercent(), (double)dn1.getDfsUsedPercent(), (double)1.0E-6);
        Assert.assertEquals((Object)dn1.getIpAddr(), (Object)dn2.getIpAddr());
        Assert.assertEquals((Object)dn1.getHostName(), (Object)dn2.getHostName());
        Assert.assertEquals((long)dn1.getInfoPort(), (long)dn2.getInfoPort());
        Assert.assertEquals((long)dn1.getIpcPort(), (long)dn2.getIpcPort());
        Assert.assertEquals((long)dn1.getLastUpdate(), (long)dn2.getLastUpdate());
        Assert.assertEquals((long)dn1.getLevel(), (long)dn2.getLevel());
        Assert.assertEquals((Object)dn1.getNetworkLocation(), (Object)dn2.getNetworkLocation());
    }

    @Test
    public void testConvertExtendedBlock() {
        ExtendedBlock b = this.getExtendedBlock();
        HdfsProtos.ExtendedBlockProto bProto = PBHelper.convert((ExtendedBlock)b);
        ExtendedBlock b1 = PBHelper.convert((HdfsProtos.ExtendedBlockProto)bProto);
        Assert.assertEquals((Object)b, (Object)b1);
        b.setBlockId(-1L);
        bProto = PBHelper.convert((ExtendedBlock)b);
        b1 = PBHelper.convert((HdfsProtos.ExtendedBlockProto)bProto);
        Assert.assertEquals((Object)b, (Object)b1);
    }

    @Test
    public void testConvertRecoveringBlock() {
        DatanodeInfo di1 = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo di2 = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] dnInfo = new DatanodeInfo[]{di1, di2};
        BlockRecoveryCommand.RecoveringBlock b = new BlockRecoveryCommand.RecoveringBlock(this.getExtendedBlock(), dnInfo, 3L);
        HdfsProtos.RecoveringBlockProto bProto = PBHelper.convert((BlockRecoveryCommand.RecoveringBlock)b);
        BlockRecoveryCommand.RecoveringBlock b1 = PBHelper.convert((HdfsProtos.RecoveringBlockProto)bProto);
        Assert.assertEquals((Object)b.getBlock(), (Object)b1.getBlock());
        DatanodeInfo[] dnInfo1 = b1.getLocations();
        Assert.assertEquals((long)dnInfo.length, (long)dnInfo1.length);
        for (int i = 0; i < dnInfo.length; ++i) {
            this.compare(dnInfo[0], dnInfo1[0]);
        }
    }

    @Test
    public void testConvertBlockRecoveryCommand() {
        DatanodeInfo di1 = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo di2 = DFSTestUtil.getLocalDatanodeInfo();
        DatanodeInfo[] dnInfo = new DatanodeInfo[]{di1, di2};
        ImmutableList blks = ImmutableList.of((Object)new BlockRecoveryCommand.RecoveringBlock(this.getExtendedBlock(1L), dnInfo, 3L), (Object)new BlockRecoveryCommand.RecoveringBlock(this.getExtendedBlock(2L), dnInfo, 3L));
        BlockRecoveryCommand cmd = new BlockRecoveryCommand((Collection)blks);
        DatanodeProtocolProtos.BlockRecoveryCommandProto proto = PBHelper.convert((BlockRecoveryCommand)cmd);
        Assert.assertEquals((long)1L, (long)proto.getBlocks(0).getBlock().getB().getBlockId());
        Assert.assertEquals((long)2L, (long)proto.getBlocks(1).getBlock().getB().getBlockId());
        BlockRecoveryCommand cmd2 = PBHelper.convert((DatanodeProtocolProtos.BlockRecoveryCommandProto)proto);
        ArrayList cmd2Blks = Lists.newArrayList((Iterable)cmd2.getRecoveringBlocks());
        Assert.assertEquals((Object)((BlockRecoveryCommand.RecoveringBlock)blks.get(0)).getBlock(), (Object)((BlockRecoveryCommand.RecoveringBlock)cmd2Blks.get(0)).getBlock());
        Assert.assertEquals((Object)((BlockRecoveryCommand.RecoveringBlock)blks.get(1)).getBlock(), (Object)((BlockRecoveryCommand.RecoveringBlock)cmd2Blks.get(1)).getBlock());
        Assert.assertEquals((Object)Joiner.on((String)",").join((Iterable)blks), (Object)Joiner.on((String)",").join((Iterable)cmd2Blks));
        Assert.assertEquals((Object)cmd.toString(), (Object)cmd2.toString());
    }

    @Test
    public void testConvertText() {
        Text t = new Text("abc".getBytes());
        String s = t.toString();
        Text t1 = new Text(s);
        Assert.assertEquals((Object)t, (Object)t1);
    }

    @Test
    public void testConvertBlockToken() {
        Token token = new Token("identifier".getBytes(), "password".getBytes(), new Text("kind"), new Text("service"));
        SecurityProtos.TokenProto tokenProto = PBHelper.convert((Token)token);
        Token token2 = PBHelper.convert((SecurityProtos.TokenProto)tokenProto);
        this.compare((Token<BlockTokenIdentifier>)token, (Token<BlockTokenIdentifier>)token2);
    }

    @Test
    public void testConvertNamespaceInfo() {
        NamespaceInfo info = new NamespaceInfo(37, "clusterID", "bpID", 2300L);
        HdfsProtos.NamespaceInfoProto proto = PBHelper.convert((NamespaceInfo)info);
        NamespaceInfo info2 = PBHelper.convert((HdfsProtos.NamespaceInfoProto)proto);
        this.compare((StorageInfo)info, (StorageInfo)info2);
        Assert.assertEquals((Object)info.getBlockPoolID(), (Object)info2.getBlockPoolID());
        Assert.assertEquals((Object)info.getBuildVersion(), (Object)info2.getBuildVersion());
    }

    private void compare(StorageInfo expected, StorageInfo actual) {
        Assert.assertEquals((Object)expected.clusterID, (Object)actual.clusterID);
        Assert.assertEquals((long)expected.namespaceID, (long)actual.namespaceID);
        Assert.assertEquals((long)expected.cTime, (long)actual.cTime);
        Assert.assertEquals((long)expected.layoutVersion, (long)actual.layoutVersion);
    }

    private void compare(Token<BlockTokenIdentifier> expected, Token<BlockTokenIdentifier> actual) {
        Assert.assertTrue((boolean)Arrays.equals(expected.getIdentifier(), actual.getIdentifier()));
        Assert.assertTrue((boolean)Arrays.equals(expected.getPassword(), actual.getPassword()));
        Assert.assertEquals((Object)expected.getKind(), (Object)actual.getKind());
        Assert.assertEquals((Object)expected.getService(), (Object)actual.getService());
    }

    private void compare(LocatedBlock expected, LocatedBlock actual) {
        Assert.assertEquals((Object)expected.getBlock(), (Object)actual.getBlock());
        this.compare((Token<BlockTokenIdentifier>)expected.getBlockToken(), (Token<BlockTokenIdentifier>)actual.getBlockToken());
        Assert.assertEquals((long)expected.getStartOffset(), (long)actual.getStartOffset());
        Assert.assertEquals((Object)expected.isCorrupt(), (Object)actual.isCorrupt());
        DatanodeInfo[] ei = expected.getLocations();
        DatanodeInfo[] ai = actual.getLocations();
        Assert.assertEquals((long)ei.length, (long)ai.length);
        for (int i = 0; i < ei.length; ++i) {
            this.compare(ei[i], ai[i]);
        }
    }

    private LocatedBlock createLocatedBlock() {
        DatanodeInfo[] dnInfos = new DatanodeInfo[]{DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h1", DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS), DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h2", DatanodeInfo.AdminStates.DECOMMISSIONED), DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h3", DatanodeInfo.AdminStates.NORMAL), DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h4", DatanodeInfo.AdminStates.NORMAL)};
        String[] storageIDs = new String[]{"s1", "s2", "s3", "s4"};
        StorageType[] media = new StorageType[]{StorageType.DISK, StorageType.SSD, StorageType.DISK, StorageType.RAM_DISK};
        LocatedBlock lb = new LocatedBlock(new ExtendedBlock("bp12", 12345L, 10L, 53L), dnInfos, storageIDs, media, 5L, false, new DatanodeInfo[0]);
        lb.setBlockToken(new Token("identifier".getBytes(), "password".getBytes(), new Text("kind"), new Text("service")));
        return lb;
    }

    private LocatedBlock createLocatedBlockNoStorageMedia() {
        DatanodeInfo[] dnInfos = new DatanodeInfo[]{DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h1", DatanodeInfo.AdminStates.DECOMMISSION_INPROGRESS), DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h2", DatanodeInfo.AdminStates.DECOMMISSIONED), DFSTestUtil.getLocalDatanodeInfo("127.0.0.1", "h3", DatanodeInfo.AdminStates.NORMAL)};
        LocatedBlock lb = new LocatedBlock(new ExtendedBlock("bp12", 12345L, 10L, 53L), dnInfos, 5L, false);
        lb.setBlockToken(new Token("identifier".getBytes(), "password".getBytes(), new Text("kind"), new Text("service")));
        return lb;
    }

    @Test
    public void testConvertLocatedBlock() {
        LocatedBlock lb = this.createLocatedBlock();
        HdfsProtos.LocatedBlockProto lbProto = PBHelper.convert((LocatedBlock)lb);
        LocatedBlock lb2 = PBHelper.convert((HdfsProtos.LocatedBlockProto)lbProto);
        this.compare(lb, lb2);
    }

    @Test
    public void testConvertLocatedBlockNoStorageMedia() {
        LocatedBlock lb = this.createLocatedBlockNoStorageMedia();
        HdfsProtos.LocatedBlockProto lbProto = PBHelper.convert((LocatedBlock)lb);
        LocatedBlock lb2 = PBHelper.convert((HdfsProtos.LocatedBlockProto)lbProto);
        this.compare(lb, lb2);
    }

    @Test
    public void testConvertLocatedBlockList() {
        ArrayList<LocatedBlock> lbl = new ArrayList<LocatedBlock>();
        for (int i = 0; i < 3; ++i) {
            lbl.add(this.createLocatedBlock());
        }
        List lbpl = PBHelper.convertLocatedBlock2(lbl);
        List lbl2 = PBHelper.convertLocatedBlock((List)lbpl);
        Assert.assertEquals((long)lbl.size(), (long)lbl2.size());
        for (int i = 0; i < lbl.size(); ++i) {
            this.compare((LocatedBlock)lbl.get(i), (LocatedBlock)lbl2.get(2));
        }
    }

    @Test
    public void testConvertLocatedBlockArray() {
        LocatedBlock[] lbl = new LocatedBlock[3];
        for (int i = 0; i < 3; ++i) {
            lbl[i] = this.createLocatedBlock();
        }
        HdfsProtos.LocatedBlockProto[] lbpl = PBHelper.convertLocatedBlock((LocatedBlock[])lbl);
        LocatedBlock[] lbl2 = PBHelper.convertLocatedBlock((HdfsProtos.LocatedBlockProto[])lbpl);
        Assert.assertEquals((long)lbl.length, (long)lbl2.length);
        for (int i = 0; i < lbl.length; ++i) {
            this.compare(lbl[i], lbl2[i]);
        }
    }

    @Test
    public void testConvertDatanodeRegistration() {
        DatanodeID dnId = DFSTestUtil.getLocalDatanodeID();
        BlockKey[] keys = new BlockKey[]{TestPBHelper.getBlockKey(2), TestPBHelper.getBlockKey(3)};
        ExportedBlockKeys expKeys = new ExportedBlockKeys(true, 9L, 10L, TestPBHelper.getBlockKey(1), keys);
        DatanodeRegistration reg = new DatanodeRegistration(dnId, new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE), expKeys, "3.0.0");
        DatanodeProtocolProtos.DatanodeRegistrationProto proto = PBHelper.convert((DatanodeRegistration)reg);
        DatanodeRegistration reg2 = PBHelper.convert((DatanodeProtocolProtos.DatanodeRegistrationProto)proto);
        this.compare(reg.getStorageInfo(), reg2.getStorageInfo());
        this.compare(reg.getExportedKeys(), reg2.getExportedKeys());
        this.compare((DatanodeID)reg, (DatanodeID)reg2);
        Assert.assertEquals((Object)reg.getSoftwareVersion(), (Object)reg2.getSoftwareVersion());
    }

    @Test
    public void TestConvertDatanodeStorage() {
        DatanodeStorage dns1 = new DatanodeStorage("id1", DatanodeStorage.State.NORMAL, StorageType.SSD);
        HdfsProtos.DatanodeStorageProto proto = PBHelper.convert((DatanodeStorage)dns1);
        DatanodeStorage dns2 = PBHelper.convert((HdfsProtos.DatanodeStorageProto)proto);
        this.compare(dns1, dns2);
    }

    @Test
    public void testConvertBlockCommand() {
        Block[] blocks = new Block[]{new Block(21L), new Block(22L)};
        DatanodeInfo[][] dnInfos = new DatanodeInfo[][]{new DatanodeInfo[1], new DatanodeInfo[2]};
        dnInfos[0][0] = DFSTestUtil.getLocalDatanodeInfo();
        dnInfos[1][0] = DFSTestUtil.getLocalDatanodeInfo();
        dnInfos[1][1] = DFSTestUtil.getLocalDatanodeInfo();
        String[][] storageIDs = new String[][]{{"s00"}, {"s10", "s11"}};
        StorageType[][] storageTypes = new StorageType[][]{{StorageType.DEFAULT}, {StorageType.DEFAULT, StorageType.DEFAULT}};
        BlockCommand bc = new BlockCommand(1, "bp1", blocks, (DatanodeInfo[][])dnInfos, (StorageType[][])storageTypes, storageIDs);
        DatanodeProtocolProtos.BlockCommandProto bcProto = PBHelper.convert((BlockCommand)bc);
        BlockCommand bc2 = PBHelper.convert((DatanodeProtocolProtos.BlockCommandProto)bcProto);
        Assert.assertEquals((long)bc.getAction(), (long)bc2.getAction());
        Assert.assertEquals((long)bc.getBlocks().length, (long)bc2.getBlocks().length);
        Block[] blocks2 = bc2.getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            Assert.assertEquals((Object)blocks[i], (Object)blocks2[i]);
        }
        DatanodeInfo[][] dnInfos2 = bc2.getTargets();
        Assert.assertEquals((long)dnInfos.length, (long)dnInfos2.length);
        for (int i = 0; i < dnInfos.length; ++i) {
            DatanodeInfo[] d1 = dnInfos[i];
            DatanodeInfo[] d2 = dnInfos2[i];
            Assert.assertEquals((long)d1.length, (long)d2.length);
            for (int j = 0; j < d1.length; ++j) {
                this.compare(d1[j], d2[j]);
            }
        }
    }

    @Test
    public void testChecksumTypeProto() {
        Assert.assertEquals((Object)DataChecksum.Type.NULL, (Object)PBHelper.convert((HdfsProtos.ChecksumTypeProto)HdfsProtos.ChecksumTypeProto.CHECKSUM_NULL));
        Assert.assertEquals((Object)DataChecksum.Type.CRC32, (Object)PBHelper.convert((HdfsProtos.ChecksumTypeProto)HdfsProtos.ChecksumTypeProto.CHECKSUM_CRC32));
        Assert.assertEquals((Object)DataChecksum.Type.CRC32C, (Object)PBHelper.convert((HdfsProtos.ChecksumTypeProto)HdfsProtos.ChecksumTypeProto.CHECKSUM_CRC32C));
        Assert.assertEquals((Object)PBHelper.convert((DataChecksum.Type)DataChecksum.Type.NULL), (Object)HdfsProtos.ChecksumTypeProto.CHECKSUM_NULL);
        Assert.assertEquals((Object)PBHelper.convert((DataChecksum.Type)DataChecksum.Type.CRC32), (Object)HdfsProtos.ChecksumTypeProto.CHECKSUM_CRC32);
        Assert.assertEquals((Object)PBHelper.convert((DataChecksum.Type)DataChecksum.Type.CRC32C), (Object)HdfsProtos.ChecksumTypeProto.CHECKSUM_CRC32C);
    }

    @Test
    public void testAclEntryProto() {
        AclEntry e1 = new AclEntry.Builder().setName("test").setPermission(FsAction.READ_EXECUTE).setScope(AclEntryScope.DEFAULT).setType(AclEntryType.OTHER).build();
        AclEntry e2 = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setPermission(FsAction.ALL).build();
        AclEntry e3 = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setName("test").build();
        Object[] expected = new AclEntry[]{e1, e2, new AclEntry.Builder().setScope(e3.getScope()).setType(e3.getType()).setName(e3.getName()).setPermission(FsAction.NONE).build()};
        Object[] actual = Lists.newArrayList((Iterable)PBHelper.convertAclEntry((List)PBHelper.convertAclEntryProto((List)Lists.newArrayList((Object[])new AclEntry[]{e1, e2, e3})))).toArray(new AclEntry[0]);
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
    }

    @Test
    public void testAclStatusProto() {
        AclEntry e = new AclEntry.Builder().setName("test").setPermission(FsAction.READ_EXECUTE).setScope(AclEntryScope.DEFAULT).setType(AclEntryType.OTHER).build();
        AclStatus s = new AclStatus.Builder().owner("foo").group("bar").addEntry(e).build();
        Assert.assertEquals((Object)s, (Object)PBHelper.convert((AclProtos.GetAclStatusResponseProto)PBHelper.convert((AclStatus)s)));
    }
}

