/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer.sasl;

import java.io.File;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class SaslDataTransferTestCase {
    private static File baseDir;
    private static String hdfsPrincipal;
    private static MiniKdc kdc;
    private static String keytab;
    private static String spnegoPrincipal;

    @BeforeClass
    public static void initKdc() throws Exception {
        baseDir = new File(System.getProperty("test.build.dir", "target/test-dir"), SaslDataTransferTestCase.class.getSimpleName());
        FileUtil.fullyDelete((File)baseDir);
        Assert.assertTrue((boolean)baseDir.mkdirs());
        Properties kdcConf = MiniKdc.createConf();
        kdc = new MiniKdc(kdcConf, baseDir);
        kdc.start();
        String userName = UserGroupInformation.getLoginUser().getShortUserName();
        File keytabFile = new File(baseDir, userName + ".keytab");
        keytab = keytabFile.getAbsolutePath();
        kdc.createPrincipal(keytabFile, new String[]{userName + "/localhost", "HTTP/localhost"});
        hdfsPrincipal = userName + "/localhost@" + kdc.getRealm();
        spnegoPrincipal = "HTTP/localhost@" + kdc.getRealm();
    }

    @AfterClass
    public static void shutdownKdc() {
        if (kdc != null) {
            kdc.stop();
        }
        FileUtil.fullyDelete((File)baseDir);
    }

    protected HdfsConfiguration createSecureConfig(String dataTransferProtection) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        conf.set("dfs.namenode.kerberos.principal", hdfsPrincipal);
        conf.set("dfs.namenode.keytab.file", keytab);
        conf.set("dfs.datanode.kerberos.principal", hdfsPrincipal);
        conf.set("dfs.datanode.keytab.file", keytab);
        conf.set("dfs.web.authentication.kerberos.principal", spnegoPrincipal);
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.data.transfer.protection", dataTransferProtection);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        conf.setInt("ipc.client.connect.max.retries.on.sasl", 10);
        String keystoresDir = baseDir.getAbsolutePath();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(this.getClass());
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        return conf;
    }
}

