/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TestDFSOutputStream {
    static MiniDFSCluster cluster;

    @BeforeClass
    public static void setup() throws IOException {
        Configuration conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).build();
    }

    @Test
    public void testCloseTwice() throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDataOutputStream os = fs.create(new Path("/test"));
        DFSOutputStream dos = (DFSOutputStream)Whitebox.getInternalState((Object)os, (String)"wrappedStream");
        AtomicReference ex = (AtomicReference)Whitebox.getInternalState((Object)dos, (String)"lastException");
        Assert.assertEquals(null, ex.get());
        dos.close();
        IOException dummy = new IOException("dummy");
        ex.set(dummy);
        try {
            dos.close();
        }
        catch (IOException e) {
            Assert.assertEquals((Object)e, (Object)dummy);
        }
        Assert.assertEquals(null, ex.get());
        dos.close();
    }

    @Test
    public void testComputePacketChunkSize() throws Exception {
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDataOutputStream os = fs.create(new Path("/test"));
        DFSOutputStream dos = (DFSOutputStream)Whitebox.getInternalState((Object)os, (String)"wrappedStream");
        int packetSize = 65536;
        int bytesPerChecksum = 512;
        Method method = dos.getClass().getDeclaredMethod("computePacketChunkSize", Integer.TYPE, Integer.TYPE);
        method.setAccessible(true);
        method.invoke((Object)dos, 65536, 512);
        Field field = dos.getClass().getDeclaredField("packetSize");
        field.setAccessible(true);
        Assert.assertTrue(((Integer)field.get(dos) + 33 < 65536 ? 1 : 0) != 0);
        Assert.assertTrue(((Integer)field.get(dos) + 257 < 65536 ? 1 : 0) != 0);
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }
}

