/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FileDistributionCalculator;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.OfflineImageViewerPB;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageXmlWriter;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.WebImageViewer;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestOfflineImageViewer {
    private static final Log LOG = LogFactory.getLog(OfflineImageViewerPB.class);
    private static final int NUM_DIRS = 3;
    private static final int FILES_PER_DIR = 4;
    private static final String TEST_RENEWER = "JobTracker";
    private static File originalFsimage = null;
    static final HashMap<String, FileStatus> writtenFiles = Maps.newHashMap();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void createOriginalFSImage() throws IOException {
        MiniDFSCluster cluster = null;
        try {
            Token[] delegationTokens;
            Configuration conf = new Configuration();
            conf.setLong("dfs.namenode.delegation.token.max-lifetime", 10000L);
            conf.setLong("dfs.namenode.delegation.token.renew-interval", 5000L);
            conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
            conf.set("hadoop.security.auth_to_local", "RULE:[2:$1@$0](JobTracker@.*FOO.COM)s/@.*//DEFAULT");
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
            cluster.waitActive();
            DistributedFileSystem hdfs = cluster.getFileSystem();
            for (int i = 0; i < 3; ++i) {
                Path dir = new Path("/dir" + i);
                hdfs.mkdirs(dir);
                writtenFiles.put(dir.toString(), TestOfflineImageViewer.pathToFileEntry((FileSystem)hdfs, dir.toString()));
                for (int j = 0; j < 4; ++j) {
                    Path file = new Path(dir, "file" + j);
                    FSDataOutputStream o = hdfs.create(file);
                    o.write(23);
                    o.close();
                    writtenFiles.put(file.toString(), TestOfflineImageViewer.pathToFileEntry((FileSystem)hdfs, file.toString()));
                }
            }
            Path emptydir = new Path("/emptydir");
            hdfs.mkdirs(emptydir);
            writtenFiles.put(emptydir.toString(), hdfs.getFileStatus(emptydir));
            for (Token t : delegationTokens = hdfs.addDelegationTokens(TEST_RENEWER, null)) {
                LOG.debug((Object)("got token " + t));
            }
            Path snapshot = new Path("/snapshot");
            hdfs.mkdirs(snapshot);
            hdfs.allowSnapshot(snapshot);
            hdfs.mkdirs(new Path("/snapshot/1"));
            hdfs.delete(snapshot, true);
            Path xattr = new Path("/xattr");
            hdfs.mkdirs(xattr);
            hdfs.setXAttr(xattr, "user.a1", new byte[]{49, 50, 51});
            hdfs.setXAttr(xattr, "user.a2", new byte[]{55, 56, 57});
            hdfs.setXAttr(xattr, "user.a3", null);
            writtenFiles.put(xattr.toString(), hdfs.getFileStatus(xattr));
            hdfs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
            hdfs.saveNamespace();
            originalFsimage = FSImageTestUtil.findLatestImageFile(FSImageTestUtil.getFSImage(cluster.getNameNode()).getStorage().getStorageDir(0));
            if (originalFsimage == null) {
                throw new RuntimeException("Didn't generate or can't find fsimage");
            }
            LOG.debug((Object)("original FS image file is " + originalFsimage));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @AfterClass
    public static void deleteOriginalFSImage() throws IOException {
        if (originalFsimage != null && originalFsimage.exists()) {
            originalFsimage.delete();
        }
    }

    private static FileStatus pathToFileEntry(FileSystem hdfs, String file) throws IOException {
        return hdfs.getFileStatus(new Path(file));
    }

    @Test(expected=IOException.class)
    public void testTruncatedFSImage() throws IOException {
        File truncatedFile = this.folder.newFile();
        StringWriter output = new StringWriter();
        this.copyPartOfFile(originalFsimage, truncatedFile);
        new FileDistributionCalculator(new Configuration(), 0L, 0, new PrintWriter(output)).visit(new RandomAccessFile(truncatedFile, "r"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPartOfFile(File src, File dest) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        int MAX_BYTES = 700;
        try {
            in = new FileInputStream(src);
            out = new FileOutputStream(dest);
            in.getChannel().transferTo(0L, 700L, out.getChannel());
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{in});
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{in});
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
    }

    @Test
    public void testFileDistributionCalculator() throws IOException {
        StringWriter output = new StringWriter();
        PrintWriter o = new PrintWriter(output);
        new FileDistributionCalculator(new Configuration(), 0L, 0, o).visit(new RandomAccessFile(originalFsimage, "r"));
        o.close();
        Pattern p = Pattern.compile("totalFiles = (\\d+)\n");
        Matcher matcher = p.matcher(output.getBuffer());
        Assert.assertTrue((matcher.find() && matcher.groupCount() == 1 ? 1 : 0) != 0);
        int totalFiles = Integer.parseInt(matcher.group(1));
        Assert.assertEquals((long)12L, (long)totalFiles);
        p = Pattern.compile("totalDirectories = (\\d+)\n");
        matcher = p.matcher(output.getBuffer());
        Assert.assertTrue((matcher.find() && matcher.groupCount() == 1 ? 1 : 0) != 0);
        int totalDirs = Integer.parseInt(matcher.group(1));
        Assert.assertEquals((long)6L, (long)totalDirs);
        FileStatus maxFile = Collections.max(writtenFiles.values(), new Comparator<FileStatus>(){

            @Override
            public int compare(FileStatus first, FileStatus second) {
                return first.getLen() < second.getLen() ? -1 : (first.getLen() == second.getLen() ? 0 : 1);
            }
        });
        p = Pattern.compile("maxFileSize = (\\d+)\n");
        matcher = p.matcher(output.getBuffer());
        Assert.assertTrue((matcher.find() && matcher.groupCount() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)maxFile.getLen(), (long)Long.parseLong(matcher.group(1)));
    }

    @Test
    public void testFileDistributionCalculatorWithOptions() throws IOException {
        int status = OfflineImageViewerPB.run((String[])new String[]{"-i", originalFsimage.getAbsolutePath(), "-o", "-", "-p", "FileDistribution", "-maxSize", "512", "-step", "8"});
        Assert.assertEquals((long)0L, (long)status);
    }

    @Test
    public void testPBImageXmlWriter() throws IOException, SAXException, ParserConfigurationException {
        StringWriter output = new StringWriter();
        PrintWriter o = new PrintWriter(output);
        PBImageXmlWriter v = new PBImageXmlWriter(new Configuration(), o);
        v.visit(new RandomAccessFile(originalFsimage, "r"));
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser parser = spf.newSAXParser();
        String xml = output.getBuffer().toString();
        parser.parse(new InputSource(new StringReader(xml)), new DefaultHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebImageViewer() throws IOException, InterruptedException, URISyntaxException {
        WebImageViewer viewer = new WebImageViewer(NetUtils.createSocketAddr((String)"localhost:0"));
        try {
            viewer.initServer(originalFsimage.getAbsolutePath());
            int port = viewer.getPort();
            URI uri = new URI("webhdfs://localhost:" + String.valueOf(port));
            Configuration conf = new Configuration();
            WebHdfsFileSystem webhdfs = (WebHdfsFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
            FileStatus[] statuses = webhdfs.listStatus(new Path("/"));
            Assert.assertEquals((long)5L, (long)statuses.length);
            statuses = webhdfs.listStatus(new Path("/dir0"));
            Assert.assertEquals((long)4L, (long)statuses.length);
            FileStatus status = webhdfs.listStatus(new Path("/dir0/file0"))[0];
            FileStatus expected = writtenFiles.get("/dir0/file0");
            TestOfflineImageViewer.compareFile(expected, status);
            statuses = webhdfs.listStatus(new Path("/emptydir"));
            Assert.assertEquals((long)0L, (long)statuses.length);
            URL url = new URL("http://localhost:" + port + "/webhdfs/v1/invalid/?op=LISTSTATUS");
            this.verifyHttpResponseCode(404, url);
            url = new URL("http://localhost:" + port + "/webhdfs/v1?op=LISTSTATUS");
            this.verifyHttpResponseCode(404, url);
            status = webhdfs.getFileStatus(new Path("/dir0/file0"));
            TestOfflineImageViewer.compareFile(expected, status);
            url = new URL("http://localhost:" + port + "/webhdfs/v1/invalid/?op=GETFILESTATUS");
            this.verifyHttpResponseCode(404, url);
            url = new URL("http://localhost:" + port + "/webhdfs/v1/?op=INVALID");
            this.verifyHttpResponseCode(400, url);
            url = new URL("http://localhost:" + port + "/webhdfs/v1/?op=LISTSTATUS");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.connect();
            Assert.assertEquals((long)405L, (long)connection.getResponseCode());
        }
        finally {
            viewer.shutdown();
        }
    }

    private static void compareFile(FileStatus expected, FileStatus status) {
        Assert.assertEquals((long)expected.getAccessTime(), (long)status.getAccessTime());
        Assert.assertEquals((long)expected.getBlockSize(), (long)status.getBlockSize());
        Assert.assertEquals((Object)expected.getGroup(), (Object)status.getGroup());
        Assert.assertEquals((long)expected.getLen(), (long)status.getLen());
        Assert.assertEquals((long)expected.getModificationTime(), (long)status.getModificationTime());
        Assert.assertEquals((Object)expected.getOwner(), (Object)status.getOwner());
        Assert.assertEquals((Object)expected.getPermission(), (Object)status.getPermission());
        Assert.assertEquals((long)expected.getReplication(), (long)status.getReplication());
        Assert.assertEquals((Object)expected.isDirectory(), (Object)status.isDirectory());
    }

    private void verifyHttpResponseCode(int expectedCode, URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        Assert.assertEquals((long)expectedCode, (long)connection.getResponseCode());
    }
}

