/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.OfflineEditsViewerHelper;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsViewer;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.StatisticsEditsVisitor;
import org.apache.hadoop.test.PathUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestOfflineEditsViewer {
    private static final Log LOG = LogFactory.getLog(TestOfflineEditsViewer.class);
    private static final String buildDir = PathUtils.getTestDirName(TestOfflineEditsViewer.class);
    private static final OfflineEditsViewerHelper nnHelper = new OfflineEditsViewerHelper();
    private static final ImmutableSet<FSEditLogOpCodes> skippedOps = TestOfflineEditsViewer.skippedOps();
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();

    private static ImmutableSet<FSEditLogOpCodes> skippedOps() {
        ImmutableSet.Builder b = ImmutableSet.builder();
        b.add((Object)FSEditLogOpCodes.OP_DATANODE_ADD).add((Object)FSEditLogOpCodes.OP_DATANODE_REMOVE).add((Object)FSEditLogOpCodes.OP_SET_NS_QUOTA).add((Object)FSEditLogOpCodes.OP_CLEAR_NS_QUOTA).add((Object)FSEditLogOpCodes.OP_SET_GENSTAMP_V1);
        b.add((Object)FSEditLogOpCodes.OP_GET_DELEGATION_TOKEN).add((Object)FSEditLogOpCodes.OP_RENEW_DELEGATION_TOKEN).add((Object)FSEditLogOpCodes.OP_CANCEL_DELEGATION_TOKEN);
        b.add((Object)FSEditLogOpCodes.OP_INVALID);
        return b.build();
    }

    @Before
    public void setUp() throws IOException {
        nnHelper.startCluster(buildDir + "/dfs/");
    }

    @After
    public void tearDown() throws IOException {
        nnHelper.shutdownCluster();
    }

    @Test
    public void testGenerated() throws IOException {
        String edits = nnHelper.generateEdits();
        LOG.info((Object)("Generated edits=" + edits));
        String editsParsedXml = this.folder.newFile("editsParsed.xml").getAbsolutePath();
        String editsReparsed = this.folder.newFile("editsParsed").getAbsolutePath();
        Assert.assertEquals((long)0L, (long)this.runOev(edits, editsParsedXml, "xml", false));
        Assert.assertEquals((long)0L, (long)this.runOev(editsParsedXml, editsReparsed, "binary", false));
        Assert.assertTrue((String)("Edits " + edits + " should have all op codes"), (boolean)this.hasAllOpCodes(edits));
        LOG.info((Object)("Comparing generated file " + editsReparsed + " with reference file " + edits));
        Assert.assertTrue((String)"Generated edits and reparsed (bin to XML to bin) should be same", (boolean)this.filesEqualIgnoreTrailingZeros(edits, editsReparsed));
    }

    @Test
    public void testRecoveryMode() throws IOException {
        String edits = nnHelper.generateEdits();
        FileOutputStream os = new FileOutputStream(edits, true);
        FileChannel editsFile = os.getChannel();
        editsFile.truncate(editsFile.size() - 5L);
        String editsParsedXml = this.folder.newFile("editsRecoveredParsed.xml").getAbsolutePath();
        String editsReparsed = this.folder.newFile("editsRecoveredReparsed").getAbsolutePath();
        String editsParsedXml2 = this.folder.newFile("editsRecoveredParsed2.xml").getAbsolutePath();
        Assert.assertEquals((long)-1L, (long)this.runOev(edits, editsParsedXml, "xml", false));
        Assert.assertEquals((long)0L, (long)this.runOev(edits, editsParsedXml, "xml", true));
        Assert.assertEquals((long)0L, (long)this.runOev(editsParsedXml, editsReparsed, "binary", false));
        Assert.assertEquals((long)0L, (long)this.runOev(editsReparsed, editsParsedXml2, "xml", false));
        Assert.assertTrue((String)"Test round trip", (boolean)this.filesEqualIgnoreTrailingZeros(editsParsedXml, editsParsedXml2));
        os.close();
    }

    @Test
    public void testStored() throws IOException {
        String cacheDir = System.getProperty("test.cache.data", "build/test/cache");
        String editsStored = cacheDir + "/editsStored";
        String editsStoredParsedXml = cacheDir + "/editsStoredParsed.xml";
        String editsStoredReparsed = cacheDir + "/editsStoredReparsed";
        String editsStoredXml = cacheDir + "/editsStored.xml";
        Assert.assertEquals((long)0L, (long)this.runOev(editsStored, editsStoredParsedXml, "xml", false));
        Assert.assertEquals((long)0L, (long)this.runOev(editsStoredParsedXml, editsStoredReparsed, "binary", false));
        Assert.assertTrue((String)("Edits " + editsStored + " should have all op codes"), (boolean)this.hasAllOpCodes(editsStored));
        Assert.assertTrue((String)"Reference XML edits and parsed to XML should be same", (boolean)FileUtils.contentEqualsIgnoreEOL((File)new File(editsStoredXml), (File)new File(editsStoredParsedXml), (String)"UTF-8"));
        Assert.assertTrue((String)"Reference edits and reparsed (bin to XML to bin) should be same", (boolean)this.filesEqualIgnoreTrailingZeros(editsStored, editsStoredReparsed));
    }

    private int runOev(String inFilename, String outFilename, String processor, boolean recovery) throws IOException {
        LOG.info((Object)("Running oev [" + inFilename + "] [" + outFilename + "]"));
        OfflineEditsViewer oev = new OfflineEditsViewer();
        OfflineEditsViewer.Flags flags = new OfflineEditsViewer.Flags();
        flags.setPrintToScreen();
        if (recovery) {
            flags.setRecoveryMode();
        }
        return oev.go(inFilename, outFilename, processor, flags, null);
    }

    private boolean hasAllOpCodes(String inFilename) throws IOException {
        FileOutputStream fout;
        StatisticsEditsVisitor visitor;
        OfflineEditsViewer oev = new OfflineEditsViewer();
        String outFilename = inFilename + ".stats";
        if (oev.go(inFilename, outFilename, "stats", new OfflineEditsViewer.Flags(), (OfflineEditsVisitor)(visitor = new StatisticsEditsVisitor((OutputStream)(fout = new FileOutputStream(outFilename))))) != 0) {
            return false;
        }
        LOG.info((Object)("Statistics for " + inFilename + "\n" + visitor.getStatisticsString()));
        boolean hasAllOpCodes = true;
        for (FSEditLogOpCodes opCode : FSEditLogOpCodes.values()) {
            Long count;
            if (skippedOps.contains((Object)opCode) || (count = (Long)visitor.getStatistics().get(opCode)) != null && count != 0L) continue;
            hasAllOpCodes = false;
            LOG.info((Object)("Opcode " + opCode + " not tested in " + inFilename));
        }
        return hasAllOpCodes;
    }

    private boolean filesEqualIgnoreTrailingZeros(String filenameSmall, String filenameLarge) throws IOException {
        ByteBuffer small = ByteBuffer.wrap(DFSTestUtil.loadFile(filenameSmall));
        ByteBuffer large = ByteBuffer.wrap(DFSTestUtil.loadFile(filenameLarge));
        if (small.capacity() > large.capacity()) {
            ByteBuffer tmpByteBuffer = small;
            small = large;
            large = tmpByteBuffer;
            String tmpFilename = filenameSmall;
            filenameSmall = filenameLarge;
            filenameLarge = tmpFilename;
        }
        small.position(0);
        small.limit(small.capacity());
        large.position(0);
        large.limit(small.capacity());
        if (!small.equals(large)) {
            return false;
        }
        large.clear();
        for (int i = large.limit(); i < large.capacity(); ++i) {
            if (large.get(i) == FSEditLogOpCodes.OP_INVALID.getOpCode()) continue;
            return false;
        }
        return true;
    }
}

