/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSAclBaseTest;
import org.junit.BeforeClass;

public class TestFileContextAcl
extends FSAclBaseTest {
    @BeforeClass
    public static void init() throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
    }

    @Override
    protected FileSystem createFileSystem() throws Exception {
        FileContextFS fcFs = new FileContextFS();
        fcFs.initialize(FileSystem.getDefaultUri((Configuration)conf), conf);
        return fcFs;
    }

    public static class FileContextFS
    extends DistributedFileSystem {
        private FileContext fc;

        public void initialize(URI uri, Configuration conf) throws IOException {
            super.initialize(uri, conf);
            this.fc = FileContext.getFileContext((Configuration)conf);
        }

        public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
            this.fc.modifyAclEntries(path, aclSpec);
        }

        public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
            this.fc.removeAclEntries(path, aclSpec);
        }

        public void removeDefaultAcl(Path path) throws IOException {
            this.fc.removeDefaultAcl(path);
        }

        public void removeAcl(Path path) throws IOException {
            this.fc.removeAcl(path);
        }

        public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
            this.fc.setAcl(path, aclSpec);
        }

        public AclStatus getAclStatus(Path path) throws IOException {
            return this.fc.getAclStatus(path);
        }
    }
}

