/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFSDirectory {
    public static final Log LOG = LogFactory.getLog(TestFSDirectory.class);
    private static final long seed = 0L;
    private static final short REPLICATION = 3;
    private final Path dir = new Path("/" + this.getClass().getSimpleName());
    private final Path sub1 = new Path(this.dir, "sub1");
    private final Path file1 = new Path(this.sub1, "file1");
    private final Path file2 = new Path(this.sub1, "file2");
    private final Path sub11 = new Path(this.sub1, "sub11");
    private final Path file3 = new Path(this.sub11, "file3");
    private final Path file5 = new Path(this.sub1, "z_file5");
    private final Path sub2 = new Path(this.dir, "sub2");
    private final Path file6 = new Path(this.sub2, "file6");
    private Configuration conf;
    private MiniDFSCluster cluster;
    private FSNamesystem fsn;
    private FSDirectory fsdir;
    private DistributedFileSystem hdfs;
    private static final int numGeneratedXAttrs = 256;
    private static final ImmutableList<XAttr> generatedXAttrs = ImmutableList.copyOf(TestFSDirectory.generateXAttrs(256));

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 2);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.fsdir = this.fsn.getFSDirectory();
        this.hdfs = this.cluster.getFileSystem();
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file1, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file2, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file3, 1024L, (short)3, 0L);
        DFSTestUtil.createFile((FileSystem)this.hdfs, this.file5, 1024L, (short)3, 0L);
        this.hdfs.mkdirs(this.sub2);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testDumpTree() throws Exception {
        INode root = this.fsdir.getINode("/");
        LOG.info((Object)"Original tree");
        StringBuffer b1 = root.dumpTreeRecursively();
        System.out.println("b1=" + b1);
        BufferedReader in = new BufferedReader(new StringReader(b1.toString()));
        String line = in.readLine();
        TestFSDirectory.checkClassName(line);
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.contains("snapshot")) continue;
            Assert.assertTrue((String)("line=" + line), (line.startsWith("\\-") || line.startsWith("+-") ? 1 : 0) != 0);
            TestFSDirectory.checkClassName(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipQuotaCheck() throws Exception {
        try {
            this.hdfs.setQuota(this.sub2, 1L, Long.MAX_VALUE);
            try {
                DFSTestUtil.createFile((FileSystem)this.hdfs, this.file6, 1024L, (short)3, 0L);
                throw new IOException("The create should have failed.");
            }
            catch (NSQuotaExceededException qe) {
                this.fsdir.disableQuotaChecks();
                DFSTestUtil.createFile((FileSystem)this.hdfs, this.file6, 1024L, (short)3, 0L);
                this.hdfs.delete(this.file6, false);
                this.fsdir.enableQuotaChecks();
                try {
                    DFSTestUtil.createFile((FileSystem)this.hdfs, this.file6, 1024L, (short)3, 0L);
                    throw new IOException("The create should have failed.");
                }
                catch (NSQuotaExceededException nSQuotaExceededException) {
                    this.hdfs.delete(this.file6, false);
                    this.hdfs.setQuota(this.sub2, Long.MAX_VALUE, Long.MAX_VALUE);
                }
            }
        }
        catch (Throwable throwable) {
            this.hdfs.delete(this.file6, false);
            this.hdfs.setQuota(this.sub2, Long.MAX_VALUE, Long.MAX_VALUE);
            throw throwable;
        }
    }

    static void checkClassName(String line) {
        int j;
        int i = line.lastIndexOf(40);
        String classname = line.substring(i + 1, j = line.lastIndexOf(64));
        Assert.assertTrue((classname.startsWith(INodeFile.class.getSimpleName()) || classname.startsWith(INodeDirectory.class.getSimpleName()) ? 1 : 0) != 0);
    }

    @Test
    public void testINodeXAttrsLimit() throws Exception {
        ArrayList existingXAttrs = Lists.newArrayListWithCapacity((int)2);
        XAttr xAttr1 = new XAttr.Builder().setNameSpace(XAttr.NameSpace.USER).setName("a1").setValue(new byte[]{49, 50, 51}).build();
        XAttr xAttr2 = new XAttr.Builder().setNameSpace(XAttr.NameSpace.USER).setName("a2").setValue(new byte[]{49, 49, 49}).build();
        existingXAttrs.add(xAttr1);
        existingXAttrs.add(xAttr2);
        XAttr newXAttr = new XAttr.Builder().setNameSpace(XAttr.NameSpace.SYSTEM).setName("a3").setValue(new byte[]{51, 51, 51}).build();
        ArrayList newXAttrs = Lists.newArrayListWithCapacity((int)1);
        newXAttrs.add(newXAttr);
        List xAttrs = this.fsdir.setINodeXAttrs((List)existingXAttrs, (List)newXAttrs, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        Assert.assertEquals((long)xAttrs.size(), (long)3L);
        XAttr newXAttr1 = new XAttr.Builder().setNameSpace(XAttr.NameSpace.TRUSTED).setName("a4").setValue(new byte[]{52, 52, 52}).build();
        newXAttrs.set(0, newXAttr1);
        try {
            this.fsdir.setINodeXAttrs((List)existingXAttrs, (List)newXAttrs, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
            Assert.fail((String)"Setting user visible xattr on inode should fail if reaching limit.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot add additional XAttr to inode, would exceed limit", (Throwable)e);
        }
    }

    private static void verifyXAttrsPresent(List<XAttr> newXAttrs, int num) {
        Assert.assertEquals((String)"Unexpected number of XAttrs after multiset", (long)num, (long)newXAttrs.size());
        for (int i = 0; i < num; ++i) {
            XAttr search = (XAttr)generatedXAttrs.get(i);
            Assert.assertTrue((String)("Did not find set XAttr " + search + " + after multiset"), (boolean)newXAttrs.contains(search));
        }
    }

    private static List<XAttr> generateXAttrs(int numXAttrs) {
        ArrayList generatedXAttrs = Lists.newArrayListWithCapacity((int)numXAttrs);
        for (int i = 0; i < numXAttrs; ++i) {
            XAttr xAttr = new XAttr.Builder().setNameSpace(XAttr.NameSpace.SYSTEM).setName("a" + i).setValue(new byte[]{(byte)i, (byte)(i + 1), (byte)(i + 2)}).build();
            generatedXAttrs.add(xAttr);
        }
        return generatedXAttrs;
    }

    @Test(timeout=300000L)
    public void testXAttrMultiSetRemove() throws Exception {
        List existingXAttrs = Lists.newArrayListWithCapacity((int)0);
        Random rand = new Random(1044186L);
        int numExpectedXAttrs = 0;
        while (numExpectedXAttrs < 256) {
            int i;
            LOG.info((Object)("Currently have " + numExpectedXAttrs + " xattrs"));
            int numToAdd = rand.nextInt(5) + 1;
            ArrayList toAdd = Lists.newArrayListWithCapacity((int)numToAdd);
            for (i = 0; i < numToAdd && numExpectedXAttrs < 256; ++numExpectedXAttrs, ++i) {
                toAdd.add(generatedXAttrs.get(numExpectedXAttrs));
            }
            LOG.info((Object)("Attempting to add " + toAdd.size() + " XAttrs"));
            for (i = 0; i < toAdd.size(); ++i) {
                LOG.info((Object)("Will add XAttr " + toAdd.get(i)));
            }
            List newXAttrs = this.fsdir.setINodeXAttrs(existingXAttrs, (List)toAdd, EnumSet.of(XAttrSetFlag.CREATE));
            TestFSDirectory.verifyXAttrsPresent(newXAttrs, numExpectedXAttrs);
            existingXAttrs = newXAttrs;
        }
        while (numExpectedXAttrs > 0) {
            LOG.info((Object)("Currently have " + numExpectedXAttrs + " xattrs"));
            int numToRemove = rand.nextInt(5) + 1;
            ArrayList toRemove = Lists.newArrayListWithCapacity((int)numToRemove);
            for (int i = 0; i < numToRemove && numExpectedXAttrs != 0; --numExpectedXAttrs, ++i) {
                toRemove.add(generatedXAttrs.get(numExpectedXAttrs - 1));
            }
            int expectedNumToRemove = toRemove.size();
            LOG.info((Object)("Attempting to remove " + expectedNumToRemove + " XAttrs"));
            ArrayList removedXAttrs = Lists.newArrayList();
            List newXAttrs = this.fsdir.filterINodeXAttrs(existingXAttrs, (List)toRemove, (List)removedXAttrs);
            Assert.assertEquals((String)"Unexpected number of removed XAttrs", (long)expectedNumToRemove, (long)removedXAttrs.size());
            TestFSDirectory.verifyXAttrsPresent(newXAttrs, numExpectedXAttrs);
            existingXAttrs = newXAttrs;
        }
    }

    @Test(timeout=300000L)
    public void testXAttrMultiAddRemoveErrors() throws Exception {
        int i;
        List existingXAttrs = Lists.newArrayList();
        ArrayList toAdd = Lists.newArrayList();
        toAdd.add(generatedXAttrs.get(0));
        toAdd.add(generatedXAttrs.get(1));
        toAdd.add(generatedXAttrs.get(2));
        toAdd.add(generatedXAttrs.get(0));
        try {
            this.fsdir.setINodeXAttrs(existingXAttrs, (List)toAdd, EnumSet.of(XAttrSetFlag.CREATE));
            Assert.fail((String)"Specified the same xattr to be set twice");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot specify the same XAttr to be set", (Throwable)e);
        }
        toAdd.remove(generatedXAttrs.get(0));
        existingXAttrs.add(generatedXAttrs.get(0));
        try {
            this.fsdir.setINodeXAttrs(existingXAttrs, (List)toAdd, EnumSet.of(XAttrSetFlag.CREATE));
            Assert.fail((String)"Set XAttr that is already set without REPLACE flag");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"already exists", (Throwable)e);
        }
        try {
            this.fsdir.setINodeXAttrs(existingXAttrs, (List)toAdd, EnumSet.of(XAttrSetFlag.REPLACE));
            Assert.fail((String)"Set XAttr that does not exist without the CREATE flag");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"does not exist", (Throwable)e);
        }
        toAdd.remove(generatedXAttrs.get(0));
        List newXAttrs = this.fsdir.setINodeXAttrs(existingXAttrs, (List)toAdd, EnumSet.of(XAttrSetFlag.CREATE));
        Assert.assertEquals((String)"Unexpected toAdd size", (long)2L, (long)toAdd.size());
        for (XAttr x : toAdd) {
            Assert.assertTrue((String)("Did not find added XAttr " + x), (boolean)newXAttrs.contains(x));
        }
        existingXAttrs = newXAttrs;
        toAdd = Lists.newArrayList();
        for (i = 0; i < 3; ++i) {
            XAttr xAttr = new XAttr.Builder().setNameSpace(XAttr.NameSpace.SYSTEM).setName("a" + i).setValue(new byte[]{(byte)(i * 2)}).build();
            toAdd.add(xAttr);
        }
        newXAttrs = this.fsdir.setINodeXAttrs(existingXAttrs, (List)toAdd, EnumSet.of(XAttrSetFlag.REPLACE));
        Assert.assertEquals((String)"Unexpected number of new XAttrs", (long)3L, (long)newXAttrs.size());
        for (i = 0; i < 3; ++i) {
            Assert.assertArrayEquals((String)"Unexpected XAttr value", (byte[])new byte[]{(byte)(i * 2)}, (byte[])((XAttr)newXAttrs.get(i)).getValue());
        }
        existingXAttrs = newXAttrs;
        toAdd = Lists.newArrayList();
        for (i = 0; i < 4; ++i) {
            toAdd.add(generatedXAttrs.get(i));
        }
        newXAttrs = this.fsdir.setINodeXAttrs(existingXAttrs, (List)toAdd, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        TestFSDirectory.verifyXAttrsPresent(newXAttrs, 4);
    }
}

