/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.SortedSet;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.junit.Assert;
import org.junit.Test;

public class TestLayoutVersion {
    public static final LayoutVersion.LayoutFeature LAST_NON_RESERVED_COMMON_FEATURE;
    public static final LayoutVersion.LayoutFeature LAST_COMMON_FEATURE;

    @Test
    public void testFeaturesFromAncestorSupported() {
        for (LayoutVersion.Feature f : LayoutVersion.Feature.values()) {
            this.validateFeatureList((LayoutVersion.LayoutFeature)f);
        }
    }

    @Test
    public void testRelease203() {
        Assert.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.DELEGATION_TOKEN, (int)LayoutVersion.Feature.RESERVED_REL20_203.getInfo().getLayoutVersion()));
    }

    @Test
    public void testRelease204() {
        Assert.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.DELEGATION_TOKEN, (int)LayoutVersion.Feature.RESERVED_REL20_204.getInfo().getLayoutVersion()));
    }

    @Test
    public void testRelease1_2_0() {
        Assert.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LayoutVersion.Feature.CONCAT, (int)LayoutVersion.Feature.RESERVED_REL1_2_0.getInfo().getLayoutVersion()));
    }

    @Test
    public void testNameNodeFeature() {
        NameNodeLayoutVersion.Feature first = NameNodeLayoutVersion.Feature.ROLLING_UPGRADE;
        Assert.assertTrue((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LAST_NON_RESERVED_COMMON_FEATURE, (int)first.getInfo().getLayoutVersion()));
        Assert.assertEquals((long)(LAST_COMMON_FEATURE.getInfo().getLayoutVersion() - 1), (long)first.getInfo().getLayoutVersion());
    }

    @Test
    public void testDataNodeFeature() {
        DataNodeLayoutVersion.Feature first = DataNodeLayoutVersion.Feature.FIRST_LAYOUT;
        Assert.assertTrue((boolean)DataNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)LAST_NON_RESERVED_COMMON_FEATURE, (int)first.getInfo().getLayoutVersion()));
        Assert.assertEquals((long)(LAST_COMMON_FEATURE.getInfo().getLayoutVersion() - 1), (long)first.getInfo().getLayoutVersion());
    }

    private void validateFeatureList(LayoutVersion.LayoutFeature f) {
        LayoutVersion.FeatureInfo info = f.getInfo();
        int lv = info.getLayoutVersion();
        int ancestorLV = info.getAncestorLayoutVersion();
        SortedSet ancestorSet = NameNodeLayoutVersion.getFeatures((int)ancestorLV);
        Assert.assertNotNull((Object)ancestorSet);
        for (LayoutVersion.LayoutFeature feature : ancestorSet) {
            Assert.assertTrue((String)("LV " + lv + " does nto support " + feature + " supported by the ancestor LV " + info.getAncestorLayoutVersion()), (boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)feature, (int)lv));
        }
    }

    static {
        LayoutVersion.Feature[] features = LayoutVersion.Feature.values();
        LAST_COMMON_FEATURE = features[features.length - 1];
        LAST_NON_RESERVED_COMMON_FEATURE = LayoutVersion.getLastNonReservedFeature((LayoutVersion.LayoutFeature[])features);
    }
}

