/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaHandler;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.UnexpectedReplicaStateException;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeReference;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.LengthInputStream;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaInputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetFactory;
import org.apache.hadoop.hdfs.server.datanode.metrics.FSDatasetMBean;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReplicaRecoveryInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.util.AutoCloseableLock;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public interface FsDatasetSpi<V extends FsVolumeSpi>
extends FSDatasetMBean {
    public FsVolumeReferences getFsVolumeReferences();

    public void addVolume(StorageLocation var1, List<NamespaceInfo> var2) throws IOException;

    public void removeVolumes(Set<File> var1, boolean var2);

    public DatanodeStorage getStorage(String var1);

    public StorageReport[] getStorageReports(String var1) throws IOException;

    public V getVolume(ExtendedBlock var1);

    public Map<String, Object> getVolumeInfoMap();

    public VolumeFailureSummary getVolumeFailureSummary();

    public List<FinalizedReplica> getFinalizedBlocks(String var1);

    public void checkAndUpdate(String var1, long var2, File var4, File var5, FsVolumeSpi var6) throws IOException;

    public LengthInputStream getMetaDataInputStream(ExtendedBlock var1) throws IOException;

    public long getLength(ExtendedBlock var1) throws IOException;

    @Deprecated
    public Replica getReplica(String var1, long var2);

    public String getReplicaString(String var1, long var2);

    public Block getStoredBlock(String var1, long var2) throws IOException;

    public InputStream getBlockInputStream(ExtendedBlock var1, long var2) throws IOException;

    public ReplicaInputStreams getTmpInputStreams(ExtendedBlock var1, long var2, long var4) throws IOException;

    public ReplicaHandler createTemporary(StorageType var1, ExtendedBlock var2, boolean var3) throws IOException;

    public ReplicaHandler createRbw(StorageType var1, ExtendedBlock var2, boolean var3) throws IOException;

    public ReplicaHandler recoverRbw(ExtendedBlock var1, long var2, long var4, long var6) throws IOException;

    public ReplicaInPipelineInterface convertTemporaryToRbw(ExtendedBlock var1) throws IOException;

    public ReplicaHandler append(ExtendedBlock var1, long var2, long var4) throws IOException;

    public ReplicaHandler recoverAppend(ExtendedBlock var1, long var2, long var4) throws IOException;

    public Replica recoverClose(ExtendedBlock var1, long var2, long var4) throws IOException;

    public void finalizeBlock(ExtendedBlock var1, boolean var2) throws IOException;

    public void unfinalizeBlock(ExtendedBlock var1) throws IOException;

    public Map<DatanodeStorage, BlockListAsLongs> getBlockReports(String var1);

    public List<Long> getCacheReport(String var1);

    public boolean contains(ExtendedBlock var1);

    public void checkBlock(ExtendedBlock var1, long var2, HdfsServerConstants.ReplicaState var4) throws ReplicaNotFoundException, UnexpectedReplicaStateException, FileNotFoundException, EOFException, IOException;

    public boolean isValidBlock(ExtendedBlock var1);

    public boolean isValidRbw(ExtendedBlock var1);

    public void invalidate(String var1, Block[] var2) throws IOException;

    public void cache(String var1, long[] var2);

    public void uncache(String var1, long[] var2);

    public boolean isCached(String var1, long var2);

    public void handleVolumeFailures(Set<FsVolumeSpi> var1);

    public void shutdown();

    public void adjustCrcChannelPosition(ExtendedBlock var1, ReplicaOutputStreams var2, int var3) throws IOException;

    public boolean hasEnoughResource();

    public long getReplicaVisibleLength(ExtendedBlock var1) throws IOException;

    public ReplicaRecoveryInfo initReplicaRecovery(BlockRecoveryCommand.RecoveringBlock var1) throws IOException;

    public Replica updateReplicaUnderRecovery(ExtendedBlock var1, long var2, long var4, long var6) throws IOException;

    public void addBlockPool(String var1, Configuration var2) throws IOException;

    public void shutdownBlockPool(String var1);

    public void deleteBlockPool(String var1, boolean var2) throws IOException;

    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock var1) throws IOException;

    public HdfsBlocksMetadata getHdfsBlocksMetadata(String var1, long[] var2) throws IOException;

    public void enableTrash(String var1);

    public void clearTrash(String var1);

    public boolean trashEnabled(String var1);

    public void setRollingUpgradeMarker(String var1) throws IOException;

    public void clearRollingUpgradeMarker(String var1) throws IOException;

    public void submitBackgroundSyncFileRangeRequest(ExtendedBlock var1, ReplicaOutputStreams var2, long var3, long var5, int var7);

    public void onCompleteLazyPersist(String var1, long var2, long var4, File[] var6, V var7);

    public void onFailLazyPersist(String var1, long var2);

    public ReplicaInfo moveBlockAcrossStorage(ExtendedBlock var1, StorageType var2) throws IOException;

    public void setPinning(ExtendedBlock var1) throws IOException;

    public boolean getPinning(ExtendedBlock var1) throws IOException;

    public boolean isDeletingBlock(String var1, long var2);

    public AutoCloseableLock acquireDatasetLock();

    public AutoCloseableLock acquireDatasetReadLock();

    public Set<? extends Replica> deepCopyReplica(String var1) throws IOException;

    public static class FsVolumeReferences
    implements Iterable<FsVolumeSpi>,
    Closeable {
        private final List<FsVolumeReference> references = new ArrayList<FsVolumeReference>();

        public <S extends FsVolumeSpi> FsVolumeReferences(List<S> curVolumes) {
            for (FsVolumeSpi v : curVolumes) {
                try {
                    this.references.add(v.obtainReference());
                }
                catch (ClosedChannelException closedChannelException) {}
            }
        }

        @Override
        public Iterator<FsVolumeSpi> iterator() {
            return new FsVolumeSpiIterator(this.references);
        }

        public int size() {
            return this.references.size();
        }

        public FsVolumeSpi get(int index) {
            return this.references.get(index).getVolume();
        }

        public FsVolumeReference getReference(int index) {
            return this.references.get(index);
        }

        @Override
        public void close() throws IOException {
            IOException ioe = null;
            for (FsVolumeReference ref : this.references) {
                try {
                    ref.close();
                }
                catch (IOException e) {
                    ioe = e;
                }
            }
            this.references.clear();
            if (ioe != null) {
                throw ioe;
            }
        }

        private static class FsVolumeSpiIterator
        implements Iterator<FsVolumeSpi> {
            private final List<FsVolumeReference> references;
            private int idx = 0;

            FsVolumeSpiIterator(List<FsVolumeReference> refs) {
                this.references = refs;
            }

            @Override
            public boolean hasNext() {
                return this.idx < this.references.size();
            }

            @Override
            public FsVolumeSpi next() {
                int refIdx = this.idx++;
                return this.references.get(refIdx).getVolume();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static abstract class Factory<D extends FsDatasetSpi<?>> {
        public static Factory<?> getFactory(Configuration conf) {
            Class clazz = conf.getClass("dfs.datanode.fsdataset.factory", FsDatasetFactory.class, Factory.class);
            return (Factory)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
        }

        public abstract D newInstance(DataNode var1, DataStorage var2, Configuration var3) throws IOException;

        public boolean isSimulated() {
            return false;
        }
    }
}

