/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.Arrays;

public class FileNameGenerator {
    private static final int DEFAULT_FILES_PER_DIRECTORY = 32;
    private final int[] pathIndecies = new int[20];
    private final String baseDir;
    private String currentDir;
    private final int filesPerDirectory;
    private long fileCount;

    FileNameGenerator(String baseDir) {
        this(baseDir, 32);
    }

    FileNameGenerator(String baseDir, int filesPerDir) {
        this.baseDir = baseDir;
        this.filesPerDirectory = filesPerDir;
        this.reset();
    }

    String getNextDirName(String prefix) {
        int level;
        int depth = 0;
        while (this.pathIndecies[depth] >= 0) {
            ++depth;
        }
        for (level = depth - 1; level >= 0 && this.pathIndecies[level] == this.filesPerDirectory - 1; --level) {
            this.pathIndecies[level] = 0;
        }
        if (level < 0) {
            this.pathIndecies[depth] = 0;
        } else {
            int n = level;
            this.pathIndecies[n] = this.pathIndecies[n] + 1;
        }
        level = 0;
        String next = this.baseDir;
        while (this.pathIndecies[level] >= 0) {
            next = next + "/" + prefix + this.pathIndecies[level++];
        }
        return next;
    }

    synchronized String getNextFileName(String fileNamePrefix) {
        long fNum = this.fileCount % (long)this.filesPerDirectory;
        if (fNum == 0L) {
            this.currentDir = this.getNextDirName(fileNamePrefix + "Dir");
        }
        String fn = this.currentDir + "/" + fileNamePrefix + this.fileCount;
        ++this.fileCount;
        return fn;
    }

    private synchronized void reset() {
        Arrays.fill(this.pathIndecies, -1);
        this.fileCount = 0L;
        this.currentDir = "";
    }

    synchronized int getFilesPerDirectory() {
        return this.filesPerDirectory;
    }

    synchronized String getCurrentDir() {
        return this.currentDir;
    }
}

