/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.datanode.FSCachingGetSpaceUsed;
import org.apache.hadoop.hdfs.server.datanode.Replica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReplicaCachingGetSpaceUsed
extends FSCachingGetSpaceUsed {
    static final Logger LOG = LoggerFactory.getLogger(ReplicaCachingGetSpaceUsed.class);
    private static final long DEEP_COPY_REPLICA_THRESHOLD_MS = 50L;
    private static final long REPLICA_CACHING_GET_SPACE_USED_THRESHOLD_MS = 1000L;
    private final FsVolumeImpl volume;
    private final String bpid;

    public ReplicaCachingGetSpaceUsed(FSCachingGetSpaceUsed.Builder builder) throws IOException {
        super(builder);
        this.volume = builder.getVolume();
        this.bpid = builder.getBpid();
    }

    protected void refresh() {
        long start = Time.monotonicNow();
        long dfsUsed = 0L;
        long count = 0L;
        FsDatasetSpi<? extends FsVolumeSpi> fsDataset = this.volume.getDataset();
        try {
            Set<Replica> replicaInfos = fsDataset.deepCopyReplica(this.bpid);
            long cost = Time.monotonicNow() - start;
            if (cost > 50L) {
                LOG.debug("Copy replica infos, blockPoolId: {}, replicas size: {}, duration: {}ms", new Object[]{this.bpid, replicaInfos.size(), Time.monotonicNow() - start});
            }
            if (CollectionUtils.isNotEmpty(replicaInfos)) {
                for (ReplicaInfo replicaInfo : replicaInfos) {
                    if (!Objects.equals(replicaInfo.getVolume().getStorageID(), this.volume.getStorageID())) continue;
                    dfsUsed += replicaInfo.getBytesOnDisk();
                    dfsUsed += replicaInfo.getMetaFile().length();
                    ++count;
                }
            }
            this.used.set(dfsUsed);
            cost = Time.monotonicNow() - start;
            if (cost > 1000L) {
                LOG.debug("Refresh dfs used, bpid: {}, replicas size: {}, dfsUsed: {} on volume: {}, duration: {}ms", new Object[]{this.bpid, count, this.used, this.volume.getStorageID(), Time.monotonicNow() - start});
            }
        }
        catch (Exception e) {
            LOG.error("ReplicaCachingGetSpaceUsed refresh error", (Throwable)e);
        }
    }
}

