/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.ha.HAStressTestHarness;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestSeveralNameNodes {
    private static final Log LOG = LogFactory.getLog(TestSeveralNameNodes.class);
    private static final int TIME_BETWEEN_FAILOVERS = 200;
    private static final int NUM_NAMENODES = 3;
    private static final int NUM_THREADS = 3;
    private static final int LIST_LENGTH = 50;
    private static final long RUNTIME = 100000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCircularLinkedListWrites() throws Exception {
        HAStressTestHarness harness = new HAStressTestHarness();
        harness.setNumberOfNameNodes(3);
        harness.addFailoverThread(200);
        MiniDFSCluster cluster = harness.startCluster();
        try {
            cluster.waitActive();
            cluster.transitionToActive(0);
            FileSystem fs = harness.getFailoverFs();
            MultithreadedTestUtil.TestContext context = harness.testCtx;
            ArrayList<CircularWriter> writers = new ArrayList<CircularWriter>();
            for (int i = 0; i < 3; ++i) {
                Path p = new Path("/test-" + i);
                fs.mkdirs(p);
                CircularWriter writer = new CircularWriter(context, 50, fs, p);
                writers.add(writer);
                context.addThread((MultithreadedTestUtil.TestingThread)writer);
            }
            harness.startThreads();
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() - start < 100000L) {
                for (int i = 0; i < writers.size(); ++i) {
                    CircularWriter writer = (CircularWriter)((Object)writers.get(i));
                    if (!writer.done.await(10L, TimeUnit.MILLISECONDS)) continue;
                    writers.remove(i--);
                }
            }
            Assert.assertEquals((String)("Some writers didn't complete in expected runtime! Current writer state:" + writers), (long)0L, (long)writers.size());
            harness.stopThreads();
        }
        finally {
            System.err.println("===========================\n\n\n\n");
            harness.shutdown();
        }
    }

    private static class CircularWriter
    extends MultithreadedTestUtil.RepeatingTestThread {
        private final int maxLength;
        private final Path dir;
        private final FileSystem fs;
        private int currentListIndex = 0;
        private CountDownLatch done = new CountDownLatch(1);

        public CircularWriter(MultithreadedTestUtil.TestContext context, int listLength, FileSystem fs, Path parentDir) {
            super(context);
            this.fs = fs;
            this.maxLength = listLength;
            this.dir = parentDir;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Circular Writer:\n");
            builder.append("\t directory: " + this.dir + "\n");
            builder.append("\t target length: " + this.maxLength + "\n");
            builder.append("\t current item: " + this.currentListIndex + "\n");
            builder.append("\t done: " + (this.done.getCount() == 0L) + "\n");
            return builder.toString();
        }

        public void doAnAction() throws Exception {
            if (this.currentListIndex == this.maxLength) {
                this.checkList();
                this.stopTestThread();
                this.done.countDown();
            } else {
                this.writeList();
            }
        }

        private void checkList() throws IOException {
            for (int i = 0; i < this.maxLength; ++i) {
                Path nextFile = this.getNextFile(i);
                if (!this.fs.exists(nextFile)) {
                    throw new RuntimeException("Next file " + nextFile + " for list does not exist!");
                }
                FSDataInputStream in = this.fs.open(nextFile);
                nextFile = this.getNextFile(in.read());
                in.close();
            }
        }

        private void cleanup() throws IOException {
            if (!this.fs.delete(this.dir, true)) {
                throw new RuntimeException("Didn't correctly delete " + this.dir);
            }
            if (!this.fs.mkdirs(this.dir)) {
                throw new RuntimeException("Didn't correctly make directory " + this.dir);
            }
        }

        private void writeList() throws IOException {
            Path nextPath = this.getNextFile(this.currentListIndex++);
            LOG.info((Object)("Writing next file: " + nextPath));
            FSDataOutputStream file = this.fs.create(nextPath);
            file.write(this.currentListIndex);
            file.close();
        }

        private Path getNextFile(int i) {
            return new Path(this.dir, Integer.toString(i));
        }
    }
}

