/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.TestFileTruncate;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.tools.DFSck;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestHAAppend {
    static final int COUNT = 5;

    static FSDataOutputStream createAndHflush(FileSystem fs, Path file, byte[] data, int length) throws IOException {
        FSDataOutputStream out = fs.create(file, false, 4096, (short)3, 1024L);
        out.write(data, 0, length);
        out.hflush();
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleAppendsDuringCatchupTailing() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.ha.tail-edits.period", "5000");
        conf.setInt("dfs.ha.log-roll.period", -1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(3).build();
        DistributedFileSystem fs = null;
        try {
            cluster.transitionToActive(0);
            fs = HATestUtil.configureFailoverFs(cluster, conf);
            Path fileToAppend = new Path("/FileToAppend");
            Path fileToTruncate = new Path("/FileToTruncate");
            byte[] data = new byte[65536];
            ThreadLocalRandom.current().nextBytes(data);
            int[] appendPos = AppendTestUtil.randomFilePartition(data.length, 5);
            int[] truncatePos = AppendTestUtil.randomFilePartition(data.length, 1);
            FSDataOutputStream out = TestHAAppend.createAndHflush((FileSystem)fs, fileToAppend, data, appendPos[0]);
            FSDataOutputStream out4Truncate = TestHAAppend.createAndHflush((FileSystem)fs, fileToTruncate, data, data.length);
            cluster.getNameNode(0).getRpcServer().rollEditLog();
            cluster.getNameNode(1).getNamesystem().getEditLogTailer().doTailEdits();
            out.close();
            out4Truncate.close();
            for (int i = 0; i < 5; ++i) {
                int end = i < 4 ? appendPos[i + 1] : data.length;
                out = fs.append(fileToAppend);
                out.write(data, appendPos[i], end - appendPos[i]);
                out.close();
            }
            boolean isTruncateReady = fs.truncate(fileToTruncate, (long)truncatePos[0]);
            cluster.triggerBlockReports();
            cluster.shutdownNameNode(0);
            cluster.transitionToActive(1);
            int rc = ToolRunner.run((Tool)new DFSck(cluster.getConfiguration(1)), (String[])new String[]{"/", "-files", "-blocks"});
            Assert.assertEquals((long)0L, (long)rc);
            Assert.assertEquals((String)"CorruptBlocks should be empty.", (long)0L, (long)cluster.getNameNode(1).getNamesystem().getCorruptReplicaBlocks());
            AppendTestUtil.checkFullFile((FileSystem)fs, fileToAppend, data.length, data, fileToAppend.toString());
            if (!isTruncateReady) {
                TestFileTruncate.checkBlockRecovery(fileToTruncate, cluster.getFileSystem(1), 300, 200L);
            }
            AppendTestUtil.checkFullFile((FileSystem)fs, fileToTruncate, truncatePos[0], data, fileToTruncate.toString());
        }
        finally {
            if (null != cluster) {
                cluster.shutdown();
            }
            if (null != fs) {
                fs.close();
            }
        }
    }
}

