/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNameNodeReconfigure {
    public static final Log LOG = LogFactory.getLog(TestNameNodeReconfigure.class);
    private MiniDFSCluster cluster;
    private final int customizedBlockInvalidateLimit = 500;

    @Before
    public void setUp() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.block.invalidate.limit", 500);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        this.cluster.waitActive();
    }

    @Test
    public void testReconfigureCallerContextEnabled() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        FSNamesystem nameSystem = nameNode.getNamesystem();
        nameNode.reconfigureProperty("hadoop.caller.context.enabled", "text");
        this.verifyReconfigureCallerContextEnabled(nameNode, nameSystem, false);
        nameNode.reconfigureProperty("hadoop.caller.context.enabled", "true");
        this.verifyReconfigureCallerContextEnabled(nameNode, nameSystem, true);
        nameNode.reconfigureProperty("hadoop.caller.context.enabled", "false");
        this.verifyReconfigureCallerContextEnabled(nameNode, nameSystem, false);
        nameNode.reconfigureProperty("hadoop.caller.context.enabled", null);
        Assert.assertEquals((String)"hadoop.caller.context.enabled has wrong value", (Object)false, (Object)nameSystem.getCallerContextEnabled());
        Assert.assertEquals((String)"hadoop.caller.context.enabled has wrong value", null, (Object)nameNode.getConf().get("hadoop.caller.context.enabled"));
    }

    void verifyReconfigureCallerContextEnabled(NameNode nameNode, FSNamesystem nameSystem, boolean expected) {
        Assert.assertEquals((String)"hadoop.caller.context.enabled has wrong value", (Object)expected, (Object)nameNode.getNamesystem().getCallerContextEnabled());
        Assert.assertEquals((String)"hadoop.caller.context.enabled has wrong value", (Object)expected, (Object)nameNode.getConf().getBoolean("hadoop.caller.context.enabled", false));
    }

    @Test
    public void testReconfigureIPCBackoff() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        NameNodeRpcServer nnrs = (NameNodeRpcServer)nameNode.getRpcServer();
        String ipcClientRPCBackoffEnable = NameNode.buildBackoffEnableKey((int)nnrs.getClientRpcServer().getPort());
        this.verifyReconfigureIPCBackoff(nameNode, nnrs, ipcClientRPCBackoffEnable, false);
        nameNode.reconfigureProperty(ipcClientRPCBackoffEnable, "true");
        this.verifyReconfigureIPCBackoff(nameNode, nnrs, ipcClientRPCBackoffEnable, true);
        nameNode.reconfigureProperty(ipcClientRPCBackoffEnable, "false");
        this.verifyReconfigureIPCBackoff(nameNode, nnrs, ipcClientRPCBackoffEnable, false);
        nameNode.reconfigureProperty(ipcClientRPCBackoffEnable, null);
        Assert.assertEquals((String)(ipcClientRPCBackoffEnable + " has wrong value"), (Object)false, (Object)nnrs.getClientRpcServer().isClientBackoffEnabled());
        Assert.assertEquals((String)(ipcClientRPCBackoffEnable + " has wrong value"), null, (Object)nameNode.getConf().get(ipcClientRPCBackoffEnable));
    }

    void verifyReconfigureIPCBackoff(NameNode nameNode, NameNodeRpcServer nnrs, String property, boolean expected) {
        Assert.assertEquals((String)(property + " has wrong value"), (Object)expected, (Object)nnrs.getClientRpcServer().isClientBackoffEnabled());
        Assert.assertEquals((String)(property + " has wrong value"), (Object)expected, (Object)nameNode.getConf().getBoolean(property, false));
    }

    @Test
    public void testReconfigureHearbeatCheck() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        nameNode.reconfigureProperty("dfs.heartbeat.interval", "6");
        nameNode.reconfigureProperty("dfs.namenode.heartbeat.recheck-interval", "600000");
        try {
            nameNode.reconfigureProperty("dfs.heartbeat.interval", "text");
            Assert.fail((String)"ReconfigurationException expected");
        }
        catch (ReconfigurationException expected) {
            Assert.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException));
        }
        try {
            nameNode.reconfigureProperty("dfs.namenode.heartbeat.recheck-interval", "text");
            Assert.fail((String)"ReconfigurationException expected");
        }
        catch (ReconfigurationException expected) {
            Assert.assertTrue((boolean)(expected.getCause() instanceof NumberFormatException));
        }
        Assert.assertEquals((String)"dfs.heartbeat.interval has wrong value", (long)6L, (long)nameNode.getConf().getLong("dfs.heartbeat.interval", 3L));
        Assert.assertEquals((String)"dfs.heartbeat.interval has wrong value", (long)6L, (long)datanodeManager.getHeartbeatInterval());
        Assert.assertEquals((String)"dfs.namenode.heartbeat.recheck-interval has wrong value", (long)600000L, (long)nameNode.getConf().getInt("dfs.namenode.heartbeat.recheck-interval", 300000));
        Assert.assertEquals((String)"dfs.namenode.heartbeat.recheck-interval has wrong value", (long)600000L, (long)datanodeManager.getHeartbeatRecheckInterval());
        nameNode.reconfigureProperty("dfs.heartbeat.interval", null);
        nameNode.reconfigureProperty("dfs.namenode.heartbeat.recheck-interval", null);
        Assert.assertEquals((String)"dfs.heartbeat.interval has wrong value", null, (Object)nameNode.getConf().get("dfs.heartbeat.interval"));
        Assert.assertEquals((String)"dfs.heartbeat.interval has wrong value", (long)3L, (long)datanodeManager.getHeartbeatInterval());
        Assert.assertEquals((String)"dfs.namenode.heartbeat.recheck-interval has wrong value", null, (Object)nameNode.getConf().get("dfs.namenode.heartbeat.recheck-interval"));
        Assert.assertEquals((String)"dfs.namenode.heartbeat.recheck-interval has wrong value", (long)300000L, (long)datanodeManager.getHeartbeatRecheckInterval());
    }

    @Test
    public void testBlockInvalidateLimitAfterReconfigured() throws ReconfigurationException {
        NameNode nameNode = this.cluster.getNameNode();
        DatanodeManager datanodeManager = nameNode.namesystem.getBlockManager().getDatanodeManager();
        Assert.assertEquals((String)"dfs.block.invalidate.limit is not correctly set", (long)500L, (long)datanodeManager.getBlockInvalidateLimit());
        nameNode.reconfigureProperty("dfs.heartbeat.interval", Integer.toString(6));
        Assert.assertEquals((String)"dfs.block.invalidate.limit is not honored after reconfiguration", (long)500L, (long)datanodeManager.getBlockInvalidateLimit());
        nameNode.reconfigureProperty("dfs.heartbeat.interval", Integer.toString(50));
        Assert.assertEquals((String)"dfs.block.invalidate.limit is not reconfigured correctly", (long)1000L, (long)datanodeManager.getBlockInvalidateLimit());
    }

    @After
    public void shutDown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }
}

