/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodePeerMetrics;
import org.apache.hadoop.metrics2.lib.MetricsTestHelper;
import org.apache.hadoop.metrics2.lib.MutableRollingAverages;
import org.apache.hadoop.util.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestDataNodePeerMetrics {
    @Test(timeout=30000L)
    public void testGetSendPacketDownstreamAvgInfo() throws Exception {
        int windowSize = 5;
        int numWindows = 2;
        int iterations = 3;
        int numOpsPerIteration = 1000;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.datanode.peer.stats.enabled", true);
        DataNodePeerMetrics peerMetrics = DataNodePeerMetrics.create((String)"Sample-DataNode");
        MetricsTestHelper.replaceRollingAveragesScheduler((MutableRollingAverages)peerMetrics.getSendPacketDownstreamRollingAverages(), (int)2, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        long start = Time.monotonicNow();
        for (int i = 1; i <= 3; ++i) {
            String peerAddr = this.genPeerAddress();
            for (int j = 1; j <= 1000; ++j) {
                long latency = ThreadLocalRandom.current().nextLong(1L, 1000L);
                peerMetrics.addSendPacketDownstream(peerAddr, latency);
            }
            long sleep = start + (long)(5000 * i) + 1000L - Time.monotonicNow();
            Thread.sleep(sleep);
            String json = peerMetrics.dumpSendPacketDownstreamAvgInfoAsJson();
            Assert.assertThat((Object)json, (Matcher)CoreMatchers.containsString((String)peerAddr));
        }
    }

    private String genPeerAddress() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        return String.format("[%d.%d.%d.%d:9801]", r.nextInt(1, 256), r.nextInt(1, 256), r.nextInt(1, 256), r.nextInt(1, 256));
    }
}

