/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.protocol.StripedBlockInfo;
import org.apache.hadoop.hdfs.protocol.datatransfer.DataTransferProtoUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.IOStreamPair;
import org.apache.hadoop.hdfs.protocol.datatransfer.Op;
import org.apache.hadoop.hdfs.protocol.datatransfer.Sender;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.util.DataChecksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FileChecksumHelper {
    static final Logger LOG = LoggerFactory.getLogger(FileChecksumHelper.class);

    private FileChecksumHelper() {
    }

    static class StripedFileNonStripedChecksumComputer
    extends FileChecksumComputer {
        private final ErasureCodingPolicy ecPolicy;
        private int bgIdx;

        StripedFileNonStripedChecksumComputer(String src, long length, LocatedBlocks blockLocations, ClientProtocol namenode, DFSClient client, ErasureCodingPolicy ecPolicy) throws IOException {
            super(src, length, blockLocations, namenode, client);
            this.ecPolicy = ecPolicy;
        }

        @Override
        void checksumBlocks() throws IOException {
            int tmpTimeout = 3000 + this.getClient().getConf().getSocketTimeout();
            this.setTimeout(tmpTimeout);
            this.bgIdx = 0;
            while (this.bgIdx < this.getLocatedBlocks().size() && this.getRemaining() >= 0L) {
                LocatedBlock locatedBlock;
                LocatedStripedBlock blockGroup;
                if (this.isRefetchBlocks()) {
                    this.refetchBlocks();
                }
                if (!this.checksumBlockGroup(blockGroup = (LocatedStripedBlock)(locatedBlock = this.getLocatedBlocks().get(this.bgIdx)))) {
                    throw new IOException("Fail to get block MD5 for " + locatedBlock);
                }
                ++this.bgIdx;
            }
        }

        private boolean checksumBlockGroup(LocatedStripedBlock blockGroup) throws IOException {
            ExtendedBlock block = blockGroup.getBlock();
            long requestedNumBytes = block.getNumBytes();
            if (this.getRemaining() < block.getNumBytes()) {
                requestedNumBytes = this.getRemaining();
            }
            this.setRemaining(this.getRemaining() - requestedNumBytes);
            StripedBlockInfo stripedBlockInfo = new StripedBlockInfo(block, blockGroup.getLocations(), blockGroup.getBlockTokens(), blockGroup.getBlockIndices(), this.ecPolicy);
            DatanodeInfo[] datanodes = blockGroup.getLocations();
            boolean done = false;
            for (int j = 0; !done && j < datanodes.length; ++j) {
                try {
                    this.tryDatanode(blockGroup, stripedBlockInfo, datanodes[j], requestedNumBytes);
                    done = true;
                    continue;
                }
                catch (InvalidBlockTokenException ibte) {
                    if (this.bgIdx <= this.getLastRetriedIndex()) continue;
                    LOG.debug("Got access token error in response to OP_BLOCK_CHECKSUM for file {} for block {} from datanode {}. Will retry the block once.", new Object[]{this.getSrc(), block, datanodes[j]});
                    this.setLastRetriedIndex(this.bgIdx);
                    done = true;
                    --this.bgIdx;
                    this.setRefetchBlocks(true);
                    continue;
                }
                catch (IOException ie) {
                    LOG.warn("src={}, datanodes[{}]={}", new Object[]{this.getSrc(), j, datanodes[j], ie});
                }
            }
            return done;
        }

        private void tryDatanode(LocatedStripedBlock blockGroup, StripedBlockInfo stripedBlockInfo, DatanodeInfo datanode, long requestedNumBytes) throws IOException {
            try (IOStreamPair pair = this.getClient().connectToDN(datanode, this.getTimeout(), blockGroup.getBlockToken());){
                DataChecksum.Type ct;
                LOG.debug("write to {}: {}, blockGroup={}", new Object[]{datanode, Op.BLOCK_GROUP_CHECKSUM, blockGroup});
                this.createSender(pair).blockGroupChecksum(stripedBlockInfo, blockGroup.getBlockToken(), requestedNumBytes);
                DataTransferProtos.BlockOpResponseProto reply = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelperClient.vintPrefixed(pair.in));
                String logInfo = "for blockGroup " + blockGroup + " from datanode " + datanode;
                DataTransferProtoUtil.checkBlockOpStatus(reply, logInfo);
                DataTransferProtos.OpBlockChecksumResponseProto checksumData = reply.getChecksumResponse();
                int bpc = checksumData.getBytesPerCrc();
                if (this.bgIdx == 0) {
                    this.setBytesPerCRC(bpc);
                } else if (bpc != this.getBytesPerCRC()) {
                    throw new IOException("Byte-per-checksum not matched: bpc=" + bpc + " but bytesPerCRC=" + this.getBytesPerCRC());
                }
                long cpb = checksumData.getCrcPerBlock();
                if (this.getLocatedBlocks().size() > 1 && this.bgIdx == 0) {
                    this.setCrcPerBlock(cpb);
                }
                MD5Hash md5 = new MD5Hash(checksumData.getMd5().toByteArray());
                md5.write((DataOutput)this.getMd5out());
                if (checksumData.hasCrcType()) {
                    ct = PBHelperClient.convert(checksumData.getCrcType());
                } else {
                    LOG.debug("Retrieving checksum from an earlier-version DataNode: inferring checksum by reading first byte");
                    ct = this.getClient().inferChecksumTypeByReading(blockGroup, datanode);
                }
                if (this.bgIdx == 0) {
                    this.setCrcType(ct);
                } else if (this.getCrcType() != DataChecksum.Type.MIXED && this.getCrcType() != ct) {
                    this.setCrcType(DataChecksum.Type.MIXED);
                }
                if (LOG.isDebugEnabled()) {
                    if (this.bgIdx == 0) {
                        LOG.debug("set bytesPerCRC=" + this.getBytesPerCRC() + ", crcPerBlock=" + this.getCrcPerBlock());
                    }
                    LOG.debug("got reply from " + datanode + ": md5=" + md5);
                }
            }
        }
    }

    static class ReplicatedFileChecksumComputer
    extends FileChecksumComputer {
        private int blockIdx;

        ReplicatedFileChecksumComputer(String src, long length, LocatedBlocks blockLocations, ClientProtocol namenode, DFSClient client) throws IOException {
            super(src, length, blockLocations, namenode, client);
        }

        @Override
        void checksumBlocks() throws IOException {
            this.blockIdx = 0;
            while (this.blockIdx < this.getLocatedBlocks().size() && this.getRemaining() >= 0L) {
                LocatedBlock locatedBlock;
                if (this.isRefetchBlocks()) {
                    this.refetchBlocks();
                }
                if (!this.checksumBlock(locatedBlock = this.getLocatedBlocks().get(this.blockIdx))) {
                    throw new IOException("Fail to get block MD5 for " + locatedBlock);
                }
                ++this.blockIdx;
            }
        }

        private boolean checksumBlock(LocatedBlock locatedBlock) throws IOException {
            ExtendedBlock block = locatedBlock.getBlock();
            if (this.getRemaining() < block.getNumBytes()) {
                block.setNumBytes(this.getRemaining());
            }
            this.setRemaining(this.getRemaining() - block.getNumBytes());
            DatanodeInfo[] datanodes = locatedBlock.getLocations();
            int tmpTimeout = 3000 * datanodes.length + this.getClient().getConf().getSocketTimeout();
            this.setTimeout(tmpTimeout);
            boolean done = false;
            for (int j = 0; !done && j < datanodes.length; ++j) {
                try {
                    this.tryDatanode(locatedBlock, datanodes[j]);
                    done = true;
                    continue;
                }
                catch (InvalidBlockTokenException ibte) {
                    if (this.blockIdx <= this.getLastRetriedIndex()) continue;
                    LOG.debug("Got access token error in response to OP_BLOCK_CHECKSUM for file {} for block {} from datanode {}. Will retry the block once.", new Object[]{this.getSrc(), block, datanodes[j]});
                    this.setLastRetriedIndex(this.blockIdx);
                    done = true;
                    --this.blockIdx;
                    this.setRefetchBlocks(true);
                    continue;
                }
                catch (IOException ie) {
                    LOG.warn("src={}, datanodes[{}]={}", new Object[]{this.getSrc(), j, datanodes[j], ie});
                }
            }
            return done;
        }

        private void tryDatanode(LocatedBlock locatedBlock, DatanodeInfo datanode) throws IOException {
            ExtendedBlock block = locatedBlock.getBlock();
            try (IOStreamPair pair = this.getClient().connectToDN(datanode, this.getTimeout(), locatedBlock.getBlockToken());){
                DataChecksum.Type ct;
                LOG.debug("write to {}: {}, block={}", new Object[]{datanode, Op.BLOCK_CHECKSUM, block});
                this.createSender(pair).blockChecksum(block, locatedBlock.getBlockToken());
                DataTransferProtos.BlockOpResponseProto reply = DataTransferProtos.BlockOpResponseProto.parseFrom(PBHelperClient.vintPrefixed(pair.in));
                String logInfo = "for block " + block + " from datanode " + datanode;
                DataTransferProtoUtil.checkBlockOpStatus(reply, logInfo);
                DataTransferProtos.OpBlockChecksumResponseProto checksumData = reply.getChecksumResponse();
                int bpc = checksumData.getBytesPerCrc();
                if (this.blockIdx == 0) {
                    this.setBytesPerCRC(bpc);
                } else if (bpc != this.getBytesPerCRC()) {
                    throw new IOException("Byte-per-checksum not matched: bpc=" + bpc + " but bytesPerCRC=" + this.getBytesPerCRC());
                }
                long cpb = checksumData.getCrcPerBlock();
                if (this.getLocatedBlocks().size() > 1 && this.blockIdx == 0) {
                    this.setCrcPerBlock(cpb);
                }
                MD5Hash md5 = new MD5Hash(checksumData.getMd5().toByteArray());
                md5.write((DataOutput)this.getMd5out());
                if (checksumData.hasCrcType()) {
                    ct = PBHelperClient.convert(checksumData.getCrcType());
                } else {
                    LOG.debug("Retrieving checksum from an earlier-version DataNode: inferring checksum by reading first byte");
                    ct = this.getClient().inferChecksumTypeByReading(locatedBlock, datanode);
                }
                if (this.blockIdx == 0) {
                    this.setCrcType(ct);
                } else if (this.getCrcType() != DataChecksum.Type.MIXED && this.getCrcType() != ct) {
                    this.setCrcType(DataChecksum.Type.MIXED);
                }
                if (LOG.isDebugEnabled()) {
                    if (this.blockIdx == 0) {
                        LOG.debug("set bytesPerCRC=" + this.getBytesPerCRC() + ", crcPerBlock=" + this.getCrcPerBlock());
                    }
                    LOG.debug("got reply from " + datanode + ": md5=" + md5);
                }
            }
        }
    }

    static abstract class FileChecksumComputer {
        private final String src;
        private final long length;
        private final DFSClient client;
        private final ClientProtocol namenode;
        private final DataOutputBuffer md5out = new DataOutputBuffer();
        private MD5MD5CRC32FileChecksum fileChecksum;
        private LocatedBlocks blockLocations;
        private int timeout;
        private List<LocatedBlock> locatedBlocks;
        private long remaining = 0L;
        private int bytesPerCRC = -1;
        private DataChecksum.Type crcType = DataChecksum.Type.DEFAULT;
        private long crcPerBlock = 0L;
        private boolean isRefetchBlocks = false;
        private int lastRetriedIndex = -1;

        FileChecksumComputer(String src, long length, LocatedBlocks blockLocations, ClientProtocol namenode, DFSClient client) throws IOException {
            this.src = src;
            this.length = length;
            this.blockLocations = blockLocations;
            this.namenode = namenode;
            this.client = client;
            this.remaining = length;
            if (blockLocations != null) {
                if (src.contains("/.snapshot/")) {
                    this.remaining = Math.min(length, blockLocations.getFileLength());
                }
                this.locatedBlocks = blockLocations.getLocatedBlocks();
            }
        }

        String getSrc() {
            return this.src;
        }

        long getLength() {
            return this.length;
        }

        DFSClient getClient() {
            return this.client;
        }

        ClientProtocol getNamenode() {
            return this.namenode;
        }

        DataOutputBuffer getMd5out() {
            return this.md5out;
        }

        MD5MD5CRC32FileChecksum getFileChecksum() {
            return this.fileChecksum;
        }

        LocatedBlocks getBlockLocations() {
            return this.blockLocations;
        }

        void refetchBlocks() throws IOException {
            this.blockLocations = this.getClient().getBlockLocations(this.getSrc(), this.getLength());
            this.locatedBlocks = this.getBlockLocations().getLocatedBlocks();
            this.isRefetchBlocks = false;
        }

        int getTimeout() {
            return this.timeout;
        }

        void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        List<LocatedBlock> getLocatedBlocks() {
            return this.locatedBlocks;
        }

        long getRemaining() {
            return this.remaining;
        }

        void setRemaining(long remaining) {
            this.remaining = remaining;
        }

        int getBytesPerCRC() {
            return this.bytesPerCRC;
        }

        void setBytesPerCRC(int bytesPerCRC) {
            this.bytesPerCRC = bytesPerCRC;
        }

        DataChecksum.Type getCrcType() {
            return this.crcType;
        }

        void setCrcType(DataChecksum.Type crcType) {
            this.crcType = crcType;
        }

        long getCrcPerBlock() {
            return this.crcPerBlock;
        }

        void setCrcPerBlock(long crcPerBlock) {
            this.crcPerBlock = crcPerBlock;
        }

        boolean isRefetchBlocks() {
            return this.isRefetchBlocks;
        }

        void setRefetchBlocks(boolean refetchBlocks) {
            this.isRefetchBlocks = refetchBlocks;
        }

        int getLastRetriedIndex() {
            return this.lastRetriedIndex;
        }

        void setLastRetriedIndex(int lastRetriedIndex) {
            this.lastRetriedIndex = lastRetriedIndex;
        }

        void compute() throws IOException {
            if (this.locatedBlocks == null || this.locatedBlocks.isEmpty()) {
                int lenOfZeroBytes = 32;
                byte[] emptyBlockMd5 = new byte[32];
                MD5Hash fileMD5 = MD5Hash.digest((byte[])emptyBlockMd5);
                this.fileChecksum = new MD5MD5CRC32GzipFileChecksum(0, 0L, fileMD5);
            } else {
                this.checksumBlocks();
                this.fileChecksum = this.makeFinalResult();
            }
        }

        abstract void checksumBlocks() throws IOException;

        MD5MD5CRC32FileChecksum makeFinalResult() {
            MD5Hash fileMD5 = MD5Hash.digest((byte[])this.md5out.getData());
            switch (this.crcType) {
                case CRC32: {
                    return new MD5MD5CRC32GzipFileChecksum(this.bytesPerCRC, this.crcPerBlock, fileMD5);
                }
                case CRC32C: {
                    return new MD5MD5CRC32CastagnoliFileChecksum(this.bytesPerCRC, this.crcPerBlock, fileMD5);
                }
            }
            return null;
        }

        Sender createSender(IOStreamPair pair) {
            DataOutputStream out = (DataOutputStream)pair.out;
            return new Sender(out);
        }

        void close(IOStreamPair pair) {
            if (pair != null) {
                IOUtils.closeStream((Closeable)pair.in);
                IOUtils.closeStream((Closeable)pair.out);
            }
        }
    }
}

