/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.delegation;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;

@InterfaceAudience.Private
public class DelegationTokenSelector
extends AbstractDelegationTokenSelector<DelegationTokenIdentifier> {
    public static final String SERVICE_NAME_KEY = "hdfs.service.host_";

    public Token<DelegationTokenIdentifier> selectToken(URI nnUri, Collection<Token<?>> tokens, Configuration conf) {
        Text serviceName = SecurityUtil.buildTokenService((URI)nnUri);
        String nnServiceName = conf.get(SERVICE_NAME_KEY + serviceName);
        int nnRpcPort = 9820;
        if (nnServiceName != null) {
            nnRpcPort = NetUtils.createSocketAddr((String)nnServiceName, (int)nnRpcPort).getPort();
        }
        serviceName = SecurityUtil.buildTokenService((InetSocketAddress)NetUtils.createSocketAddrForHost((String)nnUri.getHost(), (int)nnRpcPort));
        return this.selectToken(serviceName, tokens);
    }

    public DelegationTokenSelector() {
        super(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
    }
}

