/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.KeyProviderCache;
import org.apache.hadoop.hdfs.PeerCache;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.shortcircuit.DomainSocketFactory;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import org.apache.hadoop.hdfs.util.ByteArrayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ClientContext {
    private static final Logger LOG = LoggerFactory.getLogger(ClientContext.class);
    private static final HashMap<String, ClientContext> CACHES = new HashMap();
    private final String name;
    private final String confString;
    private final ShortCircuitCache shortCircuitCache;
    private final PeerCache peerCache;
    private final DomainSocketFactory domainSocketFactory;
    private final KeyProviderCache keyProviderCache;
    private final boolean useLegacyBlockReaderLocal;
    private volatile boolean disableLegacyBlockReaderLocal = false;
    private final ByteArrayManager byteArrayManager;
    private boolean printedConfWarning = false;

    private ClientContext(String name, DfsClientConf conf) {
        DfsClientConf.ShortCircuitConf scConf = conf.getShortCircuitConf();
        this.name = name;
        this.confString = scConf.confAsString();
        this.shortCircuitCache = ShortCircuitCache.fromConf(scConf);
        this.peerCache = new PeerCache(scConf.getSocketCacheCapacity(), scConf.getSocketCacheExpiry());
        this.keyProviderCache = new KeyProviderCache(scConf.getKeyProviderCacheExpiryMs());
        this.useLegacyBlockReaderLocal = scConf.isUseLegacyBlockReaderLocal();
        this.domainSocketFactory = new DomainSocketFactory(scConf);
        this.byteArrayManager = ByteArrayManager.newInstance(conf.getWriteByteArrayManagerConf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientContext get(String name, DfsClientConf conf) {
        Class<ClientContext> clazz = ClientContext.class;
        synchronized (ClientContext.class) {
            ClientContext context = CACHES.get(name);
            if (context == null) {
                context = new ClientContext(name, conf);
                CACHES.put(name, context);
            } else {
                context.printConfWarningIfNeeded(conf);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return context;
        }
    }

    @VisibleForTesting
    public static ClientContext getFromConf(Configuration conf) {
        return ClientContext.get(conf.get("dfs.client.context", "default"), new DfsClientConf(conf));
    }

    private void printConfWarningIfNeeded(DfsClientConf conf) {
        String requested;
        String existing = this.getConfString();
        if (!existing.equals(requested = conf.getShortCircuitConf().confAsString()) && !this.printedConfWarning) {
            this.printedConfWarning = true;
            LOG.warn("Existing client context '" + this.name + "' does not match requested configuration.  Existing: " + existing + ", Requested: " + requested);
        }
    }

    public String getConfString() {
        return this.confString;
    }

    public ShortCircuitCache getShortCircuitCache() {
        return this.shortCircuitCache;
    }

    public PeerCache getPeerCache() {
        return this.peerCache;
    }

    public KeyProviderCache getKeyProviderCache() {
        return this.keyProviderCache;
    }

    public boolean getUseLegacyBlockReaderLocal() {
        return this.useLegacyBlockReaderLocal;
    }

    public boolean getDisableLegacyBlockReaderLocal() {
        return this.disableLegacyBlockReaderLocal;
    }

    public void setDisableLegacyBlockReaderLocal() {
        this.disableLegacyBlockReaderLocal = true;
    }

    public DomainSocketFactory getDomainSocketFactory() {
        return this.domainSocketFactory;
    }

    public ByteArrayManager getByteArrayManager() {
        return this.byteArrayManager;
    }
}

