/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.primitives.SignedBytes;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HAUtilClient;
import org.apache.hadoop.hdfs.net.BasicInetPeer;
import org.apache.hadoop.hdfs.net.NioInetPeer;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.util.IOUtilsClient;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.KMSUtil;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFSUtilClient {
    public static final byte[] EMPTY_BYTES = new byte[0];
    private static final Logger LOG = LoggerFactory.getLogger(DFSUtilClient.class);
    private static final String UTF8_CSN = StandardCharsets.UTF_8.name();
    private static final Map<String, Boolean> localAddrMap = Collections.synchronizedMap(new HashMap());
    private static String keyProviderUriKeyName = "hadoop.security.key.provider.path";

    public static byte[] string2Bytes(String str) {
        try {
            return str.getBytes(UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 decoding is not supported", e);
        }
    }

    public static String bytes2String(byte[] bytes) {
        return DFSUtilClient.bytes2String(bytes, 0, bytes.length);
    }

    public static float getPercentUsed(long used, long capacity) {
        return capacity <= 0L ? 100.0f : (float)used * 100.0f / (float)capacity;
    }

    public static float getPercentRemaining(long remaining, long capacity) {
        return capacity <= 0L ? 0.0f : (float)remaining * 100.0f / (float)capacity;
    }

    public static String percent2String(double percentage) {
        return StringUtils.format((String)"%.2f%%", (Object[])new Object[]{percentage});
    }

    public static Collection<String> getNameServiceIds(Configuration conf) {
        return conf.getTrimmedStringCollection("dfs.nameservices");
    }

    public static Collection<String> getNameNodeIds(Configuration conf, String nsId) {
        String key = DFSUtilClient.addSuffix("dfs.ha.namenodes", nsId);
        return conf.getTrimmedStringCollection(key);
    }

    static String addSuffix(String key, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return key;
        }
        assert (!suffix.startsWith(".")) : "suffix '" + suffix + "' should not already have '.' prepended.";
        return key + "." + suffix;
    }

    public static Map<String, Map<String, InetSocketAddress>> getHaNnRpcAddresses(Configuration conf) {
        return DFSUtilClient.getAddresses(conf, null, "dfs.namenode.rpc-address");
    }

    public static Map<String, Map<String, InetSocketAddress>> getHaNnWebHdfsAddresses(Configuration conf, String scheme) {
        if ("webhdfs".equals(scheme)) {
            return DFSUtilClient.getAddresses(conf, null, "dfs.namenode.http-address");
        }
        if ("swebhdfs".equals(scheme)) {
            return DFSUtilClient.getAddresses(conf, null, "dfs.namenode.https-address");
        }
        throw new IllegalArgumentException("Unsupported scheme: " + scheme);
    }

    public static BlockLocation[] locatedBlocks2Locations(LocatedBlocks blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        return DFSUtilClient.locatedBlocks2Locations(blocks.getLocatedBlocks());
    }

    public static BlockLocation[] locatedBlocks2Locations(List<LocatedBlock> blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        int nrBlocks = blocks.size();
        BlockLocation[] blkLocations = new BlockLocation[nrBlocks];
        if (nrBlocks == 0) {
            return blkLocations;
        }
        int idx = 0;
        for (LocatedBlock blk : blocks) {
            assert (idx < nrBlocks) : "Incorrect index";
            DatanodeInfo[] locations = blk.getLocations();
            String[] hosts = new String[locations.length];
            String[] xferAddrs = new String[locations.length];
            String[] racks = new String[locations.length];
            for (int hCnt = 0; hCnt < locations.length; ++hCnt) {
                hosts[hCnt] = locations[hCnt].getHostName();
                xferAddrs[hCnt] = locations[hCnt].getXferAddr();
                NodeBase node = new NodeBase(xferAddrs[hCnt], locations[hCnt].getNetworkLocation());
                racks[hCnt] = node.toString();
            }
            DatanodeInfo[] cachedLocations = blk.getCachedLocations();
            String[] cachedHosts = new String[cachedLocations.length];
            for (int i = 0; i < cachedLocations.length; ++i) {
                cachedHosts[i] = cachedLocations[i].getHostName();
            }
            blkLocations[idx] = new BlockLocation(xferAddrs, hosts, cachedHosts, racks, blk.getStorageIDs(), blk.getStorageTypes(), blk.getStartOffset(), blk.getBlockSize(), blk.isCorrupt());
            ++idx;
        }
        return blkLocations;
    }

    public static int compareBytes(byte[] left, byte[] right) {
        if (left == null) {
            left = EMPTY_BYTES;
        }
        if (right == null) {
            right = EMPTY_BYTES;
        }
        return SignedBytes.lexicographicalComparator().compare(left, right);
    }

    public static byte[] byteArray2bytes(byte[][] pathComponents) {
        if (pathComponents.length == 0) {
            return EMPTY_BYTES;
        }
        if (pathComponents.length == 1 && (pathComponents[0] == null || pathComponents[0].length == 0)) {
            return new byte[]{47};
        }
        int length = 0;
        for (int i = 0; i < pathComponents.length; ++i) {
            length += pathComponents[i].length;
            if (i >= pathComponents.length - 1) continue;
            ++length;
        }
        byte[] path = new byte[length];
        int index = 0;
        for (int i = 0; i < pathComponents.length; ++i) {
            System.arraycopy(pathComponents[i], 0, path, index, pathComponents[i].length);
            index += pathComponents[i].length;
            if (i >= pathComponents.length - 1) continue;
            path[index] = 47;
            ++index;
        }
        return path;
    }

    static String bytes2String(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, UTF8_CSN);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("UTF8 encoding is not supported", e);
        }
    }

    static Collection<String> emptyAsSingletonNull(Collection<String> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.singletonList(null);
        }
        return coll;
    }

    static String concatSuffixes(String ... suffixes) {
        if (suffixes == null) {
            return null;
        }
        return Joiner.on((String)".").skipNulls().join((Object[])suffixes);
    }

    static Map<String, Map<String, InetSocketAddress>> getAddresses(Configuration conf, String defaultAddress, String ... keys) {
        Collection<String> nameserviceIds = DFSUtilClient.getNameServiceIds(conf);
        return DFSUtilClient.getAddressesForNsIds(conf, nameserviceIds, defaultAddress, keys);
    }

    static Map<String, Map<String, InetSocketAddress>> getAddressesForNsIds(Configuration conf, Collection<String> nsIds, String defaultAddress, String ... keys) {
        LinkedHashMap ret = Maps.newLinkedHashMap();
        for (String nsId : DFSUtilClient.emptyAsSingletonNull(nsIds)) {
            Map<String, InetSocketAddress> isas = DFSUtilClient.getAddressesForNameserviceId(conf, nsId, defaultAddress, keys);
            if (isas.isEmpty()) continue;
            ret.put(nsId, isas);
        }
        return ret;
    }

    static Map<String, InetSocketAddress> getAddressesForNameserviceId(Configuration conf, String nsId, String defaultValue, String ... keys) {
        Collection<String> nnIds = DFSUtilClient.getNameNodeIds(conf, nsId);
        HashMap ret = Maps.newHashMap();
        for (String nnId : DFSUtilClient.emptyAsSingletonNull(nnIds)) {
            String suffix = DFSUtilClient.concatSuffixes(nsId, nnId);
            String address = DFSUtilClient.getConfValue(defaultValue, suffix, conf, keys);
            if (address == null) continue;
            InetSocketAddress isa = NetUtils.createSocketAddr((String)address);
            if (isa.isUnresolved()) {
                LOG.warn("Namenode for {} remains unresolved for ID {}. Check your hdfs-site.xml file to ensure namenodes are configured properly.", (Object)nsId, (Object)nnId);
            }
            ret.put(nnId, isa);
        }
        return ret;
    }

    private static String getConfValue(String defaultValue, String keySuffix, Configuration conf, String ... keys) {
        String value = null;
        for (String key : keys) {
            value = conf.get(key = DFSUtilClient.addSuffix(key, keySuffix));
            if (value != null) break;
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        String[] components = StringUtils.split((String)src, (char)'/');
        for (int i = 0; i < components.length; ++i) {
            String element = components[i];
            if (element.equals(".") || element.contains(":") || element.contains("/")) {
                return false;
            }
            if (element.equals("..")) {
                if (components.length > 4 && components[1].equals(".reserved") && components[2].equals(".inodes")) continue;
                return false;
            }
            if (!element.isEmpty() || i == components.length - 1 || i == 0) continue;
            return false;
        }
        return true;
    }

    public static String durationToString(long durationMs) {
        boolean negative = false;
        if (durationMs < 0L) {
            negative = true;
            durationMs = -durationMs;
        }
        long durationSec = durationMs / 1000L;
        int secondsPerMinute = 60;
        int secondsPerHour = 3600;
        int secondsPerDay = 86400;
        long days = durationSec / 86400L;
        long hours = (durationSec -= days * 86400L) / 3600L;
        long minutes = (durationSec -= hours * 3600L) / 60L;
        long seconds = durationSec -= minutes * 60L;
        long milliseconds = durationMs % 1000L;
        String format = "%03d:%02d:%02d:%02d.%03d";
        if (negative) {
            format = "-" + format;
        }
        return String.format(format, days, hours, minutes, seconds, milliseconds);
    }

    public static String dateToIso8601String(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.ENGLISH);
        return df.format(date);
    }

    public static boolean isLocalAddress(InetSocketAddress targetAddr) {
        InetAddress addr = targetAddr.getAddress();
        Boolean cached = localAddrMap.get(addr.getHostAddress());
        if (cached != null) {
            LOG.trace("Address {} is {} local", (Object)targetAddr, (Object)(cached != false ? "" : "not"));
            return cached;
        }
        boolean local = NetUtils.isLocalAddress((InetAddress)addr);
        LOG.trace("Address {} is {} local", (Object)targetAddr, (Object)(local ? "" : "not"));
        localAddrMap.put(addr.getHostAddress(), local);
        return local;
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname, LocatedBlock locatedBlock) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(datanodeid, conf, socketTimeout, connectToDnViaHostname, locatedBlock);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(datanodeid, conf, socketTimeout, connectToDnViaHostname);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(addr, ticket, conf, factory);
    }

    public static void setKeyProviderUriKeyName(String keyName) {
        keyProviderUriKeyName = keyName;
    }

    public static KeyProvider createKeyProvider(Configuration conf) throws IOException {
        return KMSUtil.createKeyProvider((Configuration)conf, (String)keyProviderUriKeyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Peer peerFromSocket(Socket socket) throws IOException {
        boolean success = false;
        try {
            socket.setTcpNoDelay(true);
            SocketChannel channel = socket.getChannel();
            Peer peer = channel == null ? new BasicInetPeer(socket) : new NioInetPeer(socket);
            success = true;
            Peer peer2 = peer;
            return peer2;
        }
        finally {
            if (!success) {
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Peer peerFromSocketAndKey(SaslDataTransferClient saslClient, Socket s, DataEncryptionKeyFactory keyFactory, Token<BlockTokenIdentifier> blockToken, DatanodeID datanodeId, int socketTimeoutMs) throws IOException {
        Peer peer;
        block3: {
            Peer peer2 = null;
            boolean success = false;
            try {
                peer2 = DFSUtilClient.peerFromSocket(s);
                peer2.setReadTimeout(socketTimeoutMs);
                peer2.setWriteTimeout(socketTimeoutMs);
                peer2 = saslClient.peerSend(peer2, keyFactory, blockToken, datanodeId);
                success = true;
                peer = peer2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtilsClient.cleanup(null, peer2);
                }
                throw throwable;
            }
            IOUtilsClient.cleanup(null, peer2);
        }
        return peer;
    }

    public static int getIoFileBufferSize(Configuration conf) {
        return conf.getInt("io.file.buffer.size", 4096);
    }

    public static int getSmallBufferSize(Configuration conf) {
        return Math.min(DFSUtilClient.getIoFileBufferSize(conf) / 2, 512);
    }

    public static boolean isHDFSEncryptionEnabled(Configuration conf) {
        return !conf.getTrimmed("hadoop.security.key.provider.path", "").isEmpty();
    }

    public static InetSocketAddress getNNAddress(String address) {
        return NetUtils.createSocketAddr((String)address, (int)8020);
    }

    public static InetSocketAddress getNNAddress(Configuration conf) {
        URI filesystemURI = FileSystem.getDefaultUri((Configuration)conf);
        return DFSUtilClient.getNNAddressCheckLogical(conf, filesystemURI);
    }

    public static InetSocketAddress getNNAddress(URI filesystemURI) {
        String authority = filesystemURI.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException(String.format("Invalid URI for NameNode address (check %s): %s has no authority.", "fs.defaultFS", filesystemURI.toString()));
        }
        if (!"hdfs".equalsIgnoreCase(filesystemURI.getScheme())) {
            throw new IllegalArgumentException(String.format("Invalid URI for NameNode address (check %s): %s is not of scheme '%s'.", "fs.defaultFS", filesystemURI.toString(), "hdfs"));
        }
        return DFSUtilClient.getNNAddress(authority);
    }

    public static InetSocketAddress getNNAddressCheckLogical(Configuration conf, URI filesystemURI) {
        InetSocketAddress retAddr = HAUtilClient.isLogicalUri(conf, filesystemURI) ? InetSocketAddress.createUnresolved(filesystemURI.getAuthority(), 8020) : DFSUtilClient.getNNAddress(filesystemURI);
        return retAddr;
    }

    public static URI getNNUri(InetSocketAddress namenode) {
        int port = namenode.getPort();
        String portString = port == 8020 ? "" : ":" + port;
        return URI.create("hdfs://" + namenode.getHostName() + portString);
    }

    public static URI createUri(String scheme, InetSocketAddress address) {
        try {
            return new URI(scheme, null, address.getHostName(), address.getPort(), null, null, null);
        }
        catch (URISyntaxException ue) {
            throw new IllegalArgumentException(ue);
        }
    }

    public static InterruptedIOException toInterruptedIOException(String message, InterruptedException e) {
        InterruptedIOException iioe = new InterruptedIOException(message);
        iioe.initCause(e);
        return iioe;
    }
}

