/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Random;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.util.Progressable;

class PseudoLocalFs
extends FileSystem {
    Path home;
    private static final long TIME = System.currentTimeMillis();
    private static final String HOME_DIR = "/";
    private static final long BLOCK_SIZE = 0x400000L;
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    static final URI NAME = URI.create("pseudo:///");

    PseudoLocalFs() {
        this(new Path(HOME_DIR));
    }

    PseudoLocalFs(Path home) {
        this.home = home;
    }

    public URI getUri() {
        return NAME;
    }

    public Path getHomeDirectory() {
        return this.home;
    }

    public Path getWorkingDirectory() {
        return this.getHomeDirectory();
    }

    static Path generateFilePath(String fileId, long fileSize) {
        return new Path(fileId + "." + fileSize);
    }

    public FSDataOutputStream create(Path path) throws IOException {
        try {
            this.validateFileNameFormat(path);
        }
        catch (FileNotFoundException e) {
            throw new IOException("File creation failed for " + path);
        }
        return null;
    }

    long validateFileNameFormat(Path path) throws FileNotFoundException {
        path = path.makeQualified((FileSystem)this);
        boolean valid = true;
        long fileSize = 0L;
        if (!path.toUri().getScheme().equals(this.getUri().getScheme())) {
            valid = false;
        } else {
            String[] parts = path.toUri().getPath().split("\\.");
            try {
                fileSize = Long.valueOf(parts[parts.length - 1]);
                valid = fileSize >= 0L;
            }
            catch (NumberFormatException e) {
                valid = false;
            }
        }
        if (!valid) {
            throw new FileNotFoundException("File " + path + " does not exist in pseudo local file system");
        }
        return fileSize;
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        long fileSize = this.validateFileNameFormat(path);
        RandomInputStream in = new RandomInputStream(fileSize, bufferSize);
        return new FSDataInputStream((InputStream)in);
    }

    public FSDataInputStream open(Path path) throws IOException {
        return this.open(path, 0x100000);
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        long fileSize = this.validateFileNameFormat(path);
        return new FileStatus(fileSize, false, 1, 0x400000L, TIME, path);
    }

    public boolean exists(Path path) {
        try {
            this.validateFileNameFormat(path);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        return true;
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(path);
    }

    public FileStatus[] listStatus(Path path) throws FileNotFoundException, IOException {
        return new FileStatus[]{this.getFileStatus(path)};
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Append is not supported in pseudo local file system.");
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new UnsupportedOperationException("Mkdirs is not supported in pseudo local file system.");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new UnsupportedOperationException("Rename is not supported in pseudo local file system.");
    }

    public boolean delete(Path path, boolean recursive) {
        throw new UnsupportedOperationException("File deletion is not supported in pseudo local file system.");
    }

    public void setWorkingDirectory(Path newDir) {
        throw new UnsupportedOperationException("SetWorkingDirectory is not supported in pseudo local file system.");
    }

    static class RandomInputStream
    extends InputStream
    implements Seekable,
    PositionedReadable {
        private final Random r = new Random();
        private BytesWritable val = null;
        private int positionInVal = 0;
        private long totalSize = 0L;
        private long curPos = 0L;

        RandomInputStream(long size, int bufferSize) {
            this.totalSize = size;
            if (bufferSize <= 0) {
                bufferSize = 0x100000;
            }
            this.val = new BytesWritable(new byte[bufferSize]);
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.curPos < this.totalSize) {
                if (this.positionInVal < this.val.getLength()) {
                    b[0] = this.val.getBytes()[this.positionInVal++];
                    ++this.curPos;
                } else {
                    int num = this.read(b);
                    if (num < 0) {
                        return num;
                    }
                }
            } else {
                return -1;
            }
            return b[0];
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return this.read(bytes, 0, bytes.length);
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (this.curPos == this.totalSize) {
                return -1;
            }
            int numBytes = len;
            if ((long)numBytes > this.totalSize - this.curPos) {
                numBytes = (int)(this.totalSize - this.curPos);
            }
            if (numBytes > this.val.getLength() - this.positionInVal) {
                this.r.nextBytes(this.val.getBytes());
                this.positionInVal = 0;
            }
            System.arraycopy(this.val.getBytes(), this.positionInVal, bytes, off, numBytes);
            this.curPos += (long)numBytes;
            this.positionInVal += numBytes;
            return numBytes;
        }

        @Override
        public int available() {
            return this.val.getLength() - this.positionInVal;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getPos() throws IOException {
            return this.curPos;
        }

        public void seek(long pos) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

