/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.mapred.gridmix.RandomTextDataGenerator;
import org.junit.Assert;
import org.junit.Test;

public class TestRandomTextDataGenerator {
    @Test
    public void testRandomTextDataGenerator() {
        RandomTextDataGenerator rtdg = new RandomTextDataGenerator(10, Long.valueOf(0L), 5);
        List words = rtdg.getRandomWords();
        Assert.assertEquals((String)"List size mismatch", (long)10L, (long)words.size());
        HashSet wordsSet = new HashSet(words);
        Assert.assertEquals((String)"List size mismatch due to duplicates", (long)10L, (long)wordsSet.size());
        for (String word : wordsSet) {
            Assert.assertEquals((String)"Word size mismatch", (long)5L, (long)word.length());
        }
    }

    @Test
    public void testRandomTextDataGeneratorRepeatability() {
        RandomTextDataGenerator rtdg1 = new RandomTextDataGenerator(10, Long.valueOf(0L), 5);
        List words1 = rtdg1.getRandomWords();
        RandomTextDataGenerator rtdg2 = new RandomTextDataGenerator(10, Long.valueOf(0L), 5);
        List words2 = rtdg2.getRandomWords();
        Assert.assertTrue((String)"List mismatch", (boolean)words1.equals(words2));
    }

    @Test
    public void testRandomTextDataGeneratorUniqueness() {
        RandomTextDataGenerator rtdg1 = new RandomTextDataGenerator(10, Long.valueOf(1L), 5);
        HashSet words1 = new HashSet(rtdg1.getRandomWords());
        RandomTextDataGenerator rtdg2 = new RandomTextDataGenerator(10, Long.valueOf(0L), 5);
        HashSet words2 = new HashSet(rtdg2.getRandomWords());
        Assert.assertFalse((String)"List size mismatch across lists", (boolean)words1.equals(words2));
    }
}

