/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapred.gridmix.FilePool;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapred.gridmix.InputStriper;
import org.apache.hadoop.mapred.gridmix.LoadSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.ResourceUsageMetrics;
import org.apache.hadoop.tools.rumen.TaskInfo;

/*
 * Exception performing whole class analysis ignored.
 */
class LoadJob
extends GridmixJob {
    public static final Log LOG = LogFactory.getLog(LoadJob.class);

    public LoadJob(Configuration conf, long submissionMillis, JobStory jobdesc, Path outRoot, UserGroupInformation ugi, int seq) throws IOException {
        super(conf, submissionMillis, jobdesc, outRoot, ugi, seq);
    }

    public Job call() throws IOException, InterruptedException, ClassNotFoundException {
        this.ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        return this.job;
    }

    protected boolean canEmulateCompression() {
        return true;
    }

    void buildSplits(FilePool inputDir) throws IOException {
        long mapInputBytesTotal = 0L;
        long mapOutputBytesTotal = 0L;
        long mapOutputRecordsTotal = 0L;
        JobStory jobdesc = this.getJobDesc();
        if (null == jobdesc) {
            return;
        }
        int maps = jobdesc.getNumberMaps();
        int reds = jobdesc.getNumberReduces();
        for (int i = 0; i < maps; ++i) {
            TaskInfo info = jobdesc.getTaskInfo(TaskType.MAP, i);
            mapInputBytesTotal += info.getInputBytes();
            mapOutputBytesTotal += info.getOutputBytes();
            mapOutputRecordsTotal += (long)info.getOutputRecords();
        }
        double[] reduceRecordRatio = new double[reds];
        double[] reduceByteRatio = new double[reds];
        for (int i = 0; i < reds; ++i) {
            TaskInfo info = jobdesc.getTaskInfo(TaskType.REDUCE, i);
            reduceByteRatio[i] = (double)info.getInputBytes() / (1.0 * (double)mapOutputBytesTotal);
            reduceRecordRatio[i] = (double)info.getInputRecords() / (1.0 * (double)mapOutputRecordsTotal);
        }
        InputStriper striper = new InputStriper(inputDir, mapInputBytesTotal);
        ArrayList<LoadSplit> splits = new ArrayList<LoadSplit>();
        for (int i = 0; i < maps; ++i) {
            int nSpec = reds / maps + (reds % maps > i ? 1 : 0);
            long[] specBytes = new long[nSpec];
            long[] specRecords = new long[nSpec];
            ResourceUsageMetrics[] metrics = new ResourceUsageMetrics[nSpec];
            for (int j = 0; j < nSpec; ++j) {
                TaskInfo info = jobdesc.getTaskInfo(TaskType.REDUCE, i + j * maps);
                specBytes[j] = info.getOutputBytes();
                specRecords[j] = info.getOutputRecords();
                metrics[j] = info.getResourceUsageMetrics();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)String.format("SPEC(%d) %d -> %d %d %d %d %d %d %d", this.id(), i, i + j * maps, info.getOutputRecords(), info.getOutputBytes(), info.getResourceUsageMetrics().getCumulativeCpuUsage(), info.getResourceUsageMetrics().getPhysicalMemoryUsage(), info.getResourceUsageMetrics().getVirtualMemoryUsage(), info.getResourceUsageMetrics().getHeapUsage()));
            }
            TaskInfo info = jobdesc.getTaskInfo(TaskType.MAP, i);
            long possiblyCompressedInputBytes = info.getInputBytes();
            Configuration conf = this.job.getConfiguration();
            long uncompressedInputBytes = CompressionEmulationUtil.getUncompressedInputBytes((long)possiblyCompressedInputBytes, (Configuration)conf);
            splits.add(new LoadSplit(striper.splitFor(inputDir, uncompressedInputBytes, 3), maps, i, uncompressedInputBytes, (long)info.getInputRecords(), info.getOutputBytes(), (long)info.getOutputRecords(), reduceByteRatio, reduceRecordRatio, specBytes, specRecords, info.getResourceUsageMetrics(), metrics));
        }
        LoadJob.pushDescription((int)this.id(), splits);
    }
}

