/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class RandomAlgorithms {
    public static int[] select(int m, int n, Random rand) {
        if (m >= n) {
            int[] ret = new int[n];
            for (int i = 0; i < n; ++i) {
                ret[i] = i;
            }
            return ret;
        }
        Selector selector = new Selector(n, (float)m / (float)n, rand);
        int[] selected = new int[m];
        for (int i = 0; i < m; ++i) {
            selected[i] = selector.next();
        }
        return selected;
    }

    public static class Selector {
        private IndexMapper mapping;
        private int n;
        private Random rand;

        public Selector(int n, double selPcnt, Random rand) {
            if (n <= 0) {
                throw new IllegalArgumentException("n should be positive");
            }
            boolean sparse = n > 200 && selPcnt < 0.1;
            this.n = n;
            this.mapping = sparse ? new SparseIndexMapper(n) : new DenseIndexMapper(n);
            this.rand = rand;
        }

        public int next() {
            switch (this.n) {
                case 0: {
                    return -1;
                }
                case 1: {
                    int index = this.mapping.get(0);
                    --this.n;
                    return index;
                }
            }
            int pos = this.rand.nextInt(this.n);
            int index = this.mapping.get(pos);
            this.mapping.swap(pos, --this.n);
            return index;
        }

        public int getPoolSize() {
            return this.n;
        }

        public void reset() {
            this.mapping.reset();
            this.n = this.mapping.getSize();
        }
    }

    private static class DenseIndexMapper
    implements IndexMapper {
        int[] mapping;

        DenseIndexMapper(int size) {
            this.mapping = new int[size];
            for (int i = 0; i < size; ++i) {
                this.mapping[i] = i;
            }
        }

        @Override
        public int get(int pos) {
            if (pos < 0 || pos >= this.mapping.length) {
                throw new IndexOutOfBoundsException();
            }
            return this.mapping[pos];
        }

        @Override
        public void swap(int a, int b) {
            int valB;
            if (a == b) {
                return;
            }
            int valA = this.get(a);
            this.mapping[a] = valB = this.get(b);
            this.mapping[b] = valA;
        }

        @Override
        public int getSize() {
            return this.mapping.length;
        }

        @Override
        public void reset() {
        }
    }

    private static class SparseIndexMapper
    implements IndexMapper {
        Map<Integer, Integer> mapping = new HashMap<Integer, Integer>();
        int size;

        SparseIndexMapper(int size) {
            this.size = size;
        }

        @Override
        public int get(int pos) {
            Integer mapped = this.mapping.get(pos);
            if (mapped == null) {
                return pos;
            }
            return mapped;
        }

        @Override
        public void swap(int a, int b) {
            if (a == b) {
                return;
            }
            int valA = this.get(a);
            int valB = this.get(b);
            if (b == valA) {
                this.mapping.remove(b);
            } else {
                this.mapping.put(b, valA);
            }
            if (a == valB) {
                this.mapping.remove(a);
            } else {
                this.mapping.put(a, valB);
            }
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void reset() {
            this.mapping.clear();
        }
    }

    private static interface IndexMapper {
        public int get(int var1);

        public void swap(int var1, int var2);

        public int getSize();

        public void reset();
    }
}

