/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.gridmix.Gridmix;
import org.apache.hadoop.mapred.gridmix.JobMonitor;
import org.apache.hadoop.mapred.gridmix.Statistics;
import org.apache.hadoop.mapreduce.Job;

class JobMonitor
implements Gridmix.Component<Statistics.JobStats> {
    public static final Log LOG = LogFactory.getLog(JobMonitor.class);
    private final Queue<Statistics.JobStats> mJobs;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private int numPollingThreads;
    private final BlockingQueue<Statistics.JobStats> runningJobs;
    private final long pollDelayMillis;
    private Statistics statistics;
    private boolean graceful = false;
    private boolean shutdown = false;

    public JobMonitor(int pollDelay, TimeUnit unit, Statistics statistics, int numPollingThreads) {
        this.numPollingThreads = numPollingThreads;
        this.runningJobs = new LinkedBlockingQueue();
        this.mJobs = new LinkedList();
        this.pollDelayMillis = TimeUnit.MILLISECONDS.convert(pollDelay, unit);
        this.statistics = statistics;
    }

    public void add(Statistics.JobStats job) throws InterruptedException {
        this.runningJobs.put(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submissionFailed(Statistics.JobStats job) {
        String jobID = job.getJob().getConfiguration().get("gridmix.job.original-job-id");
        LOG.info((Object)("Job submission failed notification for job " + jobID));
        Statistics statistics = this.statistics;
        synchronized (statistics) {
            this.statistics.add(job);
        }
    }

    protected void onSuccess(Job job) {
        LOG.info((Object)(job.getJobName() + " (" + job.getJobID() + ")" + " success"));
    }

    protected void onFailure(Job job) {
        LOG.info((Object)(job.getJobName() + " (" + job.getJobID() + ")" + " failure"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Statistics.JobStats> getRemainingJobs() {
        Queue queue = this.mJobs;
        synchronized (queue) {
            return new ArrayList<Statistics.JobStats>(this.mJobs);
        }
    }

    public void start() {
        for (int i = 0; i < this.numPollingThreads; ++i) {
            this.executor.execute((Runnable)new MonitorThread(this, i));
        }
    }

    public void join(long millis) throws InterruptedException {
        this.executor.awaitTermination(millis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Queue queue = this.mJobs;
        synchronized (queue) {
            this.graceful = false;
            this.shutdown = true;
        }
        this.executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Queue queue = this.mJobs;
        synchronized (queue) {
            this.graceful = true;
            this.shutdown = true;
        }
        this.executor.shutdown();
    }

    static /* synthetic */ Queue access$000(JobMonitor x0) {
        return x0.mJobs;
    }

    static /* synthetic */ boolean access$100(JobMonitor x0) {
        return x0.graceful;
    }

    static /* synthetic */ boolean access$200(JobMonitor x0) {
        return x0.shutdown;
    }

    static /* synthetic */ BlockingQueue access$300(JobMonitor x0) {
        return x0.runningJobs;
    }

    static /* synthetic */ Statistics access$400(JobMonitor x0) {
        return x0.statistics;
    }

    static /* synthetic */ long access$500(JobMonitor x0) {
        return x0.pollDelayMillis;
    }
}

