/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.gridmix.FilePool;
import org.apache.hadoop.mapred.gridmix.Gridmix;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapred.gridmix.JobMonitor;
import org.apache.hadoop.mapred.gridmix.JobSubmitter;
import org.apache.hadoop.mapred.gridmix.Statistics;

class JobSubmitter
implements Gridmix.Component<GridmixJob> {
    public static final Log LOG = LogFactory.getLog(JobSubmitter.class);
    private final Semaphore sem;
    private final Statistics statistics;
    private final FilePool inputDir;
    private final JobMonitor monitor;
    private final ExecutorService sched;
    private volatile boolean shutdown = false;

    public JobSubmitter(JobMonitor monitor, int threads, int queueDepth, FilePool inputDir, Statistics statistics) {
        this.sem = new Semaphore(queueDepth);
        this.sched = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.inputDir = inputDir;
        this.monitor = monitor;
        this.statistics = statistics;
    }

    public void add(GridmixJob job) throws InterruptedException {
        boolean addToQueue;
        boolean bl = addToQueue = !this.shutdown;
        if (addToQueue) {
            SubmitTask task = new SubmitTask(this, job);
            this.sem.acquire();
            try {
                this.sched.execute((Runnable)task);
            }
            catch (RejectedExecutionException e) {
                this.sem.release();
            }
        }
    }

    public void refreshFilePool() throws IOException {
        this.inputDir.refresh();
    }

    public void start() {
    }

    public void join(long millis) throws InterruptedException {
        if (!this.shutdown) {
            throw new IllegalStateException("Cannot wait for active submit thread");
        }
        this.sched.awaitTermination(millis, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.shutdown = true;
        this.sched.shutdown();
    }

    public void abort() {
        this.shutdown = true;
        this.sched.shutdownNow();
    }

    static /* synthetic */ FilePool access$000(JobSubmitter x0) {
        return x0.inputDir;
    }

    static /* synthetic */ JobMonitor access$100(JobSubmitter x0) {
        return x0.monitor;
    }

    static /* synthetic */ Statistics access$200(JobSubmitter x0) {
        return x0.statistics;
    }

    static /* synthetic */ Semaphore access$300(JobSubmitter x0) {
        return x0.sem;
    }
}

