/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.gridmix.GridmixKey;
import org.apache.hadoop.mapred.gridmix.GridmixRecord;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestGridmixRecord {
    private static final Log LOG = LogFactory.getLog(TestGridmixRecord.class);

    static void lengthTest(GridmixRecord x, GridmixRecord y, int min, int max) throws Exception {
        int i;
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        LOG.info((Object)("length: " + seed));
        DataInputBuffer in = new DataInputBuffer();
        DataOutputBuffer out1 = new DataOutputBuffer();
        DataOutputBuffer out2 = new DataOutputBuffer();
        for (i = min; i < max; ++i) {
            TestGridmixRecord.setSerialize((GridmixRecord)x, (long)r.nextLong(), (int)i, (DataOutputBuffer)out1);
            Assert.assertEquals((long)i, (long)out1.getLength());
            x.write((DataOutput)out2);
            in.reset(out1.getData(), 0, out1.getLength());
            y.readFields((DataInput)in);
            Assert.assertEquals((long)i, (long)x.getSize());
            Assert.assertEquals((long)i, (long)y.getSize());
        }
        in.reset(out2.getData(), 0, out2.getLength());
        for (i = min; i < max; ++i) {
            y.readFields((DataInput)in);
            Assert.assertEquals((long)i, (long)y.getSize());
        }
    }

    static void randomReplayTest(GridmixRecord x, GridmixRecord y, int min, int max) throws Exception {
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        LOG.info((Object)("randReplay: " + seed));
        DataOutputBuffer out1 = new DataOutputBuffer();
        for (int i = min; i < max; ++i) {
            int s = out1.getLength();
            x.setSeed(r.nextLong());
            x.setSize(i);
            x.write((DataOutput)out1);
            Assert.assertEquals((long)i, (long)(out1.getLength() - s));
        }
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out1.getData(), 0, out1.getLength());
        DataOutputBuffer out2 = new DataOutputBuffer();
        for (int i = min; i < max; ++i) {
            int s = in.getPosition();
            y.readFields((DataInput)in);
            Assert.assertEquals((long)i, (long)(in.getPosition() - s));
            y.write((DataOutput)out2);
        }
        Assert.assertEquals((long)out1.getLength(), (long)out2.getLength());
        Assert.assertEquals((String)"Bad test", (long)out1.getData().length, (long)out2.getData().length);
        Assert.assertArrayEquals((byte[])out1.getData(), (byte[])out2.getData());
    }

    static void eqSeedTest(GridmixRecord x, GridmixRecord y, int max) throws Exception {
        Random r = new Random();
        long s = r.nextLong();
        r.setSeed(s);
        LOG.info((Object)("eqSeed: " + s));
        Assert.assertEquals((long)x.fixedBytes(), (long)y.fixedBytes());
        int min = x.fixedBytes() + 1;
        DataOutputBuffer out1 = new DataOutputBuffer();
        DataOutputBuffer out2 = new DataOutputBuffer();
        for (int i = min; i < max; ++i) {
            long seed = r.nextLong();
            TestGridmixRecord.setSerialize((GridmixRecord)x, (long)seed, (int)i, (DataOutputBuffer)out1);
            TestGridmixRecord.setSerialize((GridmixRecord)y, (long)seed, (int)i, (DataOutputBuffer)out2);
            Assert.assertEquals((Object)x, (Object)y);
            Assert.assertEquals((long)x.hashCode(), (long)y.hashCode());
            Assert.assertEquals((long)out1.getLength(), (long)out2.getLength());
            Assert.assertEquals((String)"Bad test", (long)out1.getData().length, (long)out2.getData().length);
            Assert.assertArrayEquals((byte[])out1.getData(), (byte[])out2.getData());
        }
    }

    static void binSortTest(GridmixRecord x, GridmixRecord y, int min, int max, WritableComparator cmp) throws Exception {
        Random r = new Random();
        long s = r.nextLong();
        r.setSeed(s);
        LOG.info((Object)("sort: " + s));
        DataOutputBuffer out1 = new DataOutputBuffer();
        DataOutputBuffer out2 = new DataOutputBuffer();
        for (int i = min; i < max; ++i) {
            long seed1 = r.nextLong();
            TestGridmixRecord.setSerialize((GridmixRecord)x, (long)seed1, (int)i, (DataOutputBuffer)out1);
            Assert.assertEquals((long)0L, (long)x.compareSeed(seed1, Math.max(0, i - x.fixedBytes())));
            long seed2 = r.nextLong();
            TestGridmixRecord.setSerialize((GridmixRecord)y, (long)seed2, (int)i, (DataOutputBuffer)out2);
            Assert.assertEquals((long)0L, (long)y.compareSeed(seed2, Math.max(0, i - x.fixedBytes())));
            int chk = WritableComparator.compareBytes((byte[])out1.getData(), (int)0, (int)out1.getLength(), (byte[])out2.getData(), (int)0, (int)out2.getLength());
            Assert.assertEquals((long)chk, (long)x.compareTo(y));
            Assert.assertEquals((long)chk, (long)cmp.compare(out1.getData(), 0, out1.getLength(), out2.getData(), 0, out2.getLength()));
            int s1 = out1.getLength();
            x.write((DataOutput)out1);
            Assert.assertEquals((long)0L, (long)cmp.compare(out1.getData(), 0, s1, out1.getData(), s1, out1.getLength() - s1));
            int s2 = out2.getLength();
            y.write((DataOutput)out2);
            Assert.assertEquals((long)0L, (long)cmp.compare(out2.getData(), 0, s2, out2.getData(), s2, out2.getLength() - s2));
            Assert.assertEquals((long)chk, (long)cmp.compare(out1.getData(), 0, s1, out2.getData(), s2, out2.getLength() - s2));
        }
    }

    static void checkSpec(GridmixKey a, GridmixKey b) throws Exception {
        Random r = new Random();
        long s = r.nextLong();
        r.setSeed(s);
        LOG.info((Object)("spec: " + s));
        DataInputBuffer in = new DataInputBuffer();
        DataOutputBuffer out = new DataOutputBuffer();
        a.setType((byte)0);
        b.setType((byte)0);
        for (int i = 0; i < 100; ++i) {
            int in_rec = r.nextInt(Integer.MAX_VALUE);
            a.setReduceInputRecords((long)in_rec);
            int out_rec = r.nextInt(Integer.MAX_VALUE);
            a.setReduceOutputRecords((long)out_rec);
            int out_bytes = r.nextInt(Integer.MAX_VALUE);
            a.setReduceOutputBytes((long)out_bytes);
            int min = WritableUtils.getVIntSize((long)in_rec) + WritableUtils.getVIntSize((long)out_rec) + WritableUtils.getVIntSize((long)out_bytes) + WritableUtils.getVIntSize((long)0L);
            Assert.assertEquals((long)(min + 2), (long)a.fixedBytes());
            int size = r.nextInt(1024) + a.fixedBytes() + 1;
            TestGridmixRecord.setSerialize((GridmixRecord)a, (long)r.nextLong(), (int)size, (DataOutputBuffer)out);
            Assert.assertEquals((long)size, (long)out.getLength());
            Assert.assertTrue((boolean)a.equals((Object)a));
            Assert.assertEquals((long)0L, (long)a.compareTo((GridmixRecord)a));
            in.reset(out.getData(), 0, out.getLength());
            b.readFields((DataInput)in);
            Assert.assertEquals((long)size, (long)b.getSize());
            Assert.assertEquals((long)in_rec, (long)b.getReduceInputRecords());
            Assert.assertEquals((long)out_rec, (long)b.getReduceOutputRecords());
            Assert.assertEquals((long)out_bytes, (long)b.getReduceOutputBytes());
            Assert.assertTrue((boolean)a.equals((Object)b));
            Assert.assertEquals((long)0L, (long)a.compareTo((GridmixRecord)b));
            Assert.assertEquals((long)a.hashCode(), (long)b.hashCode());
        }
    }

    static void setSerialize(GridmixRecord x, long seed, int size, DataOutputBuffer out) throws IOException {
        x.setSeed(seed);
        x.setSize(size);
        out.reset();
        x.write((DataOutput)out);
    }

    @Test
    public void testKeySpec() throws Exception {
        int min = 6;
        int max = 300;
        GridmixKey a = new GridmixKey(0, 1, 0L);
        GridmixKey b = new GridmixKey(0, 1, 0L);
        TestGridmixRecord.lengthTest((GridmixRecord)a, (GridmixRecord)b, (int)6, (int)300);
        TestGridmixRecord.randomReplayTest((GridmixRecord)a, (GridmixRecord)b, (int)6, (int)300);
        TestGridmixRecord.binSortTest((GridmixRecord)a, (GridmixRecord)b, (int)6, (int)300, (WritableComparator)new GridmixKey.Comparator());
        TestGridmixRecord.eqSeedTest((GridmixRecord)a, (GridmixRecord)b, (int)300);
        TestGridmixRecord.checkSpec((GridmixKey)a, (GridmixKey)b);
    }

    @Test
    public void testKeyData() throws Exception {
        int min = 2;
        int max = 300;
        GridmixKey a = new GridmixKey(1, 1, 0L);
        GridmixKey b = new GridmixKey(1, 1, 0L);
        TestGridmixRecord.lengthTest((GridmixRecord)a, (GridmixRecord)b, (int)2, (int)300);
        TestGridmixRecord.randomReplayTest((GridmixRecord)a, (GridmixRecord)b, (int)2, (int)300);
        TestGridmixRecord.binSortTest((GridmixRecord)a, (GridmixRecord)b, (int)2, (int)300, (WritableComparator)new GridmixKey.Comparator());
        TestGridmixRecord.eqSeedTest((GridmixRecord)a, (GridmixRecord)b, (int)300);
    }

    @Test
    public void testBaseRecord() throws Exception {
        boolean min = true;
        int max = 300;
        GridmixRecord a = new GridmixRecord();
        GridmixRecord b = new GridmixRecord();
        TestGridmixRecord.lengthTest((GridmixRecord)a, (GridmixRecord)b, (int)1, (int)300);
        TestGridmixRecord.randomReplayTest((GridmixRecord)a, (GridmixRecord)b, (int)1, (int)300);
        TestGridmixRecord.binSortTest((GridmixRecord)a, (GridmixRecord)b, (int)1, (int)300, (WritableComparator)new GridmixRecord.Comparator());
        TestGridmixRecord.eqSeedTest((GridmixRecord)a, (GridmixRecord)b, (int)300);
    }

    public static void main(String[] argv) throws Exception {
        boolean fail = false;
        TestGridmixRecord test = new TestGridmixRecord();
        try {
            test.testKeySpec();
        }
        catch (Exception e) {
            fail = true;
            e.printStackTrace();
        }
        try {
            test.testKeyData();
        }
        catch (Exception e) {
            fail = true;
            e.printStackTrace();
        }
        try {
            test.testBaseRecord();
        }
        catch (Exception e) {
            fail = true;
            e.printStackTrace();
        }
        System.exit(fail ? -1 : 0);
    }

    static void printDebug(GridmixRecord a, GridmixRecord b) throws IOException {
        DataOutputBuffer out = new DataOutputBuffer();
        a.write((DataOutput)out);
        System.out.println("A " + Arrays.toString(Arrays.copyOf(out.getData(), out.getLength())));
        out.reset();
        b.write((DataOutput)out);
        System.out.println("B " + Arrays.toString(Arrays.copyOf(out.getData(), out.getLength())));
    }
}

