/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.gridmix.FilePool;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.rumen.JobStory;
import org.apache.hadoop.tools.rumen.datatypes.util.MapReduceJobPropertiesParser;

/*
 * Exception performing whole class analysis ignored.
 */
abstract class GridmixJob
implements Callable<Job>,
Delayed {
    public static final String JOB_NAME_PREFIX = "GRIDMIX";
    public static final Log LOG = LogFactory.getLog(GridmixJob.class);
    private static final ThreadLocal<Formatter> nameFormat = new /* Unavailable Anonymous Inner Class!! */;
    protected final int seq;
    protected final Path outdir;
    protected final Job job;
    protected final JobStory jobdesc;
    protected final UserGroupInformation ugi;
    protected final long submissionTimeNanos;
    private static final ConcurrentHashMap<Integer, List<InputSplit>> descCache = new ConcurrentHashMap();
    protected static final String GRIDMIX_JOB_SEQ = "gridmix.job.seq";
    protected static final String GRIDMIX_USE_QUEUE_IN_TRACE = "gridmix.job-submission.use-queue-in-trace";
    protected static final String GRIDMIX_DEFAULT_QUEUE = "gridmix.job-submission.default-queue";
    static final String GRIDMIX_HIGHRAM_EMULATION_ENABLE = "gridmix.highram-emulation.enable";
    static final String GRIDMIX_TASK_JVM_OPTIONS_ENABLE = "gridmix.task.jvm-options.enable";

    private static void setJobQueue(Job job, String queue) {
        if (queue != null) {
            job.getConfiguration().set("mapreduce.job.queuename", queue);
        }
    }

    public GridmixJob(Configuration conf, long submissionMillis, JobStory jobdesc, Path outRoot, UserGroupInformation ugi, int seq) throws IOException {
        this.ugi = ugi;
        this.jobdesc = jobdesc;
        this.seq = seq;
        ((StringBuilder)((Formatter)nameFormat.get()).out()).setLength("GRIDMIX".length());
        try {
            this.job = (Job)this.ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.submissionTimeNanos = TimeUnit.NANOSECONDS.convert(submissionMillis, TimeUnit.MILLISECONDS);
        this.outdir = new Path(outRoot, "" + seq);
    }

    protected static void configureTaskJVMOptions(Configuration originalJobConf, Configuration simulatedJobConf) {
        GridmixJob.configureTaskJVMMaxHeapOptions((Configuration)originalJobConf, (Configuration)simulatedJobConf, (String)"mapred.child.java.opts");
        GridmixJob.configureTaskJVMMaxHeapOptions((Configuration)originalJobConf, (Configuration)simulatedJobConf, (String)"mapreduce.map.java.opts");
        GridmixJob.configureTaskJVMMaxHeapOptions((Configuration)originalJobConf, (Configuration)simulatedJobConf, (String)"mapreduce.reduce.java.opts");
    }

    private static void configureTaskJVMMaxHeapOptions(Configuration srcConf, Configuration destConf, String key) {
        String srcHeapOpts = srcConf.get(key);
        if (srcHeapOpts != null) {
            ArrayList srcMaxOptsList = new ArrayList();
            MapReduceJobPropertiesParser.extractMaxHeapOpts((String)srcHeapOpts, srcMaxOptsList, new ArrayList());
            if (srcMaxOptsList.size() > 0) {
                ArrayList destOtherOptsList = new ArrayList();
                String destHeapOpts = destConf.get(key);
                if (destHeapOpts != null) {
                    MapReduceJobPropertiesParser.extractMaxHeapOpts((String)destHeapOpts, new ArrayList(), destOtherOptsList);
                }
                StringBuilder newHeapOpts = new StringBuilder();
                for (String otherOpt : destOtherOptsList) {
                    newHeapOpts.append(otherOpt).append(" ");
                }
                for (String opts : srcMaxOptsList) {
                    newHeapOpts.append(opts).append(" ");
                }
                destConf.set(key, newHeapOpts.toString().trim());
            }
        }
    }

    private static void scaleConfigParameter(Configuration sourceConf, Configuration destConf, String clusterValueKey, String jobValueKey, long defaultValue) {
        long simulatedClusterDefaultValue = destConf.getLong(clusterValueKey, defaultValue);
        long originalClusterDefaultValue = sourceConf.getLong(clusterValueKey, defaultValue);
        long originalJobValue = sourceConf.getLong(jobValueKey, defaultValue);
        double scaleFactor = (double)originalJobValue / (double)originalClusterDefaultValue;
        long simulatedJobValue = (long)(scaleFactor * (double)simulatedClusterDefaultValue);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("For the job configuration parameter '" + jobValueKey + "' and the cluster configuration parameter '" + clusterValueKey + "', the original job's configuration value" + " is scaled from '" + originalJobValue + "' to '" + simulatedJobValue + "' using the default (unit) value of " + "'" + originalClusterDefaultValue + "' for the original " + " cluster and '" + simulatedClusterDefaultValue + "' for the" + " simulated cluster."));
        }
        destConf.setLong(jobValueKey, simulatedJobValue);
    }

    private static boolean checkMemoryUpperLimits(String jobKey, String limitKey, Configuration conf, boolean convertLimitToMB) {
        long limit;
        if (conf.get(limitKey) != null && (limit = conf.getLong(limitKey, -1L)) >= 0L) {
            long scaledConfigValue;
            if (convertLimitToMB) {
                limit /= 0x100000L;
            }
            if ((scaledConfigValue = conf.getLong(jobKey, -1L)) > limit) {
                throw new RuntimeException("Simulated job's configuration parameter '" + jobKey + "' got scaled to a value '" + scaledConfigValue + "' which exceeds the upper limit of '" + limit + "' defined for the simulated cluster by the key '" + limitKey + "'. To disable High-Ram feature emulation, set '" + "gridmix.highram-emulation.enable" + "' to 'false'.");
            }
            return true;
        }
        return false;
    }

    private static void validateTaskMemoryLimits(Configuration conf, String jobKey, String clusterMaxKey) {
        if (!GridmixJob.checkMemoryUpperLimits((String)jobKey, (String)"mapred.task.limit.maxvmem", (Configuration)conf, (boolean)true)) {
            GridmixJob.checkMemoryUpperLimits((String)jobKey, (String)clusterMaxKey, (Configuration)conf, (boolean)false);
        }
    }

    static void configureHighRamProperties(Configuration sourceConf, Configuration destConf) {
        GridmixJob.scaleConfigParameter((Configuration)sourceConf, (Configuration)destConf, (String)"mapreduce.cluster.mapmemory.mb", (String)"mapreduce.map.memory.mb", (long)-1L);
        GridmixJob.validateTaskMemoryLimits((Configuration)destConf, (String)"mapreduce.map.memory.mb", (String)"mapreduce.jobtracker.maxmapmemory.mb");
        GridmixJob.scaleConfigParameter((Configuration)sourceConf, (Configuration)destConf, (String)"mapreduce.cluster.reducememory.mb", (String)"mapreduce.reduce.memory.mb", (long)-1L);
        GridmixJob.validateTaskMemoryLimits((Configuration)destConf, (String)"mapreduce.reduce.memory.mb", (String)"mapreduce.jobtracker.maxreducememory.mb");
    }

    protected abstract boolean canEmulateCompression();

    protected GridmixJob(Configuration conf, long submissionMillis, String name) throws IOException {
        this.submissionTimeNanos = TimeUnit.NANOSECONDS.convert(submissionMillis, TimeUnit.MILLISECONDS);
        this.jobdesc = null;
        this.outdir = null;
        this.seq = -1;
        this.ugi = UserGroupInformation.getCurrentUser();
        try {
            this.job = (Job)this.ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public UserGroupInformation getUgi() {
        return this.ugi;
    }

    public String toString() {
        return this.job.getJobName();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.submissionTimeNanos - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        if (this == other) {
            return 0;
        }
        if (other instanceof GridmixJob) {
            long otherNanos = ((GridmixJob)other).submissionTimeNanos;
            if (otherNanos < this.submissionTimeNanos) {
                return 1;
            }
            if (otherNanos > this.submissionTimeNanos) {
                return -1;
            }
            return this.id() - ((GridmixJob)other).id();
        }
        long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
        return 0L == diff ? 0 : (diff > 0L ? 1 : -1);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GridmixJob && this.id() == ((GridmixJob)other).id();
    }

    public int hashCode() {
        return this.id();
    }

    int id() {
        return this.seq;
    }

    Job getJob() {
        return this.job;
    }

    JobStory getJobDesc() {
        return this.jobdesc;
    }

    static void pushDescription(int seq, List<InputSplit> splits) {
        if (null != descCache.putIfAbsent(seq, splits)) {
            throw new IllegalArgumentException("Description exists for id " + seq);
        }
    }

    static List<InputSplit> pullDescription(JobContext jobCtxt) {
        return GridmixJob.pullDescription((int)GridmixJob.getJobSeqId((JobContext)jobCtxt));
    }

    static List<InputSplit> pullDescription(int seq) {
        return (List)descCache.remove(seq);
    }

    static void clearAll() {
        descCache.clear();
    }

    void buildSplits(FilePool inputDir) throws IOException {
    }

    static int getJobSeqId(JobContext job) {
        return job.getConfiguration().getInt("gridmix.job.seq", -1);
    }

    static /* synthetic */ ThreadLocal access$000() {
        return nameFormat;
    }

    static /* synthetic */ void access$100(Job x0, String x1) {
        GridmixJob.setJobQueue((Job)x0, (String)x1);
    }
}

