/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.gridmix.AvgRecordFactory;
import org.apache.hadoop.mapred.gridmix.GridmixKey;
import org.apache.hadoop.mapred.gridmix.GridmixRecord;
import org.apache.hadoop.mapred.gridmix.RecordFactory;

class IntermediateRecordFactory
extends RecordFactory {
    private final GridmixKey.Spec spec;
    private final RecordFactory factory;
    private final int partition;
    private final long targetRecords;
    private boolean done = false;
    private long accRecords = 0L;

    public IntermediateRecordFactory(long targetBytes, long targetRecords, int partition, GridmixKey.Spec spec, Configuration conf) {
        this((RecordFactory)new AvgRecordFactory(targetBytes, targetRecords, conf), partition, targetRecords, spec, conf);
    }

    public IntermediateRecordFactory(RecordFactory factory, int partition, long targetRecords, GridmixKey.Spec spec, Configuration conf) {
        this.spec = spec;
        this.factory = factory;
        this.partition = partition;
        this.targetRecords = targetRecords;
    }

    public boolean next(GridmixKey key, GridmixRecord val) throws IOException {
        assert (key != null);
        boolean rslt = this.factory.next(key, val);
        ++this.accRecords;
        if (rslt) {
            if (this.accRecords < this.targetRecords) {
                key.setType((byte)1);
            } else {
                int orig = key.getSize();
                key.setType((byte)0);
                this.spec.rec_in = this.accRecords;
                key.setSpec(this.spec);
                val.setSize(val.getSize() - (key.getSize() - orig));
                this.accRecords = 0L;
                this.spec.bytes_out = 0L;
                this.spec.rec_out = 0L;
                this.done = true;
            }
        } else if (!this.done) {
            key.setType((byte)0);
            key.setPartition(this.partition);
            key.setSize(0);
            val.setSize(0);
            this.spec.rec_in = 0L;
            key.setSpec(this.spec);
            this.done = true;
            return true;
        }
        key.setPartition(this.partition);
        return rslt;
    }

    public float getProgress() throws IOException {
        return this.factory.getProgress();
    }

    public void close() throws IOException {
        this.factory.close();
    }
}

