/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.RegexpInConfigurationFilter;
import org.junit.Assert;
import org.junit.Test;

public class TestRegexpInConfigurationFilter {
    @Test
    public void testShouldCopy() {
        Configuration configuration = new Configuration(false);
        configuration.set("distcp.exclude-file-regex", "\\/.*_COPYING_$|\\/.*_COPYING$|^.*\\/\\.[^\\/]*$|\\/_temporary$|\\/\\_temporary\\/|.*\\/\\.Trash\\/.*");
        RegexpInConfigurationFilter defaultCopyFilter = new RegexpInConfigurationFilter(configuration);
        Path shouldCopyPath = new Path("/user/bar");
        Assert.assertTrue((String)(shouldCopyPath.toString() + " should be copied"), (boolean)defaultCopyFilter.shouldCopy(shouldCopyPath));
        shouldCopyPath = new Path("/user/bar/_COPYING");
        Assert.assertFalse((String)(shouldCopyPath.toString() + " shouldn't be copied"), (boolean)defaultCopyFilter.shouldCopy(shouldCopyPath));
        shouldCopyPath = new Path("/user/bar/_COPYING_");
        Assert.assertFalse((String)(shouldCopyPath.toString() + " shouldn't be copied"), (boolean)defaultCopyFilter.shouldCopy(shouldCopyPath));
        shouldCopyPath = new Path("/temp/");
        Assert.assertTrue((String)(shouldCopyPath.toString() + " should be copied"), (boolean)defaultCopyFilter.shouldCopy(shouldCopyPath));
    }
}

