/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.impl.PathCapabilitiesSupport;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.tools.CopyFilter;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpContext;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.DistCpSync;
import org.apache.hadoop.tools.OptionsParser;
import org.apache.hadoop.tools.RegexCopyFilter;
import org.apache.hadoop.tools.SimpleCopyListing;
import org.apache.hadoop.tools.StubContext;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDistCpSync {
    private MiniDFSCluster cluster;
    private final Configuration conf = new HdfsConfiguration();
    private DistributedFileSystem dfs;
    private WebHdfsFileSystem webfs;
    private DistCpContext context;
    private final Path source = new Path("/source");
    private final Path target = new Path("/target");
    private final long BLOCK_SIZE = 1024L;
    private final short DATA_NUM = 1;

    @Before
    public void setUp() throws Exception {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.webfs = WebHdfsTestUtil.getWebHdfsFileSystem((Configuration)this.conf, (String)"webhdfs");
        this.dfs = this.cluster.getFileSystem();
        this.dfs.mkdirs(this.source);
        this.dfs.mkdirs(this.target);
        DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(this.source), this.target).withSyncFolder(true).withUseDiff("s1", "s2").build();
        options.appendToConf(this.conf);
        this.context = new DistCpContext(options);
        this.conf.set("distcp.target.work.path", this.target.toString());
        this.conf.set("distcp.target.final.path", this.target.toString());
        this.conf.setClass("fs.dummy.impl", DummyFs.class, FileSystem.class);
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.dfs});
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testFallback() throws Exception {
        Assert.assertFalse((boolean)this.sync());
        Path spath = new Path(this.source, ".snapshot/s2");
        Assert.assertEquals((Object)spath, this.context.getSourcePaths().get(0));
        this.context.setSourcePaths(Collections.singletonList(this.source));
        this.dfs.allowSnapshot(this.source);
        this.dfs.allowSnapshot(this.target);
        Assert.assertFalse((boolean)this.sync());
        Assert.assertEquals((Object)spath, this.context.getSourcePaths().get(0));
        this.context.setSourcePaths(Collections.singletonList(this.source));
        this.dfs.createSnapshot(this.source, "s1");
        this.dfs.createSnapshot(this.source, "s2");
        this.dfs.createSnapshot(this.target, "s1");
        Assert.assertTrue((boolean)this.sync());
        this.context.setSourcePaths(Collections.singletonList(this.source));
        Path subTarget = new Path(this.target, "sub");
        this.dfs.mkdirs(subTarget);
        Assert.assertFalse((boolean)this.sync());
        Assert.assertEquals((Object)spath, this.context.getSourcePaths().get(0));
        this.context.setSourcePaths(Collections.singletonList(this.source));
        this.dfs.delete(subTarget, true);
        Assert.assertTrue((boolean)this.sync());
    }

    private void enableAndCreateFirstSnapshot() throws Exception {
        this.dfs.allowSnapshot(this.source);
        this.dfs.allowSnapshot(this.target);
        this.dfs.createSnapshot(this.source, "s1");
        this.dfs.createSnapshot(this.target, "s1");
    }

    private void syncAndVerify() throws Exception {
        Assert.assertTrue((boolean)this.sync());
        this.verifyCopy(this.dfs.getFileStatus(this.source), this.dfs.getFileStatus(this.target), false);
    }

    private boolean sync() throws Exception {
        DistCpSync distCpSync = new DistCpSync(this.context, this.conf);
        return distCpSync.sync();
    }

    private void initData(Path dir) throws Exception {
        this.initData((FileSystem)this.dfs, dir);
    }

    private void initData(FileSystem fs, Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path d1 = new Path(foo, "d1");
        Path f1 = new Path(foo, "f1");
        Path d2 = new Path(bar, "d2");
        Path f2 = new Path(bar, "f2");
        Path f3 = new Path(d1, "f3");
        Path f4 = new Path(d2, "f4");
        DFSTestUtil.createFile((FileSystem)fs, (Path)f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)fs, (Path)f2, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)fs, (Path)f3, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)fs, (Path)f4, (long)1024L, (short)1, (long)0L);
    }

    private int changeData(FileSystem fs, Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path d1 = new Path(foo, "d1");
        Path f2 = new Path(bar, "f2");
        Path bar_d1 = new Path(bar, "d1");
        int numCreatedModified = 0;
        fs.rename(d1, bar_d1);
        ++numCreatedModified;
        ++numCreatedModified;
        Path f3 = new Path(bar_d1, "f3");
        fs.delete(f3, true);
        Path newfoo = new Path(bar_d1, "foo");
        fs.rename(foo, newfoo);
        ++numCreatedModified;
        Path f1 = new Path(newfoo, "f1");
        fs.delete(f1, true);
        DFSTestUtil.createFile((FileSystem)fs, (Path)f1, (long)2048L, (short)1, (long)0L);
        ++numCreatedModified;
        DFSTestUtil.appendFile((FileSystem)fs, (Path)f2, (int)1024);
        fs.rename(bar, new Path(dir, "foo"));
        return ++numCreatedModified;
    }

    @Test
    public void testSync() throws Exception {
        this.initData(this.source);
        this.initData(this.target);
        this.enableAndCreateFirstSnapshot();
        int numCreatedModified = this.changeData((FileSystem)this.dfs, this.source);
        this.dfs.createSnapshot(this.source, "s2");
        Path toDelete = new Path(this.source, "foo/d1/foo/f1");
        this.dfs.delete(toDelete, true);
        Path newdir = new Path(this.source, "foo/d1/foo/newdir");
        this.dfs.mkdirs(newdir);
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.source, "s1", "s2");
        System.out.println(report);
        DistCpSync distCpSync = new DistCpSync(this.context, this.conf);
        Assert.assertTrue((boolean)distCpSync.sync());
        Path spath = new Path(this.source, ".snapshot/s2");
        Assert.assertEquals((Object)spath, this.context.getSourcePaths().get(0));
        Path listingPath = new Path("/tmp/META/fileList.seq");
        SimpleCopyListing listing = new SimpleCopyListing(this.conf, new Credentials(), distCpSync);
        listing.buildListing(listingPath, this.context);
        Map<Text, CopyListingFileStatus> copyListing = this.getListing(listingPath);
        CopyMapper copyMapper = new CopyMapper();
        StubContext stubContext = new StubContext(this.conf, null, 0);
        Mapper.Context mapContext = stubContext.getContext();
        mapContext.getConfiguration().setBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), true);
        copyMapper.setup(mapContext);
        for (Map.Entry<Text, CopyListingFileStatus> entry : copyListing.entrySet()) {
            copyMapper.map(entry.getKey(), entry.getValue(), mapContext);
        }
        Assert.assertEquals((long)numCreatedModified, (long)copyListing.size());
        Assert.assertEquals((long)3072L, (long)stubContext.getReporter().getCounter((Enum)CopyMapper.Counter.BYTESCOPIED).getValue());
        this.verifyCopy(this.dfs.getFileStatus(spath), this.dfs.getFileStatus(this.target), false);
    }

    @Test
    public void testSync1() throws Exception {
        Path srcpath = new Path(this.source, "encz-mock");
        this.dfs.mkdirs(srcpath);
        this.dfs.mkdirs(new Path(this.source, "encz-mock/datedir"));
        this.enableAndCreateFirstSnapshot();
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)new Path(this.source, "encz-mock/datedir/file1"), (long)1024L, (short)1, (long)0L);
        this.dfs.delete(new Path(this.source, "encz-mock/datedir"), true);
        this.dfs.mkdirs(new Path(this.source, "encz-mock/datedir"));
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)new Path(this.source, "encz-mock/datedir/file2"), (long)1024L, (short)1, (long)0L);
        this.dfs.createSnapshot(this.source, "s2");
        Assert.assertTrue((boolean)this.dfs.exists(new Path(this.source, "encz-mock/datedir/file2")));
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.source, "s1", "s2");
        System.out.println(report);
        DistCpSync distCpSync = new DistCpSync(this.context, this.conf);
        Assert.assertTrue((boolean)distCpSync.sync());
        Path spath = new Path(this.source, ".snapshot/s2");
        Assert.assertEquals((Object)spath, this.context.getSourcePaths().get(0));
        Path listingPath = new Path("/tmp/META/fileList.seq");
        SimpleCopyListing listing = new SimpleCopyListing(this.conf, new Credentials(), distCpSync);
        listing.buildListing(listingPath, this.context);
        Map<Text, CopyListingFileStatus> copyListing = this.getListing(listingPath);
        CopyMapper copyMapper = new CopyMapper();
        StubContext stubContext = new StubContext(this.conf, null, 0);
        Mapper.Context mapContext = stubContext.getContext();
        copyMapper.setup(mapContext);
        for (Map.Entry<Text, CopyListingFileStatus> entry : copyListing.entrySet()) {
            copyMapper.map(entry.getKey(), entry.getValue(), mapContext);
        }
        Assert.assertTrue((boolean)this.dfs.exists(new Path(this.target, "encz-mock/datedir/file2")));
        this.verifyCopy(this.dfs.getFileStatus(spath), this.dfs.getFileStatus(this.target), false);
    }

    @Test
    public void testSyncNew() throws Exception {
        Path srcpath = new Path(this.source, "encz-mock");
        this.dfs.mkdirs(srcpath);
        this.dfs.mkdirs(new Path(this.source, "encz-mock/datedir"));
        this.dfs.mkdirs(new Path(this.source, "trash"));
        this.enableAndCreateFirstSnapshot();
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)new Path(this.source, "encz-mock/datedir/file1"), (long)1024L, (short)1, (long)0L);
        this.dfs.rename(new Path(this.source, "encz-mock/datedir"), new Path(this.source, "trash"));
        this.dfs.mkdirs(new Path(this.source, "encz-mock/datedir"));
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)new Path(this.source, "encz-mock/datedir/file2"), (long)1024L, (short)1, (long)0L);
        this.dfs.createSnapshot(this.source, "s2");
        Assert.assertTrue((boolean)this.dfs.exists(new Path(this.source, "encz-mock/datedir/file2")));
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.source, "s1", "s2");
        System.out.println(report);
        DistCpSync distCpSync = new DistCpSync(this.context, this.conf);
        Assert.assertTrue((boolean)distCpSync.sync());
        Path spath = new Path(this.source, ".snapshot/s2");
        Assert.assertEquals((Object)spath, this.context.getSourcePaths().get(0));
        Path listingPath = new Path("/tmp/META/fileList.seq");
        SimpleCopyListing listing = new SimpleCopyListing(this.conf, new Credentials(), distCpSync);
        listing.buildListing(listingPath, this.context);
        Map<Text, CopyListingFileStatus> copyListing = this.getListing(listingPath);
        CopyMapper copyMapper = new CopyMapper();
        StubContext stubContext = new StubContext(this.conf, null, 0);
        Mapper.Context mapContext = stubContext.getContext();
        copyMapper.setup(mapContext);
        for (Map.Entry<Text, CopyListingFileStatus> entry : copyListing.entrySet()) {
            copyMapper.map(entry.getKey(), entry.getValue(), mapContext);
        }
        Assert.assertTrue((boolean)this.dfs.exists(new Path(this.target, "encz-mock/datedir/file2")));
        Assert.assertTrue((boolean)this.dfs.exists(new Path(this.target, "trash/datedir/file1")));
        this.verifyCopy(this.dfs.getFileStatus(spath), this.dfs.getFileStatus(this.target), false);
    }

    @Test
    public void testSyncWithFilters() throws Exception {
        Path srcpath = new Path(this.source, "encz-mock");
        this.dfs.mkdirs(srcpath);
        this.dfs.mkdirs(new Path(this.source, "encz-mock/datedir"));
        this.dfs.mkdirs(new Path(this.source, "trash"));
        this.enableAndCreateFirstSnapshot();
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)new Path(this.source, "encz-mock/datedir/file1"), (long)1024L, (short)1, (long)0L);
        this.dfs.rename(new Path(this.source, "encz-mock/datedir"), new Path(this.source, "trash"));
        this.dfs.mkdirs(new Path(this.source, "encz-mock/datedir"));
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)new Path(this.source, "encz-mock/datedir/file2"), (long)1024L, (short)1, (long)0L);
        this.dfs.createSnapshot(this.source, "s2");
        Assert.assertTrue((boolean)this.dfs.exists(new Path(this.source, "encz-mock/datedir/file2")));
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.source, "s1", "s2");
        System.out.println(report);
        ArrayList<Pattern> filters = new ArrayList<Pattern>();
        filters.add(Pattern.compile(".*trash.*"));
        RegexCopyFilter regexCopyFilter = new RegexCopyFilter("fakeFile");
        regexCopyFilter.setFilters(filters);
        DistCpSync distCpSync = new DistCpSync(this.context, this.conf);
        distCpSync.setCopyFilter((CopyFilter)regexCopyFilter);
        Assert.assertTrue((boolean)distCpSync.sync());
        Path spath = new Path(this.source, ".snapshot/s2");
        Assert.assertEquals((Object)spath, this.context.getSourcePaths().get(0));
        Path listingPath = new Path("/tmp/META/fileList.seq");
        SimpleCopyListing listing = new SimpleCopyListing(this.conf, new Credentials(), distCpSync);
        listing.buildListing(listingPath, this.context);
        Map<Text, CopyListingFileStatus> copyListing = this.getListing(listingPath);
        CopyMapper copyMapper = new CopyMapper();
        StubContext stubContext = new StubContext(this.conf, null, 0);
        Mapper.Context mapContext = stubContext.getContext();
        copyMapper.setup(mapContext);
        for (Map.Entry<Text, CopyListingFileStatus> entry : copyListing.entrySet()) {
            copyMapper.map(entry.getKey(), entry.getValue(), mapContext);
        }
        Assert.assertTrue((boolean)this.dfs.exists(new Path(this.target, "encz-mock/datedir/file2")));
        Assert.assertFalse((boolean)this.dfs.exists(new Path(this.target, "encz-mock/datedir/file1")));
        Assert.assertFalse((boolean)this.dfs.exists(new Path(this.target, "trash/datedir/file1")));
    }

    private Map<Text, CopyListingFileStatus> getListing(Path listingPath) throws Exception {
        SequenceFile.Reader reader = new SequenceFile.Reader(this.conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)listingPath)});
        Text key = new Text();
        CopyListingFileStatus value = new CopyListingFileStatus();
        HashMap<Text, CopyListingFileStatus> values = new HashMap<Text, CopyListingFileStatus>();
        while (reader.next((Writable)key, (Writable)value)) {
            values.put(key, value);
            key = new Text();
            value = new CopyListingFileStatus();
        }
        return values;
    }

    private void verifyCopy(FileStatus s, FileStatus t, boolean compareName) throws Exception {
        this.verifyCopy((FileSystem)this.dfs, (FileSystem)this.dfs, s, t, compareName);
    }

    private void verifyCopyByFs(FileSystem sfs, FileSystem tfs, FileStatus s, FileStatus t, boolean compareName) throws Exception {
        this.verifyCopy(sfs, tfs, s, t, compareName);
    }

    private void verifyCopy(FileSystem sfs, FileSystem tfs, FileStatus s, FileStatus t, boolean compareName) throws Exception {
        Assert.assertEquals((Object)s.isDirectory(), (Object)t.isDirectory());
        if (compareName) {
            Assert.assertEquals((Object)s.getPath().getName(), (Object)t.getPath().getName());
        }
        if (!s.isDirectory()) {
            byte[] sbytes = DFSTestUtil.readFileBuffer((FileSystem)sfs, (Path)s.getPath());
            byte[] tbytes = DFSTestUtil.readFileBuffer((FileSystem)tfs, (Path)t.getPath());
            Assert.assertArrayEquals((byte[])sbytes, (byte[])tbytes);
        } else {
            FileStatus[] slist = sfs.listStatus(s.getPath());
            FileStatus[] tlist = tfs.listStatus(t.getPath());
            Assert.assertEquals((long)slist.length, (long)tlist.length);
            for (int i = 0; i < slist.length; ++i) {
                this.verifyCopy(sfs, tfs, slist[i], tlist[i], true);
            }
        }
    }

    @Test
    public void testSyncWithCurrent() throws Exception {
        DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(this.source), this.target).withSyncFolder(true).withUseDiff("s1", ".").build();
        this.context = new DistCpContext(options);
        this.initData(this.source);
        this.initData(this.target);
        this.enableAndCreateFirstSnapshot();
        this.changeData((FileSystem)this.dfs, this.source);
        this.sync();
        Assert.assertEquals((Object)this.source, this.context.getSourcePaths().get(0));
    }

    private void initData2(Path dir) throws Exception {
        Path test = new Path(dir, "test");
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path f1 = new Path(test, "f1");
        Path f2 = new Path(foo, "f2");
        Path f3 = new Path(bar, "f3");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f2, (long)1024L, (short)1, (long)1L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f3, (long)1024L, (short)1, (long)2L);
    }

    private void changeData2(Path dir) throws Exception {
        Path tmpFoo = new Path(dir, "tmpFoo");
        Path test = new Path(dir, "test");
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        this.dfs.rename(test, tmpFoo);
        this.dfs.rename(foo, test);
        this.dfs.rename(bar, foo);
        this.dfs.rename(tmpFoo, bar);
    }

    @Test
    public void testSync2() throws Exception {
        this.initData2(this.source);
        this.initData2(this.target);
        this.enableAndCreateFirstSnapshot();
        this.changeData2(this.source);
        this.dfs.createSnapshot(this.source, "s2");
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.source, "s1", "s2");
        System.out.println(report);
        this.syncAndVerify();
    }

    private void initData3(Path dir) throws Exception {
        Path test = new Path(dir, "test");
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path f1 = new Path(test, "file");
        Path f2 = new Path(foo, "file");
        Path f3 = new Path(bar, "file");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f2, (long)2048L, (short)1, (long)1L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f3, (long)3072L, (short)1, (long)2L);
    }

    private void changeData3(Path dir) throws Exception {
        Path test = new Path(dir, "test");
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path f1 = new Path(test, "file");
        Path f2 = new Path(foo, "file");
        Path f3 = new Path(bar, "file");
        Path newf1 = new Path(test, "newfile");
        Path newf2 = new Path(foo, "newfile");
        Path newf3 = new Path(bar, "newfile");
        this.dfs.rename(f1, newf1);
        this.dfs.rename(f2, newf2);
        this.dfs.rename(f3, newf3);
    }

    @Test
    public void testSync3() throws Exception {
        this.initData3(this.source);
        this.initData3(this.target);
        this.enableAndCreateFirstSnapshot();
        this.changeData3(this.source);
        this.dfs.createSnapshot(this.source, "s2");
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.source, "s1", "s2");
        System.out.println(report);
        this.syncAndVerify();
    }

    private void initData4(Path dir) throws Exception {
        Path d1 = new Path(dir, "d1");
        Path d2 = new Path(d1, "d2");
        Path f1 = new Path(d2, "f1");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)1024L, (short)1, (long)0L);
    }

    private void changeData4(Path dir) throws Exception {
        Path d1 = new Path(dir, "d1");
        Path d11 = new Path(dir, "d11");
        Path d2 = new Path(d1, "d2");
        Path d21 = new Path(d1, "d21");
        Path f1 = new Path(d2, "f1");
        this.dfs.delete(f1, false);
        this.dfs.rename(d2, d21);
        this.dfs.rename(d1, d11);
    }

    @Test
    public void testSync4() throws Exception {
        this.initData4(this.source);
        this.initData4(this.target);
        this.enableAndCreateFirstSnapshot();
        this.changeData4(this.source);
        this.dfs.createSnapshot(this.source, "s2");
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.source, "s1", "s2");
        System.out.println(report);
        this.syncAndVerify();
    }

    private void initData5(Path dir) throws Exception {
        Path d1 = new Path(dir, "d1");
        Path d2 = new Path(dir, "d2");
        Path f1 = new Path(d1, "f1");
        Path f2 = new Path(d2, "f2");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)f2, (long)1024L, (short)1, (long)0L);
    }

    private void changeData5(Path dir) throws Exception {
        Path d1 = new Path(dir, "d1");
        Path d2 = new Path(dir, "d2");
        Path f1 = new Path(d1, "f1");
        Path tmp = new Path(dir, "tmp");
        this.dfs.delete(f1, false);
        this.dfs.rename(d1, tmp);
        this.dfs.rename(d2, d1);
        Path f2 = new Path(d1, "f2");
        this.dfs.delete(f2, false);
    }

    @Test
    public void testSync5() throws Exception {
        this.initData5(this.source);
        this.initData5(this.target);
        this.enableAndCreateFirstSnapshot();
        this.changeData5(this.source);
        this.dfs.createSnapshot(this.source, "s2");
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.source, "s1", "s2");
        System.out.println(report);
        this.syncAndVerify();
    }

    private void testAndVerify(int numCreatedModified) throws Exception {
        SnapshotDiffReport report = this.dfs.getSnapshotDiffReport(this.source, "s1", "s2");
        System.out.println(report);
        DistCpSync distCpSync = new DistCpSync(this.context, this.conf);
        Assert.assertTrue((boolean)distCpSync.sync());
        Path spath = new Path(this.source, ".snapshot/s2");
        Assert.assertEquals((Object)spath, this.context.getSourcePaths().get(0));
        Path listingPath = new Path("/tmp/META/fileList.seq");
        SimpleCopyListing listing = new SimpleCopyListing(this.conf, new Credentials(), distCpSync);
        listing.buildListing(listingPath, this.context);
        Map<Text, CopyListingFileStatus> copyListing = this.getListing(listingPath);
        CopyMapper copyMapper = new CopyMapper();
        StubContext stubContext = new StubContext(this.conf, null, 0);
        Mapper.Context mapContext = stubContext.getContext();
        mapContext.getConfiguration().setBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), true);
        copyMapper.setup(mapContext);
        for (Map.Entry<Text, CopyListingFileStatus> entry : copyListing.entrySet()) {
            copyMapper.map(entry.getKey(), entry.getValue(), mapContext);
        }
        Assert.assertEquals((long)numCreatedModified, (long)copyListing.size());
        this.verifyCopy(this.dfs.getFileStatus(spath), this.dfs.getFileStatus(this.target), false);
    }

    private void initData6(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path foo_f1 = new Path(foo, "f1");
        Path bar_f1 = new Path(bar, "f1");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)bar_f1, (long)1024L, (short)1, (long)0L);
    }

    private int changeData6(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path foo2 = new Path(dir, "foo2");
        Path foo_f1 = new Path(foo, "f1");
        int numCreatedModified = 0;
        this.dfs.rename(foo, foo2);
        this.dfs.rename(bar, foo);
        this.dfs.rename(foo2, bar);
        DFSTestUtil.appendFile((FileSystem)this.dfs, (Path)foo_f1, (int)1024);
        return ++numCreatedModified;
    }

    @Test
    public void testSync6() throws Exception {
        this.initData6(this.source);
        this.initData6(this.target);
        this.enableAndCreateFirstSnapshot();
        int numCreatedModified = this.changeData6(this.source);
        this.dfs.createSnapshot(this.source, "s2");
        this.testAndVerify(numCreatedModified);
    }

    private void initData7(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path foo_f1 = new Path(foo, "f1");
        Path bar_f1 = new Path(bar, "f1");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)bar_f1, (long)1024L, (short)1, (long)0L);
    }

    private int changeData7(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path foo2 = new Path(dir, "foo2");
        Path foo_f1 = new Path(foo, "f1");
        Path foo2_f2 = new Path(foo2, "f2");
        Path foo_d1 = new Path(foo, "d1");
        Path foo_d1_f3 = new Path(foo_d1, "f3");
        int numCreatedModified = 0;
        this.dfs.rename(foo, foo2);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_f1, (long)1024L, (short)1, (long)0L);
        numCreatedModified += 2;
        DFSTestUtil.appendFile((FileSystem)this.dfs, (Path)foo_f1, (int)1024);
        this.dfs.rename(foo_f1, foo2_f2);
        --numCreatedModified;
        numCreatedModified += 2;
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_d1_f3, (long)1024L, (short)1, (long)0L);
        return numCreatedModified += 2;
    }

    @Test
    public void testSync7() throws Exception {
        this.initData7(this.source);
        this.initData7(this.target);
        this.enableAndCreateFirstSnapshot();
        int numCreatedModified = this.changeData7(this.source);
        this.dfs.createSnapshot(this.source, "s2");
        this.testAndVerify(numCreatedModified);
    }

    private void initData8(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(dir, "bar");
        Path d1 = new Path(dir, "d1");
        Path foo_f1 = new Path(foo, "f1");
        Path bar_f1 = new Path(bar, "f1");
        Path d1_f1 = new Path(d1, "f1");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)bar_f1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)d1_f1, (long)1024L, (short)1, (long)0L);
    }

    private int changeData8(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path createdDir = new Path(dir, "c");
        Path d1 = new Path(dir, "d1");
        Path d1_f1 = new Path(d1, "f1");
        Path createdDir_f1 = new Path(createdDir, "f1");
        Path foo_f3 = new Path(foo, "f3");
        Path new_foo = new Path(createdDir, "foo");
        Path foo_f4 = new Path(foo, "f4");
        Path foo_d1 = new Path(foo, "d1");
        Path bar = new Path(dir, "bar");
        Path bar1 = new Path(dir, "bar1");
        int numCreatedModified = 0;
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_f3, (long)1024L, (short)1, (long)0L);
        ++numCreatedModified;
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)createdDir_f1, (long)1024L, (short)1, (long)0L);
        ++numCreatedModified;
        this.dfs.rename(createdDir_f1, foo_f4);
        ++numCreatedModified;
        this.dfs.rename(d1_f1, createdDir_f1);
        ++numCreatedModified;
        this.dfs.rename(d1, foo_d1);
        this.dfs.rename(foo, new_foo);
        this.dfs.rename(bar, bar1);
        return ++numCreatedModified;
    }

    @Test
    public void testSync8() throws Exception {
        this.initData8(this.source);
        this.initData8(this.target);
        this.enableAndCreateFirstSnapshot();
        int numCreatedModified = this.changeData8(this.source);
        this.dfs.createSnapshot(this.source, "s2");
        this.testAndVerify(numCreatedModified);
    }

    private void initData9(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path foo_f1 = new Path(foo, "f1");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_f1, (long)1024L, (short)1, (long)0L);
    }

    private void changeData9(Path dir) throws Exception {
        Path foo = new Path(dir, "foo");
        Path foo_f2 = new Path(foo, "f2");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)foo_f2, (long)1024L, (short)1, (long)0L);
    }

    @Test
    public void testSync9() throws Exception {
        Path sourcePath = new Path(this.dfs.getWorkingDirectory(), "source");
        this.initData9(sourcePath);
        this.initData9(this.target);
        this.dfs.allowSnapshot(sourcePath);
        this.dfs.allowSnapshot(this.target);
        this.dfs.createSnapshot(sourcePath, "s1");
        this.dfs.createSnapshot(this.target, "s1");
        this.changeData9(sourcePath);
        this.dfs.createSnapshot(sourcePath, "s2");
        String[] args = new String[]{"-update", "-diff", "s1", "s2", "source", this.target.toString()};
        new DistCp(this.conf, OptionsParser.parse((String[])args)).execute();
        this.verifyCopy(this.dfs.getFileStatus(sourcePath), this.dfs.getFileStatus(this.target), false);
    }

    @Test
    public void testSyncSnapshotTimeStampChecking() throws Exception {
        this.initData(this.source);
        this.initData(this.target);
        this.dfs.allowSnapshot(this.source);
        this.dfs.allowSnapshot(this.target);
        this.dfs.createSnapshot(this.source, "s2");
        this.dfs.createSnapshot(this.target, "s1");
        Thread.sleep(1000L);
        this.dfs.createSnapshot(this.source, "s1");
        boolean threwException = false;
        try {
            DistCpSync distCpSync = new DistCpSync(this.context, this.conf);
            distCpSync.sync();
        }
        catch (HadoopIllegalArgumentException e) {
            threwException = true;
            GenericTestUtils.assertExceptionContains((String)"Snapshot s2 should be newer than s1", (Throwable)e);
        }
        Assert.assertTrue((boolean)threwException);
    }

    private void initData10(Path dir) throws Exception {
        Path staging = new Path(dir, ".staging");
        Path stagingF1 = new Path(staging, "f1");
        Path data = new Path(dir, "data");
        Path dataF1 = new Path(data, "f1");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)stagingF1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)dataF1, (long)1024L, (short)1, (long)0L);
    }

    private void changeData10(Path dir) throws Exception {
        Path staging = new Path(dir, ".staging");
        Path prod = new Path(dir, "prod");
        this.dfs.rename(staging, prod);
    }

    private java.nio.file.Path generateFilterFile(String fileName) throws IOException {
        java.nio.file.Path tmpFile = Files.createTempFile(fileName, "txt", new FileAttribute[0]);
        String str = ".*\\.staging.*";
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile.toString()));){
            writer.write(str);
        }
        return tmpFile;
    }

    private void deleteFilterFile(java.nio.file.Path filePath) throws IOException {
        Files.delete(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSync10() throws Exception {
        java.nio.file.Path filterFile = null;
        try {
            Path sourcePath = new Path(this.dfs.getWorkingDirectory(), "source");
            this.initData10(sourcePath);
            this.dfs.allowSnapshot(sourcePath);
            this.dfs.createSnapshot(sourcePath, "s1");
            filterFile = this.generateFilterFile("filters");
            DistCpOptions.Builder builder = new DistCpOptions.Builder(new ArrayList<Path>(Arrays.asList(sourcePath)), this.target).withFiltersFile(filterFile.toString()).withSyncFolder(true);
            new DistCp(this.conf, builder.build()).execute();
            this.verifySync(this.dfs.getFileStatus(sourcePath), this.dfs.getFileStatus(this.target), false, ".staging");
            this.dfs.allowSnapshot(this.target);
            this.dfs.createSnapshot(this.target, "s1");
            this.changeData10(sourcePath);
            this.dfs.createSnapshot(sourcePath, "s2");
            DistCpOptions.Builder diffBuilder = new DistCpOptions.Builder(new ArrayList<Path>(Arrays.asList(sourcePath)), this.target).withUseDiff("s1", "s2").withFiltersFile(filterFile.toString()).withSyncFolder(true);
            new DistCp(this.conf, diffBuilder.build()).execute();
            this.verifyCopy(this.dfs.getFileStatus(sourcePath), this.dfs.getFileStatus(this.target), false);
        }
        catch (Throwable throwable) {
            this.deleteFilterFile(filterFile);
            throw throwable;
        }
        this.deleteFilterFile(filterFile);
    }

    private void initData11(Path dir) throws Exception {
        Path staging = new Path(dir, "prod");
        Path stagingF1 = new Path(staging, "f1");
        Path data = new Path(dir, "data");
        Path dataF1 = new Path(data, "f1");
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)stagingF1, (long)1024L, (short)1, (long)0L);
        DFSTestUtil.createFile((FileSystem)this.dfs, (Path)dataF1, (long)1024L, (short)1, (long)0L);
    }

    private void changeData11(Path dir) throws Exception {
        Path staging = new Path(dir, "prod");
        Path prod = new Path(dir, ".staging");
        this.dfs.rename(staging, prod);
    }

    private void verifySync(FileStatus s, FileStatus t, boolean compareName, String deletedName) throws Exception {
        Assert.assertEquals((Object)s.isDirectory(), (Object)t.isDirectory());
        if (compareName) {
            Assert.assertEquals((Object)s.getPath().getName(), (Object)t.getPath().getName());
        }
        if (!s.isDirectory()) {
            byte[] sbytes = DFSTestUtil.readFileBuffer((FileSystem)this.dfs, (Path)s.getPath());
            byte[] tbytes = DFSTestUtil.readFileBuffer((FileSystem)this.dfs, (Path)t.getPath());
            Assert.assertArrayEquals((byte[])sbytes, (byte[])tbytes);
        } else {
            FileStatus[] slist = this.dfs.listStatus(s.getPath());
            FileStatus[] tlist = this.dfs.listStatus(t.getPath());
            int minFiles = tlist.length;
            if (slist.length < tlist.length) {
                minFiles = slist.length;
            }
            for (int i = 0; i < minFiles; ++i) {
                if (slist[i].getPath().getName().contains(deletedName)) {
                    if (!tlist[i].getPath().getName().contains(deletedName)) continue;
                    throw new Exception("Target is not synced as per exclusion filter");
                }
                this.verifySync(slist[i], tlist[i], true, deletedName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSync11() throws Exception {
        java.nio.file.Path filterFile = null;
        try {
            Path sourcePath = new Path(this.dfs.getWorkingDirectory(), "source");
            this.initData11(sourcePath);
            this.dfs.allowSnapshot(sourcePath);
            this.dfs.createSnapshot(sourcePath, "s1");
            filterFile = this.generateFilterFile("filters");
            DistCpOptions.Builder builder = new DistCpOptions.Builder(new ArrayList<Path>(Arrays.asList(sourcePath)), this.target).withFiltersFile(filterFile.toString()).withSyncFolder(true);
            new DistCp(this.conf, builder.build()).execute();
            this.verifyCopy(this.dfs.getFileStatus(sourcePath), this.dfs.getFileStatus(this.target), false);
            this.dfs.allowSnapshot(this.target);
            this.dfs.createSnapshot(this.target, "s1");
            this.changeData11(sourcePath);
            this.dfs.createSnapshot(sourcePath, "s2");
            DistCpOptions.Builder diffBuilder = new DistCpOptions.Builder(new ArrayList<Path>(Arrays.asList(sourcePath)), this.target).withUseDiff("s1", "s2").withFiltersFile(filterFile.toString()).withSyncFolder(true);
            new DistCp(this.conf, diffBuilder.build()).execute();
            this.verifySync(this.dfs.getFileStatus(sourcePath), this.dfs.getFileStatus(this.target), false, ".staging");
        }
        catch (Throwable throwable) {
            this.deleteFilterFile(filterFile);
            throw throwable;
        }
        this.deleteFilterFile(filterFile);
    }

    @Test
    public void testSyncSnapshotDiffWithWebHdfs1() throws Exception {
        Path dfsSource = new Path(this.dfs.getUri().toString(), this.source);
        Path webHdfsTarget = new Path(this.webfs.getUri().toString(), this.target);
        this.snapshotDiffWithPaths(dfsSource, webHdfsTarget);
    }

    @Test
    public void testSyncSnapshotDiffWithWebHdfs2() throws Exception {
        Path webHdfsSource = new Path(this.webfs.getUri().toString(), this.source);
        Path dfsTarget = new Path(this.dfs.getUri().toString(), this.target);
        this.snapshotDiffWithPaths(webHdfsSource, dfsTarget);
    }

    @Test
    public void testSyncSnapshotDiffWithWebHdfs3() throws Exception {
        Path webHdfsSource = new Path(this.webfs.getUri().toString(), this.source);
        Path webHdfsTarget = new Path(this.webfs.getUri().toString(), this.target);
        this.snapshotDiffWithPaths(webHdfsSource, webHdfsTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWithFilter() throws Exception {
        java.nio.file.Path filterFile = null;
        try {
            Path sourcePath = new Path(this.dfs.getWorkingDirectory(), "source");
            this.dfs.mkdirs(new Path(sourcePath, "dir1"));
            this.dfs.mkdirs(new Path(sourcePath, "dir2"));
            this.dfs.allowSnapshot(sourcePath);
            this.dfs.createSnapshot(sourcePath, "s1");
            filterFile = Files.createTempFile("filters", "txt", new FileAttribute[0]);
            String str = ".*filterDir1.*";
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(filterFile.toString()));){
                writer.write(str);
            }
            DistCpOptions.Builder builder = new DistCpOptions.Builder(new ArrayList<Path>(Arrays.asList(sourcePath)), this.target).withFiltersFile(filterFile.toString()).withSyncFolder(true);
            new DistCp(this.conf, builder.build()).execute();
            ContractTestUtils.assertPathExists((FileSystem)this.dfs, (String)"dir1 should get copied to target", (Path)new Path(this.target, "dir1"));
            ContractTestUtils.assertPathExists((FileSystem)this.dfs, (String)"dir2 should get copied to target", (Path)new Path(this.target, "dir2"));
            this.dfs.allowSnapshot(this.target);
            this.dfs.createSnapshot(this.target, "s1");
            this.dfs.rename(new Path(sourcePath, "dir1"), new Path(sourcePath, "filterDir1"));
            ContractTestUtils.assertPathExists((FileSystem)this.dfs, (String)"'filterDir1' should be there on source", (Path)new Path(sourcePath, "filterDir1"));
            this.dfs.createSnapshot(sourcePath, "s2");
            DistCpOptions.Builder diffBuilder = new DistCpOptions.Builder(new ArrayList<Path>(Arrays.asList(sourcePath)), this.target).withUseDiff("s1", "s2").withFiltersFile(filterFile.toString()).withSyncFolder(true);
            new DistCp(this.conf, diffBuilder.build()).execute();
            ContractTestUtils.assertPathExists((FileSystem)this.dfs, (String)"dir2 should be there on target", (Path)new Path(this.target, "dir2"));
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.dfs, (String)"Filtered directory 'filterDir1' shouldn't get copied", (Path)new Path(this.target, "filterDir1"));
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.dfs, (String)"Renamed directory 'dir1' should get deleted", (Path)new Path(this.target, "dir1"));
            ContractTestUtils.assertPathDoesNotExist((FileSystem)this.dfs, (String)"Filtered directory 'filterDir1' shouldn't get copied to home directory", (Path)new Path("filterDir1"));
        }
        catch (Throwable throwable) {
            this.deleteFilterFile(filterFile);
            throw throwable;
        }
        this.deleteFilterFile(filterFile);
    }

    private void snapshotDiffWithPaths(Path sourceFSPath, Path targetFSPath) throws Exception {
        FileSystem sourceFS = sourceFSPath.getFileSystem(this.conf);
        FileSystem targetFS = targetFSPath.getFileSystem(this.conf);
        this.initData(sourceFS, sourceFSPath);
        this.initData(targetFS, targetFSPath);
        List<Path> paths = Arrays.asList(sourceFSPath, targetFSPath);
        for (Path path : paths) {
            FileSystem fs = path.getFileSystem(this.conf);
            if (fs instanceof DistributedFileSystem) {
                ((DistributedFileSystem)fs).allowSnapshot(path);
            } else if (fs instanceof WebHdfsFileSystem) {
                ((WebHdfsFileSystem)fs).allowSnapshot(path);
            } else {
                throw new IOException("Unsupported fs: " + fs.getScheme());
            }
            fs.createSnapshot(path, "s1");
        }
        this.changeData(sourceFS, sourceFSPath);
        sourceFS.createSnapshot(sourceFSPath, "s2");
        DistCpOptions options = new DistCpOptions.Builder(Collections.singletonList(sourceFSPath), targetFSPath).withUseDiff("s1", "s2").withSyncFolder(true).build();
        options.appendToConf(this.conf);
        new DistCp(this.conf, options).execute();
        this.verifyCopyByFs(sourceFS, targetFS, sourceFS.getFileStatus(sourceFSPath), targetFS.getFileStatus(targetFSPath), false);
    }

    @Test
    public void testSyncSnapshotDiffWithLocalFileSystem() throws Exception {
        String[] args = new String[]{"-update", "-diff", "s1", "s2", "file:///source", "file:///target"};
        LambdaTestUtils.intercept(UnsupportedOperationException.class, (String)"The source file system file does not support snapshot", () -> new DistCp(this.conf, OptionsParser.parse((String[])args)).execute());
    }

    @Test
    public void testSyncSnapshotDiffWithDummyFileSystem() {
        String[] args = new String[]{"-update", "-diff", "s1", "s2", "dummy:///source", "dummy:///target"};
        try {
            FileSystem dummyFs = FileSystem.get((URI)URI.create("dummy:///"), (Configuration)this.conf);
            AssertionsForClassTypes.assertThat((Object)dummyFs).isInstanceOf(DummyFs.class);
            new DistCp(this.conf, OptionsParser.parse((String[])args)).execute();
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class DummyFs
    extends RawLocalFileSystem {
        public URI getUri() {
            return URI.create("dummy:///");
        }

        public boolean hasPathCapability(Path path, String capability) throws IOException {
            switch (PathCapabilitiesSupport.validatePathCapabilityArgs((Path)this.makeQualified(path), (String)capability)) {
                case "fs.capability.paths.snapshots": {
                    return true;
                }
            }
            return super.hasPathCapability(path, capability);
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            return new FileStatus();
        }

        public SnapshotDiffReport getSnapshotDiffReport(Path snapshotDir, String fromSnapshot, String toSnapshot) {
            return new SnapshotDiffReport(snapshotDir.getName(), fromSnapshot, toSnapshot, new ArrayList());
        }
    }
}

