/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.tools.util.TestDistCpUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDistCpUtilsWithCombineMode {
    private static final Logger LOG = LoggerFactory.getLogger(TestDistCpUtils.class);
    private Configuration config;
    private MiniDFSCluster cluster;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void create() throws IOException {
        this.config = new Configuration();
        if (this.testName.getMethodName().contains("WithCombineMode")) {
            this.config.set("dfs.checksum.combine.mode", "COMPOSITE_CRC");
        }
        this.config.setLong("dfs.namenode.fs-limits.min-block-size", 512L);
        this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(2).format(true).build();
    }

    @After
    public void destroy() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testChecksumsComparisonWithCombineMode() throws IOException {
        try {
            this.compareSameContentButDiffBlockSizes();
        }
        catch (IOException e) {
            LOG.error("Unexpected exception is found", (Throwable)e);
            throw e;
        }
    }

    @Test
    public void testChecksumsComparisonWithoutCombineMode() {
        try {
            this.compareSameContentButDiffBlockSizes();
            Assert.fail((String)"Expected comparison to fail");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Checksum mismatch", (Throwable)e);
        }
    }

    private void compareSameContentButDiffBlockSizes() throws IOException {
        String base = "/tmp/verify-checksum-" + this.testName.getMethodName() + "/";
        long seed = System.currentTimeMillis();
        short rf = 2;
        FileSystem fs = FileSystem.get((Configuration)this.config);
        Path basePath = new Path(base);
        fs.mkdirs(basePath);
        Path src = new Path(base + "src");
        Path dst = new Path(base + "dst");
        DFSTestUtil.createFile((FileSystem)fs, (Path)src, (int)256, (long)1024L, (long)512L, (short)rf, (long)seed);
        DFSTestUtil.createFile((FileSystem)fs, (Path)dst, (int)256, (long)1024L, (long)1024L, (short)rf, (long)seed);
        DistCpUtils.compareFileLengthsAndChecksums((long)1024L, (FileSystem)fs, (Path)src, null, (FileSystem)fs, (Path)dst, (boolean)false, (long)1024L);
    }
}

