/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.mapred.DeletedDirTracker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDeletedDirTracker
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(TestDeletedDirTracker.class);
    public static final Path ROOT = new Path("hdfs://namenode/");
    public static final Path DIR1 = new Path(ROOT, "dir1");
    public static final Path FILE0 = new Path(ROOT, "file0");
    public static final Path DIR1_FILE1 = new Path(DIR1, "file1");
    public static final Path DIR1_FILE2 = new Path(DIR1, "file2");
    public static final Path DIR1_DIR3 = new Path(DIR1, "dir3");
    public static final Path DIR1_DIR3_DIR4 = new Path(DIR1_DIR3, "dir4");
    public static final Path DIR1_DIR3_DIR4_FILE_3 = new Path(DIR1_DIR3_DIR4, "file1");
    private DeletedDirTracker tracker;

    @Before
    public void setup() {
        this.tracker = new DeletedDirTracker(1000);
    }

    @After
    public void teardown() {
        LOG.info(this.tracker.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoRootDir() throws Throwable {
        this.shouldDelete(ROOT, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoRootFile() throws Throwable {
        this.shouldDelete(this.dirStatus(ROOT));
    }

    @Test
    public void testFileInRootDir() throws Throwable {
        this.expectShouldDelete(FILE0, false);
        this.expectShouldDelete(FILE0, false);
    }

    @Test
    public void testDeleteDir1() throws Throwable {
        this.expectShouldDelete(DIR1, true);
        this.expectShouldNotDelete(DIR1, true);
        this.expectShouldNotDelete(DIR1_FILE1, false);
        this.expectNotCached(DIR1_FILE1);
        this.expectShouldNotDelete(DIR1_DIR3, true);
        this.expectCached(DIR1_DIR3);
        this.expectShouldNotDelete(DIR1_FILE2, false);
        this.expectShouldNotDelete(DIR1_DIR3_DIR4_FILE_3, false);
        this.expectShouldNotDelete(DIR1_DIR3_DIR4, true);
        this.expectShouldNotDelete(DIR1_DIR3_DIR4, true);
    }

    @Test
    public void testDeleteDirDeep() throws Throwable {
        this.expectShouldDelete(DIR1, true);
        this.expectShouldNotDelete(DIR1_DIR3_DIR4_FILE_3, false);
    }

    @Test
    public void testDeletePerfectCache() throws Throwable {
        List<CopyListingFileStatus> statusList = this.buildStatusList();
        this.tracker = new DeletedDirTracker(statusList.size());
        AtomicInteger deletedFiles = new AtomicInteger(0);
        AtomicInteger deletedDirs = new AtomicInteger(0);
        this.deletePaths(statusList, deletedFiles, deletedDirs);
        TestDeletedDirTracker.assertEquals((long)0L, (long)deletedFiles.get());
    }

    @Test
    public void testDeleteFullCache() throws Throwable {
        AtomicInteger deletedFiles = new AtomicInteger(0);
        AtomicInteger deletedDirs = new AtomicInteger(0);
        this.deletePaths(this.buildStatusList(), deletedFiles, deletedDirs);
        TestDeletedDirTracker.assertEquals((long)0L, (long)deletedFiles.get());
    }

    @Test
    public void testDeleteMediumCache() throws Throwable {
        this.tracker = new DeletedDirTracker(100);
        AtomicInteger deletedFiles = new AtomicInteger(0);
        AtomicInteger deletedDirs = new AtomicInteger(0);
        this.deletePaths(this.buildStatusList(), deletedFiles, deletedDirs);
        TestDeletedDirTracker.assertEquals((long)0L, (long)deletedFiles.get());
    }

    @Test
    public void testDeleteFullSmallCache() throws Throwable {
        this.tracker = new DeletedDirTracker(10);
        AtomicInteger deletedFiles = new AtomicInteger(0);
        AtomicInteger deletedDirs = new AtomicInteger(0);
        this.deletePaths(this.buildStatusList(), deletedFiles, deletedDirs);
        TestDeletedDirTracker.assertEquals((long)0L, (long)deletedFiles.get());
    }

    protected void deletePaths(List<CopyListingFileStatus> statusList, AtomicInteger deletedFiles, AtomicInteger deletedDirs) {
        for (CopyListingFileStatus status : statusList) {
            if (!this.shouldDelete(status)) continue;
            AtomicInteger r = status.isDirectory() ? deletedDirs : deletedFiles;
            r.incrementAndGet();
            LOG.info("Delete {}", (Object)status.getPath());
        }
        LOG.info("After proposing to delete {} paths, {} directories and {} files were explicitly deleted from a cache {}", new Object[]{statusList.size(), deletedDirs, deletedFiles, this.tracker});
    }

    protected List<CopyListingFileStatus> buildStatusList() {
        ArrayList<CopyListingFileStatus> statusList = new ArrayList<CopyListingFileStatus>();
        for (int y = 0; y <= 20; ++y) {
            Path yp = new Path(String.format("YEAR=%d", y));
            statusList.add(this.dirStatus(yp));
            for (int m = 1; m <= 12; ++m) {
                Path ymp = new Path(yp, String.format("MONTH=%d", m));
                statusList.add(this.dirStatus(ymp));
                for (int d = 1; d < 30; ++d) {
                    Path dir = new Path(ymp, String.format("DAY=%02d", d));
                    statusList.add(this.dirStatus(dir));
                    for (int h = 0; h < 24; ++h) {
                        statusList.add(this.fileStatus(new Path(dir, String.format("%02d00.avro", h))));
                    }
                }
            }
            Collections.sort(statusList, (l, r) -> l.getPath().compareTo(r.getPath()));
        }
        return statusList;
    }

    private void expectShouldDelete(Path path, boolean isDir) {
        this.expectShouldDelete(this.newStatus(path, isDir));
    }

    private void expectShouldDelete(CopyListingFileStatus status) {
        TestDeletedDirTracker.assertTrue((String)("Expected shouldDelete of " + status.getPath()), (boolean)this.shouldDelete(status));
    }

    private boolean shouldDelete(Path path, boolean isDir) {
        return this.shouldDelete(this.newStatus(path, isDir));
    }

    private boolean shouldDelete(CopyListingFileStatus status) {
        return this.tracker.shouldDelete(status);
    }

    private void expectShouldNotDelete(Path path, boolean isDir) {
        this.expectShouldNotDelete(this.newStatus(path, isDir));
    }

    private void expectShouldNotDelete(CopyListingFileStatus status) {
        TestDeletedDirTracker.assertFalse((String)("Expected !shouldDelete of " + status.getPath() + " but got true"), (boolean)this.shouldDelete(status));
    }

    private CopyListingFileStatus newStatus(Path path, boolean isDir) {
        return new CopyListingFileStatus(new FileStatus(0L, isDir, 0, 0L, 0L, path));
    }

    private CopyListingFileStatus dirStatus(Path path) {
        return this.newStatus(path, true);
    }

    private CopyListingFileStatus fileStatus(Path path) {
        return this.newStatus(path, false);
    }

    private void expectCached(Path path) {
        TestDeletedDirTracker.assertTrue((String)("Path " + path + " is not in the cache of " + this.tracker), (boolean)this.tracker.isContained(path));
    }

    private void expectNotCached(Path path) {
        TestDeletedDirTracker.assertFalse((String)("Path " + path + " is in the cache of " + this.tracker), (boolean)this.tracker.isContained(path));
    }
}

