/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.apache.hadoop.tools.mapred.RetriableFileCopyCommand;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRetriableFileCopyCommand {
    @Test
    public void testFailOnCloseError() throws Exception {
        Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        ((Mapper.Context)Mockito.doReturn((Object)new Configuration()).when((Object)context)).getConfiguration();
        IOException expectedEx = new IOException("boom");
        OutputStream out = (OutputStream)Mockito.mock(OutputStream.class);
        ((OutputStream)Mockito.doThrow((Throwable)expectedEx).when((Object)out)).close();
        File f = File.createTempFile(this.getClass().getSimpleName(), null);
        f.deleteOnExit();
        CopyListingFileStatus stat = new CopyListingFileStatus(new FileStatus(1L, false, 1, 1024L, 0L, new Path(f.toURI())));
        Exception actualEx = null;
        try {
            new RetriableFileCopyCommand("testFailOnCloseError", CopyMapper.FileAction.OVERWRITE).copyBytes(stat, 0L, out, 512, context);
        }
        catch (Exception e) {
            actualEx = e;
        }
        Assert.assertNotNull((String)"close didn't fail", (Object)actualEx);
        Assert.assertEquals((Object)expectedEx, (Object)actualEx);
    }

    @Test(timeout=40000L)
    public void testGetNumBytesToRead() {
        long pos = 100L;
        long buffLength = 1024L;
        long fileLength = 2058L;
        RetriableFileCopyCommand retriableFileCopyCommand = new RetriableFileCopyCommand("Testing NumBytesToRead ", CopyMapper.FileAction.OVERWRITE);
        long numBytes = retriableFileCopyCommand.getNumBytesToRead(fileLength, pos, buffLength);
        Assert.assertEquals((long)1024L, (long)numBytes);
        pos += numBytes;
        numBytes = retriableFileCopyCommand.getNumBytesToRead(fileLength, pos, buffLength);
        Assert.assertEquals((long)934L, (long)numBytes);
        pos += numBytes;
        numBytes = retriableFileCopyCommand.getNumBytesToRead(fileLength, pos, buffLength);
        Assert.assertEquals((long)0L, (long)numBytes);
    }
}

