/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.FileBasedCopyListing;
import org.apache.hadoop.tools.GlobbedCopyListing;
import org.apache.hadoop.tools.util.DistCpUtils;

public abstract class CopyListing
extends Configured {
    private Credentials credentials;

    public final void buildListing(Path pathToListFile, DistCpOptions options) throws IOException {
        this.validatePaths(options);
        this.doBuildListing(pathToListFile, options);
        Configuration config = this.getConf();
        config.set("distcp.listing.file.path", pathToListFile.toString());
        config.setLong("mapred.total.bytes.expected", this.getBytesToCopy());
        config.setLong("mapred.number.of.records", this.getNumberOfPaths());
        this.validateFinalListing(pathToListFile, options);
    }

    protected abstract void validatePaths(DistCpOptions var1) throws IOException, InvalidInputException;

    protected abstract void doBuildListing(Path var1, DistCpOptions var2) throws IOException;

    protected abstract long getBytesToCopy();

    protected abstract long getNumberOfPaths();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateFinalListing(Path pathToListFile, DistCpOptions options) throws DuplicateFileException, IOException {
        Configuration config = this.getConf();
        FileSystem fs = pathToListFile.getFileSystem(config);
        Path sortedList = DistCpUtils.sortListing(fs, config, pathToListFile);
        SequenceFile.Reader reader = new SequenceFile.Reader(config, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sortedList)});
        try {
            Text lastKey = new Text("*");
            CopyListingFileStatus lastFileStatus = new CopyListingFileStatus();
            Text currentKey = new Text();
            HashSet aclSupportCheckFsSet = Sets.newHashSet();
            HashSet xAttrSupportCheckFsSet = Sets.newHashSet();
            while (reader.next((Writable)currentKey)) {
                FileSystem lastFs;
                URI lastFsUri;
                if (currentKey.equals((Object)lastKey)) {
                    CopyListingFileStatus currentFileStatus = new CopyListingFileStatus();
                    reader.getCurrentValue((Writable)currentFileStatus);
                    throw new DuplicateFileException("File " + lastFileStatus.getPath() + " and " + currentFileStatus.getPath() + " would cause duplicates. Aborting");
                }
                reader.getCurrentValue((Writable)lastFileStatus);
                if (options.shouldPreserve(DistCpOptions.FileAttribute.ACL) && !aclSupportCheckFsSet.contains(lastFsUri = (lastFs = lastFileStatus.getPath().getFileSystem(config)).getUri())) {
                    DistCpUtils.checkFileSystemAclSupport(lastFs);
                    aclSupportCheckFsSet.add(lastFsUri);
                }
                if (options.shouldPreserve(DistCpOptions.FileAttribute.XATTR) && !xAttrSupportCheckFsSet.contains(lastFsUri = (lastFs = lastFileStatus.getPath().getFileSystem(config)).getUri())) {
                    DistCpUtils.checkFileSystemXAttrSupport(lastFs);
                    xAttrSupportCheckFsSet.add(lastFsUri);
                }
                lastKey.set(currentKey);
            }
        }
        finally {
            IOUtils.closeStream((Closeable)reader);
        }
    }

    protected CopyListing(Configuration configuration, Credentials credentials) {
        this.setConf(configuration);
        this.setCredentials(credentials);
    }

    protected void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    protected Credentials getCredentials() {
        return this.credentials;
    }

    public static CopyListing getCopyListing(Configuration configuration, Credentials credentials, DistCpOptions options) throws IOException {
        if (options.shouldUseDiff()) {
            return new GlobbedCopyListing(configuration, credentials);
        }
        String copyListingClassName = configuration.get("distcp.copy.listing.class", "");
        try {
            Class copyListingClass = !copyListingClassName.isEmpty() ? configuration.getClass("distcp.copy.listing.class", GlobbedCopyListing.class, CopyListing.class) : (options.getSourceFileListing() == null ? GlobbedCopyListing.class : FileBasedCopyListing.class);
            copyListingClassName = copyListingClass.getName();
            Constructor constructor = copyListingClass.getDeclaredConstructor(Configuration.class, Credentials.class);
            return (CopyListing)((Object)constructor.newInstance(configuration, credentials));
        }
        catch (Exception e) {
            throw new IOException("Unable to instantiate " + copyListingClassName, e);
        }
    }

    public static class XAttrsNotSupportedException
    extends RuntimeException {
        public XAttrsNotSupportedException(String message) {
            super(message);
        }
    }

    public static class AclsNotSupportedException
    extends RuntimeException {
        public AclsNotSupportedException(String message) {
            super(message);
        }
    }

    static class InvalidInputException
    extends RuntimeException {
        public InvalidInputException(String message) {
            super(message);
        }
    }

    static class DuplicateFileException
    extends RuntimeException {
        public DuplicateFileException(String message) {
            super(message);
        }
    }
}

